model["bodyDown"].setPos({0,24,0})

local neckPart = model.bodyDown.bodyUp.neck

renderer.setShadowSize(1.0)

local current_idle_anim = animation.idle;
local current_running_anim = animation.running;

local prev_sneaking_state = nil
local prev_sprinting_state = nil

local run_idle_weight = 0;
local jump_weight = 0;
local jumpInPrevFrame = false;

local attackKeybind = keybind.getRegisteredKeybind("key.attack")

function clamp(value,low,high)
    return math.min(math.max(value, low), high)
end

function lerp(a, b, x)
    return a + (b - a) * x
end

function player_init()
    parseAnims(0)
    animation.swipe.setPriority(2)
end

function parseAnims(delta)
    if animation.swipe.getPlayState() ~= "PLAYING" then
        if (player.isSneaking() ~= prev_sneaking_state) then
            current_idle_anim.stop()
            current_running_anim.stop()
            if (player.isSneaking()) then
                current_idle_anim = animation.crouching_idle
                current_running_anim = animation.crouching
                model["bodyDown"].setPos({0,22,0})
            else 
                current_idle_anim = animation.idle
                current_running_anim = animation.running
                model["bodyDown"].setPos({0,24,0})
            end
            current_idle_anim.play()
            current_running_anim.play()
            prev_sneaking_state = player.isSneaking()
        end
        if (player.isSprinting() ~= prev_sprinting_state) then
            current_idle_anim.stop()
            current_running_anim.stop()
            if (player.isSprinting()) then
                current_idle_anim = animation.idle
                current_running_anim = animation.sprinting
                model["bodyDown"].setPos({0,24,0})
            else 
                current_idle_anim = animation.idle
                current_running_anim = animation.running
                model["bodyDown"].setPos({0,24,0})
            end
            current_idle_anim.play()
            current_running_anim.play()
            prev_sprinting_state = player.isSprinting()
        end
        local vel = player.getVelocity()
        local run_weight = clamp(math.sqrt(math.pow(vel[1], 2) + math.pow(vel[3], 2)) * 20,0,2) / 2
        current_idle_anim.setBlendWeight(clamp((1-run_idle_weight)-jump_weight,0,1))
        current_running_anim.setBlendWeight(clamp(run_idle_weight-jump_weight,0,1))
        local jw = clamp(vel[2] * 20, 0, 2) / 2
    
        jump_weight = clamp(jump_weight + lerp(-delta, delta, jw), 0, 1)
        run_idle_weight = clamp(run_idle_weight + lerp(-delta, delta, run_weight), 0, 1)
    
        if (not jumpInPrevFrame) and jump_weight > 0 then
            jumpInPrevFrame = true
            animation.jump.play()
        end
        if jumpInPrevFrame and jump_weight == 0 then
            jumpInPrevFrame = false
            animation.jump.stop()
        end
        animation.jump.setBlendWeight(jump_weight) 
    end

    if attackKeybind.wasPressed() then
        animation.stopAll()
        animation.swipe.start()
        prev_sneaking_state = nil
        prev_sprinting_state = nil
    end
end

function render(delta) 
    local origin_rot = vanilla_model.HEAD.getOriginRot();
    neckPart.setRot({-math.deg(origin_rot[1]),-math.deg(origin_rot[2]),math.deg(origin_rot[3])})
    parseAnims(delta / 5)
end

for k, v in pairs(vanilla_model) do
    v.setEnabled(false)
end