/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client;

import com.github.franckyi.ibeeditor.ClientPlatformUtil;
import com.github.franckyi.ibeeditor.client.ClientUtil;
import com.github.franckyi.ibeeditor.client.KeyBindings;
import com.github.franckyi.ibeeditor.client.ModScreenHandler;
import com.github.franckyi.ibeeditor.client.logic.ClientEditorRequestLogic;
import com.github.franckyi.ibeeditor.common.EditorType;
import com.github.franckyi.ibeeditor.common.ModTexts;
import net.minecraft.class_2561;
import net.minecraft.class_465;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClientEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onKeyInput() {
        try {
            if (KeyBindings.getEditorKey().method_1436()) {
                ClientEditorRequestLogic.requestWorldEditor(EditorType.STANDARD);
            } else if (KeyBindings.getNBTEditorKey().method_1436()) {
                ClientEditorRequestLogic.requestWorldEditor(EditorType.NBT);
            } else if (KeyBindings.getSNBTEditorKey().method_1436()) {
                ClientEditorRequestLogic.requestWorldEditor(EditorType.SNBT);
            } else if (KeyBindings.getVaultKey().method_1436()) {
                ModScreenHandler.openVault();
            }
        }
        catch (Exception e) {
            ClientUtil.showMessage((class_2561)ModTexts.Messages.ERROR_GENERIC);
            LOGGER.error("Error while handling ingame key input for IBE Editor mod", (Throwable)e);
        }
    }

    public static boolean onScreenEvent(class_465<?> screen, int keyCode) {
        try {
            if (keyCode == ClientPlatformUtil.getKeyCode(KeyBindings.getEditorKey())) {
                return ClientEditorRequestLogic.requestInventoryItemEditor(EditorType.STANDARD, screen);
            }
            if (keyCode == ClientPlatformUtil.getKeyCode(KeyBindings.getNBTEditorKey())) {
                return ClientEditorRequestLogic.requestInventoryItemEditor(EditorType.NBT, screen);
            }
            if (keyCode == ClientPlatformUtil.getKeyCode(KeyBindings.getSNBTEditorKey())) {
                return ClientEditorRequestLogic.requestInventoryItemEditor(EditorType.SNBT, screen);
            }
            if (keyCode == ClientPlatformUtil.getKeyCode(KeyBindings.getVaultKey())) {
                ModScreenHandler.openVault();
                return true;
            }
        }
        catch (Exception e) {
            ClientUtil.showMessage((class_2561)ModTexts.Messages.ERROR_GENERIC);
            LOGGER.error("Error while handling screen key input for IBE Editor mod", (Throwable)e);
        }
        return false;
    }
}

