/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.screens.armorstand;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.armorstatues.api.StatuesApi;
import fuzs.armorstatues.api.client.gui.components.TickingButton;
import fuzs.armorstatues.api.client.gui.components.UnboundedSliderButton;
import fuzs.armorstatues.api.client.gui.screens.armorstand.ArmorStandScreen;
import fuzs.armorstatues.api.client.gui.screens.armorstand.ArmorStandScreenFactory;
import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.ArmorStandMenu;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import java.util.Optional;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_3936;
import net.minecraft.class_407;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import net.minecraft.class_918;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractArmorStandScreen
extends class_437
implements class_3936<ArmorStandMenu>,
ArmorStandScreen {
    public static final String VANILLA_TWEAKS_HOMEPAGE = "https://vanillatweaks.net/";
    public static final String CREDITS_TRANSLATION_KEY = "statues.screen.credits";
    private static final class_2960 ARMOR_STAND_BACKGROUND_LOCATION = StatuesApi.id("textures/gui/container/statue/background.png");
    private static final class_2960 ARMOR_STAND_WIDGETS_LOCATION = StatuesApi.id("textures/gui/container/statue/widgets.png");
    private static final class_2960 ARMOR_STAND_EQUIPMENT_LOCATION = StatuesApi.id("textures/gui/container/statue/equipment.png");
    @Nullable
    static ArmorStandScreenType lastScreenType;
    protected final int imageWidth = 210;
    protected final int imageHeight = 188;
    protected final ArmorStandHolder holder;
    private final class_1661 inventory;
    protected final DataSyncHandler dataSyncHandler;
    protected int leftPos;
    protected int topPos;
    protected int inventoryEntityX;
    protected int inventoryEntityY;
    protected boolean smallInventoryEntity;
    protected int mouseX;
    protected int mouseY;
    @Nullable
    private class_339 closeButton;

    public AbstractArmorStandScreen(ArmorStandHolder holder, class_1661 inventory, class_2561 component, DataSyncHandler dataSyncHandler) {
        super(component);
        this.holder = holder;
        this.inventory = inventory;
        this.dataSyncHandler = dataSyncHandler;
    }

    public static class_2960 getArmorStandBackgroundLocation() {
        return ARMOR_STAND_BACKGROUND_LOCATION;
    }

    public static class_2960 getArmorStandWidgetsLocation() {
        return ARMOR_STAND_WIDGETS_LOCATION;
    }

    public static class_2960 getArmorStandEquipmentLocation() {
        return ARMOR_STAND_EQUIPMENT_LOCATION;
    }

    @Override
    public ArmorStandHolder getHolder() {
        return this.holder;
    }

    @Override
    public DataSyncHandler getDataSyncHandler() {
        return this.dataSyncHandler;
    }

    @Override
    public <T extends class_437 & ArmorStandScreen> T createScreenType(ArmorStandScreenType screenType) {
        Object screen = ArmorStandScreenFactory.createScreenType(screenType, this.holder, this.inventory, this.field_22785, this.dataSyncHandler);
        ((ArmorStandScreen)screen).setMouseX(this.mouseX);
        ((ArmorStandScreen)screen).setMouseY(this.mouseY);
        return screen;
    }

    @Override
    public void setMouseX(int mouseX) {
        this.mouseX = mouseX;
    }

    @Override
    public void setMouseY(int mouseY) {
        this.mouseY = mouseY;
    }

    public void method_25393() {
        this.dataSyncHandler.tick();
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof TickingButton)) continue;
            TickingButton button = (TickingButton)child;
            button.tick();
        }
    }

    protected void method_25426() {
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        if (this.withCloseButton()) {
            this.closeButton = (class_339)this.method_37063((class_364)AbstractArmorStandScreen.makeCloseButton(this, this.leftPos, this.imageWidth, this.topPos));
        }
    }

    public static class_4264 makeCloseButton(class_437 screen, int leftPos, int imageWidth, int topPos) {
        return new class_344(leftPos + imageWidth - 15 - 8, topPos + 8, 15, 15, 136, 0, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), button -> screen.method_25419());
    }

    protected boolean withCloseButton() {
        return true;
    }

    protected boolean renderInventoryEntity() {
        return true;
    }

    protected boolean disableMenuRendering() {
        return false;
    }

    protected void toggleMenuRendering(boolean disableMenuRendering) {
        if (this.closeButton != null) {
            this.closeButton.field_22764 = !disableMenuRendering;
        }
    }

    protected void addVanillaTweaksCreditsButton() {
        this.method_37063((class_364)new class_344(this.leftPos + 6, this.topPos + 6, 20, 20, 136, 64, 20, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), 256, 256, button -> this.field_22787.method_1507((class_437)new class_407(bl -> {
            if (bl) {
                class_156.method_668().method_670(VANILLA_TWEAKS_HOMEPAGE);
            }
            this.field_22787.method_1507((class_437)this);
        }, VANILLA_TWEAKS_HOMEPAGE, true))));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && !this.disableMenuRendering() && AbstractArmorStandScreen.handleTabClicked((int)mouseX, (int)mouseY, this.leftPos, this.topPos, this.imageHeight, this, this.dataSyncHandler.getScreenTypes())) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        if (!this.disableMenuRendering()) {
            this.method_25420(poseStack);
        }
        this.renderBg(poseStack, partialTick, mouseX, mouseY);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        if (!this.disableMenuRendering()) {
            AbstractArmorStandScreen.findHoveredTab(this.leftPos, this.topPos, this.imageHeight, mouseX, mouseY, this.dataSyncHandler.getScreenTypes()).ifPresent(hoveredTab -> this.method_25424(poseStack, (class_2561)class_2561.method_43471((String)hoveredTab.getTranslationKey()), mouseX, mouseY));
        }
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    protected void renderBg(class_4587 poseStack, float partialTick, int mouseX, int mouseY) {
        if (!this.disableMenuRendering()) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)AbstractArmorStandScreen.getArmorStandBackgroundLocation());
            AbstractArmorStandScreen.method_25302((class_4587)poseStack, (int)this.leftPos, (int)this.topPos, (int)0, (int)0, (int)this.imageWidth, (int)this.imageHeight);
            AbstractArmorStandScreen.drawTabs(poseStack, this.leftPos, this.topPos, this.imageHeight, this, this.dataSyncHandler.getScreenTypes());
            this.renderEntityInInventory(poseStack);
        }
    }

    private void renderEntityInInventory(class_4587 poseStack) {
        if (this.renderInventoryEntity()) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)AbstractArmorStandScreen.getArmorStandWidgetsLocation());
            if (this.smallInventoryEntity) {
                AbstractArmorStandScreen.method_25302((class_4587)poseStack, (int)(this.leftPos + this.inventoryEntityX), (int)(this.topPos + this.inventoryEntityY), (int)200, (int)184, (int)50, (int)72);
                this.renderArmorStandInInventory(poseStack, this.leftPos + this.inventoryEntityX + 24, this.topPos + this.inventoryEntityY + 65, 30, this.leftPos + this.inventoryEntityX + 24 - 10 - this.mouseX, this.topPos + this.inventoryEntityY + 65 - 44 - this.mouseY);
            } else {
                AbstractArmorStandScreen.method_25302((class_4587)poseStack, (int)(this.leftPos + this.inventoryEntityX), (int)(this.topPos + this.inventoryEntityY), (int)0, (int)0, (int)76, (int)108);
                this.renderArmorStandInInventory(poseStack, this.leftPos + this.inventoryEntityX + 38, this.topPos + this.inventoryEntityY + 98, 45, (float)(this.leftPos + this.inventoryEntityX + 38 - 5) - (float)this.mouseX, (float)(this.topPos + this.inventoryEntityY + 98 - 66) - (float)this.mouseY);
            }
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        boolean mouseReleased = false;
        for (class_364 child : this.method_25396()) {
            UnboundedSliderButton sliderButton;
            if (!(child instanceof UnboundedSliderButton) || !(sliderButton = (UnboundedSliderButton)child).isDirty()) continue;
            mouseReleased |= child.method_25406(mouseX, mouseY, button);
        }
        return mouseReleased || super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return AbstractArmorStandScreen.handleHotbarKeyPressed(keyCode, scanCode, this, this.dataSyncHandler.getScreenTypes());
    }

    public static <T extends class_437> boolean handleHotbarKeyPressed(int keyCode, int scanCode, T screen, ArmorStandScreenType[] tabs) {
        class_310 minecraft = class_310.method_1551();
        for (int i = 0; i < Math.min(tabs.length, 9); ++i) {
            if (!minecraft.field_1690.field_1852[i].method_1417(keyCode, scanCode) || !AbstractArmorStandScreen.openTabScreen(screen, tabs[i], true)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (super.method_25401(mouseX, mouseY, delta)) {
            return true;
        }
        return AbstractArmorStandScreen.handleMouseScrolled((int)mouseX, (int)mouseY, delta, this.leftPos, this.topPos, this.imageHeight, this, this.dataSyncHandler.getScreenTypes());
    }

    public static <T extends class_437> boolean handleMouseScrolled(int mouseX, int mouseY, double delta, int leftPos, int topPos, int imageHeight, T screen, ArmorStandScreenType[] tabs) {
        Optional<ArmorStandScreenType> optional;
        if ((delta = Math.signum(delta)) != 0.0 && (optional = AbstractArmorStandScreen.findHoveredTab(leftPos, topPos, imageHeight, mouseX, mouseY, tabs)).isPresent()) {
            ArmorStandScreenType screenType = AbstractArmorStandScreen.cycleTabs(((ArmorStandScreen)screen).getScreenType(), tabs, delta > 0.0);
            return AbstractArmorStandScreen.openTabScreen(screen, screenType, false);
        }
        return false;
    }

    public static <T extends class_437> boolean handleTabClicked(int mouseX, int mouseY, int leftPos, int topPos, int imageHeight, T screen, ArmorStandScreenType[] tabs) {
        Optional<ArmorStandScreenType> hoveredTab = AbstractArmorStandScreen.findHoveredTab(leftPos, topPos, imageHeight, mouseX, mouseY, tabs);
        return hoveredTab.filter(armorStandScreenType -> AbstractArmorStandScreen.openTabScreen(screen, armorStandScreenType, true)).isPresent();
    }

    private static <T extends class_437> boolean openTabScreen(T screen, ArmorStandScreenType screenType, boolean clickSound) {
        if (screenType != ((ArmorStandScreen)screen).getScreenType()) {
            class_310 minecraft = class_310.method_1551();
            if (clickSound) {
                class_1109 sound = class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f);
                minecraft.method_1483().method_4873((class_1113)sound);
            }
            minecraft.method_1507(((ArmorStandScreen)screen).createScreenType(screenType));
            return true;
        }
        return false;
    }

    private static ArmorStandScreenType cycleTabs(ArmorStandScreenType currentScreenType, ArmorStandScreenType[] screenTypes, boolean backwards) {
        int index = ArrayUtils.indexOf((Object[])screenTypes, (Object)currentScreenType);
        return screenTypes[((backwards ? --index : ++index) % screenTypes.length + screenTypes.length) % screenTypes.length];
    }

    public static <T extends class_437> void drawTabs(class_4587 poseStack, int leftPos, int topPos, int imageHeight, T screen, ArmorStandScreenType[] tabs) {
        int tabsStartY = AbstractArmorStandScreen.getTabsStartY(imageHeight, tabs.length);
        for (int i = 0; i < tabs.length; ++i) {
            ArmorStandScreenType tabType = tabs[i];
            int tabX = leftPos - 32;
            int tabY = topPos + tabsStartY + 27 * i;
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)AbstractArmorStandScreen.getArmorStandBackgroundLocation());
            class_332.method_25290((class_4587)poseStack, (int)tabX, (int)tabY, (float)(tabY <= topPos ? 36.0f : (tabY >= topPos + imageHeight - 36 ? 72.0f : 0.0f)), (float)(188 + (tabType == ((ArmorStandScreen)screen).getScreenType() ? 0 : 26)), (int)36, (int)26, (int)256, (int)256);
            class_918 itemRenderer = class_310.method_1551().method_1480();
            itemRenderer.method_4023(poseStack, tabType.getIcon(), tabX + 10, tabY + 5);
        }
    }

    public static Optional<ArmorStandScreenType> findHoveredTab(int leftPos, int topPos, int imageHeight, int mouseX, int mouseY, ArmorStandScreenType[] tabs) {
        int tabsStartY = AbstractArmorStandScreen.getTabsStartY(imageHeight, tabs.length);
        for (int i = 0; i < tabs.length; ++i) {
            int tabX = leftPos - 32;
            int tabY = topPos + tabsStartY + 27 * i;
            if (mouseX <= tabX || mouseX > tabX + 32 || mouseY <= tabY || mouseY > tabY + 26) continue;
            return Optional.of(tabs[i]);
        }
        return Optional.empty();
    }

    private static int getTabsStartY(int imageHeight, int tabsCount) {
        int tabsHeight = tabsCount * 26 + (tabsCount - 1);
        return (imageHeight - tabsHeight) / 2;
    }

    public ArmorStandMenu getMenu() {
        return (ArmorStandMenu)this.holder;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25432() {
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof UnboundedSliderButton)) continue;
            UnboundedSliderButton sliderButton = (UnboundedSliderButton)child;
            sliderButton.clearDirty();
        }
    }

    public void method_25419() {
        if (this.holder instanceof class_1703) {
            this.field_22787.field_1724.method_7346();
        }
        super.method_25419();
    }
}

