/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.screens.armorstand;

import fuzs.armorstatues.api.client.gui.screens.armorstand.AbstractArmorStandScreen;
import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1531;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4587;

public class ArmorStandPosesScreen
extends AbstractArmorStandScreen {
    public static final String POSE_SOURCE_TRANSLATION_KEY = "statues.screen.pose.by";
    private static final int POSES_PER_PAGE = 4;
    private static int firstPoseIndex;
    private final class_339[] cycleButtons = new class_339[2];
    private final class_339[] poseButtons = new class_339[4];

    public ArmorStandPosesScreen(ArmorStandHolder holder, class_1661 inventory, class_2561 component, DataSyncHandler dataSyncHandler) {
        super(holder, inventory, component, dataSyncHandler);
        this.inventoryEntityX = 5;
        this.inventoryEntityY = 40;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.cycleButtons[0] = (class_339)this.method_37063((class_364)new class_344(this.leftPos + 17, this.topPos + 153, 20, 20, 156, 64, ArmorStandPosesScreen.getArmorStandWidgetsLocation(), button -> this.toggleCycleButtons(-4)));
        this.cycleButtons[1] = (class_339)this.method_37063((class_364)new class_344(this.leftPos + 49, this.topPos + 153, 20, 20, 176, 64, ArmorStandPosesScreen.getArmorStandWidgetsLocation(), button -> this.toggleCycleButtons(4)));
        for (int i = 0; i < this.poseButtons.length; ++i) {
            int index = i;
            this.poseButtons[i] = (class_339)this.method_37063((class_364)new class_344(this.leftPos + 83 + i % 2 * 62, this.topPos + 9 + i / 2 * 88, 60, 82, 76, 0, 82, ArmorStandPosesScreen.getArmorStandWidgetsLocation(), 256, 256, button -> ArmorStandPosesScreen.getPoseAt(index).ifPresent(this.dataSyncHandler::sendPose)));
        }
        this.toggleCycleButtons(0);
        this.addVanillaTweaksCreditsButton();
    }

    private void toggleCycleButtons(int increment) {
        int newFirstPoseIndex = firstPoseIndex + increment;
        if (newFirstPoseIndex >= 0 && newFirstPoseIndex < ArmorStandPose.valuesLength()) {
            firstPoseIndex = newFirstPoseIndex;
            this.cycleButtons[0].field_22763 = newFirstPoseIndex - 4 >= 0;
            this.cycleButtons[1].field_22763 = newFirstPoseIndex + 4 < ArmorStandPose.valuesLength();
            for (int i = 0; i < this.poseButtons.length; ++i) {
                this.poseButtons[i].field_22764 = ArmorStandPosesScreen.getPoseAt(i).isPresent();
            }
        }
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (super.method_25401(mouseX, mouseY, delta)) {
            return true;
        }
        if (mouseX >= (double)this.leftPos) {
            Objects.requireNonNull(this);
            if (mouseX < (double)(this.leftPos + 210) && mouseY >= (double)this.topPos) {
                Objects.requireNonNull(this);
                if (mouseY < (double)(this.topPos + 188) && (delta = Math.signum(delta)) != 0.0) {
                    this.toggleCycleButtons((int)(-1.0 * delta * 4.0));
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void renderBg(class_4587 poseStack, float partialTick, int mouseX, int mouseY) {
        super.renderBg(poseStack, partialTick, mouseX, mouseY);
        class_1531 armorStand = this.holder.getArmorStand();
        ArmorStandPose entityPose = ArmorStandPose.fromEntity(armorStand);
        for (int i = 0; i < 4; ++i) {
            Optional<ArmorStandPose> pose = ArmorStandPosesScreen.getPoseAt(i);
            if (!pose.isPresent()) continue;
            pose.get().applyToEntity(armorStand);
            this.renderArmorStandInInventory(poseStack, this.leftPos + 112 + i % 2 * 62, this.topPos + 79 + i / 2 * 88, 30, this.leftPos + 112 + i % 2 * 62 - 10 - this.mouseX, this.topPos + 79 + i / 2 * 88 - 44 - this.mouseY);
        }
        entityPose.applyToEntity(armorStand);
    }

    @Override
    protected boolean withCloseButton() {
        return false;
    }

    @Override
    public ArmorStandScreenType getScreenType() {
        return ArmorStandScreenType.POSES;
    }

    private static Optional<ArmorStandPose> getPoseAt(int index) {
        if ((index += firstPoseIndex) >= ArmorStandPose.valuesLength()) {
            return Optional.empty();
        }
        return Optional.of(ArmorStandPose.values()[index]);
    }
}

