/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.screens.armorstand;

import com.google.common.collect.Maps;
import fuzs.armorstatues.api.client.gui.components.BoxedSliderButton;
import fuzs.armorstatues.api.client.gui.components.LiveSliderButton;
import fuzs.armorstatues.api.client.gui.components.NewTextureTickButton;
import fuzs.armorstatues.api.client.gui.components.VerticalSliderButton;
import fuzs.armorstatues.api.client.gui.screens.armorstand.AbstractArmorStandScreen;
import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import fuzs.armorstatues.api.world.inventory.data.PosePartMutator;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.DoubleSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1531;
import net.minecraft.class_1661;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class ArmorStandRotationsScreen
extends AbstractArmorStandScreen {
    public static final String TIP_TRANSLATION_KEY = "statues.screen.rotations.tip";
    public static final String UNLIMITED_TRANSLATION_KEY = "statues.screen.rotations.unlimited";
    public static final String LIMITED_TRANSLATION_KEY = "statues.screen.rotations.limited";
    public static final String RESET_TRANSLATION_KEY = "statues.screen.rotations.reset";
    public static final String RANDOMIZE_TRANSLATION_KEY = "statues.screen.rotations.randomize";
    public static final String PASTE_TRANSLATION_KEY = "statues.screen.rotations.paste";
    public static final String COPY_TRANSLATION_KEY = "statues.screen.rotations.copy";
    public static final String MIRROR_TRANSLATION_KEY = "statues.screen.rotations.mirror";
    private static final Map<PosePartMutator, Predicate<class_1531>> POSE_PART_MUTATOR_FILTERS = Maps.newHashMap();
    private static boolean clampRotations = true;
    @Nullable
    private static ArmorStandPose clipboard;
    private final class_339[] lockButtons = new class_339[2];
    private ArmorStandPose currentPose;

    public ArmorStandRotationsScreen(ArmorStandHolder holder, class_1661 inventory, class_2561 component, DataSyncHandler dataSyncHandler) {
        super(holder, inventory, component, dataSyncHandler);
        this.inventoryEntityX = 80;
        this.inventoryEntityY = 58;
        this.smallInventoryEntity = true;
        this.currentPose = ArmorStandPose.fromEntity(holder.getArmorStand());
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.lockButtons[0] = (class_339)this.method_37063((class_364)new class_344(this.leftPos + 83, this.topPos + 10, 20, 20, 156, 124, 20, ArmorStandRotationsScreen.getArmorStandWidgetsLocation(), 256, 256, button -> {
            clampRotations = true;
            this.toggleLockButtons();
            this.refreshLiveButtons();
        }));
        this.lockButtons[1] = (class_339)this.method_37063((class_364)new class_344(this.leftPos + 83, this.topPos + 10, 20, 20, 136, 124, 20, ArmorStandRotationsScreen.getArmorStandWidgetsLocation(), 256, 256, button -> {
            clampRotations = false;
            this.toggleLockButtons();
            this.refreshLiveButtons();
        }));
        class_2561 tipComponent = this.getTipComponent();
        if (tipComponent != null) {
            this.method_37063((class_364)new class_344(this.leftPos + 107, this.topPos + 10, 20, 20, 136, 64, 20, ArmorStandRotationsScreen.getArmorStandWidgetsLocation(), 256, 256, button -> {}));
        }
        this.method_37063((class_364)new NewTextureTickButton(this.leftPos + 107, this.topPos + 34, 20, 20, 240, 124, ArmorStandRotationsScreen.getArmorStandWidgetsLocation(), button -> this.setCurrentPose(ArmorStandPose.EMPTY)));
        this.method_37063((class_364)new NewTextureTickButton(this.leftPos + 83, this.topPos + 34, 20, 20, 192, 124, ArmorStandRotationsScreen.getArmorStandWidgetsLocation(), button -> this.setCurrentPose(this.holder.getDataProvider().getRandomPose(true))));
        class_339 pasteButton = (class_339)this.method_37063((class_364)new NewTextureTickButton(this.leftPos + 107, this.topPos + 158, 20, 20, 224, 124, ArmorStandRotationsScreen.getArmorStandWidgetsLocation(), button -> {
            if (clipboard != null) {
                this.setCurrentPose(clipboard);
            }
        }));
        pasteButton.field_22763 = clipboard != null;
        this.method_37063((class_364)new NewTextureTickButton(this.leftPos + 83, this.topPos + 158, 20, 20, 208, 124, ArmorStandRotationsScreen.getArmorStandWidgetsLocation(), button -> {
            clipboard = this.currentPose;
            pasteButton.field_22763 = true;
        }));
        this.method_37063((class_364)new NewTextureTickButton(this.leftPos + 83, this.topPos + 134, 44, 20, 179, 0, ArmorStandRotationsScreen.getArmorStandWidgetsLocation(), button -> this.setCurrentPose(this.currentPose.mirror())));
        PosePartMutator[] values = this.holder.getDataProvider().getPosePartMutators();
        ArmorStandPose.checkMutatorsSize(values);
        for (int i = 0; i < values.length; ++i) {
            final PosePartMutator mutator = values[i];
            boolean isLeft = i % 2 == 0;
            (this.method_37063((class_364)new BoxedSliderButton((int)(this.leftPos + 23 + i % 2 * 110), (int)(this.topPos + 7 + i / 2 * 60), (DoubleSupplier)(DoubleSupplier)LambdaMetafactory.metafactory(null, null, null, ()D, lambda$init$8(fuzs.armorstatues.api.world.inventory.data.PosePartMutator ), ()D)((ArmorStandRotationsScreen)this, (PosePartMutator)mutator), (DoubleSupplier)(DoubleSupplier)LambdaMetafactory.metafactory(null, null, null, ()D, lambda$init$9(fuzs.armorstatues.api.world.inventory.data.PosePartMutator ), ()D)((ArmorStandRotationsScreen)this, (PosePartMutator)mutator), (BoxedSliderButton.OnTooltip)(BoxedSliderButton.OnTooltip)LambdaMetafactory.metafactory(null, null, null, (Lfuzs/armorstatues/api/client/gui/components/BoxedSliderButton;Lnet/minecraft/class_4587;II)V, lambda$init$10(fuzs.armorstatues.api.world.inventory.data.PosePartMutator boolean fuzs.armorstatues.api.client.gui.components.BoxedSliderButton net.minecraft.class_4587 int int ), (Lfuzs/armorstatues/api/client/gui/components/BoxedSliderButton;Lnet/minecraft/class_4587;II)V)((ArmorStandRotationsScreen)this, (PosePartMutator)mutator, (boolean)isLeft)){
                private boolean dirty;

                @Override
                protected void applyValue() {
                    this.dirty = true;
                    ArmorStandRotationsScreen.this.currentPose = mutator.setRotationsAtAxis(1, ArmorStandRotationsScreen.this.currentPose, this.horizontalValue, clampRotations);
                    ArmorStandRotationsScreen.this.currentPose = mutator.setRotationsAtAxis(0, ArmorStandRotationsScreen.this.currentPose, this.verticalValue, clampRotations);
                }

                @Override
                public void method_25357(double mouseX, double mouseY) {
                    super.method_25357(mouseX, mouseY);
                    this.clearDirty();
                }

                @Override
                public boolean isDirty() {
                    return this.dirty;
                }

                @Override
                public void clearDirty() {
                    if (this.isDirty()) {
                        this.dirty = false;
                        ArmorStandRotationsScreen.this.setCurrentPose(ArmorStandRotationsScreen.this.currentPose);
                    }
                }
            })).field_22763 = ArmorStandRotationsScreen.isPosePartMutatorActive(mutator, this.holder.getArmorStand());
            (this.method_37063((class_364)new VerticalSliderButton((int)(this.leftPos + 6 + i % 2 * 183), (int)(this.topPos + 7 + i / 2 * 60), (DoubleSupplier)(DoubleSupplier)LambdaMetafactory.metafactory(null, null, null, ()D, lambda$init$11(fuzs.armorstatues.api.world.inventory.data.PosePartMutator ), ()D)((ArmorStandRotationsScreen)this, (PosePartMutator)mutator), (VerticalSliderButton.OnTooltip)(VerticalSliderButton.OnTooltip)LambdaMetafactory.metafactory(null, null, null, (Lfuzs/armorstatues/api/client/gui/components/VerticalSliderButton;Lnet/minecraft/class_4587;II)V, lambda$init$12(fuzs.armorstatues.api.world.inventory.data.PosePartMutator boolean fuzs.armorstatues.api.client.gui.components.VerticalSliderButton net.minecraft.class_4587 int int ), (Lfuzs/armorstatues/api/client/gui/components/VerticalSliderButton;Lnet/minecraft/class_4587;II)V)((ArmorStandRotationsScreen)this, (PosePartMutator)mutator, (boolean)isLeft)){
                private boolean dirty;

                @Override
                protected void applyValue() {
                    this.dirty = true;
                    ArmorStandRotationsScreen.this.currentPose = mutator.setRotationsAtAxis(2, ArmorStandRotationsScreen.this.currentPose, this.value, clampRotations);
                }

                @Override
                public void method_25357(double mouseX, double mouseY) {
                    super.method_25357(mouseX, mouseY);
                    this.clearDirty();
                }

                @Override
                public boolean isDirty() {
                    return this.dirty;
                }

                @Override
                public void clearDirty() {
                    if (this.isDirty()) {
                        this.dirty = false;
                        ArmorStandRotationsScreen.this.setCurrentPose(ArmorStandRotationsScreen.this.currentPose);
                    }
                }
            })).field_22763 = ArmorStandRotationsScreen.isPosePartMutatorActive(mutator, this.holder.getArmorStand());
            this.toggleLockButtons();
        }
    }

    @Nullable
    private class_2561 getTipComponent() {
        ArrayList components = Lists.newArrayList();
        int i = 1;
        while (class_2477.method_10517().method_4678(TIP_TRANSLATION_KEY + i)) {
            components.add(class_2561.method_43471((String)(TIP_TRANSLATION_KEY + i)));
            ++i;
        }
        Collections.shuffle(components);
        return components.stream().findAny().orElse(null);
    }

    private void toggleLockButtons() {
        this.lockButtons[0].field_22764 = !clampRotations;
        this.lockButtons[1].field_22764 = clampRotations;
    }

    @Override
    protected void renderBg(class_4587 poseStack, float partialTick, int mouseX, int mouseY) {
        class_1531 armorStand = this.holder.getArmorStand();
        ArmorStandPose entityPose = ArmorStandPose.fromEntity(armorStand);
        this.currentPose.applyToEntity(armorStand);
        super.renderBg(poseStack, partialTick, mouseX, mouseY);
        entityPose.applyToEntity(armorStand);
    }

    @Override
    public void method_25432() {
        super.method_25432();
    }

    @Override
    protected boolean withCloseButton() {
        return false;
    }

    @Override
    public ArmorStandScreenType getScreenType() {
        return ArmorStandScreenType.ROTATIONS;
    }

    private void setCurrentPose(ArmorStandPose pose) {
        this.dataSyncHandler.sendPose(pose);
        ArmorStandPose lastSyncedPose = this.dataSyncHandler.getLastSyncedPose();
        this.currentPose = lastSyncedPose != null ? lastSyncedPose : pose;
        this.refreshLiveButtons();
    }

    private void refreshLiveButtons() {
        for (class_364 child : this.method_25396()) {
            if (!(child instanceof LiveSliderButton)) continue;
            LiveSliderButton button = (LiveSliderButton)child;
            button.refreshValues();
        }
    }

    public static void registerPosePartMutatorFilter(PosePartMutator mutator, Predicate<class_1531> filter) {
        if (POSE_PART_MUTATOR_FILTERS.put(mutator, filter) != null) {
            throw new IllegalStateException("Attempted to register duplicate pose part mutator filter for mutator %s".formatted(mutator));
        }
    }

    private static boolean isPosePartMutatorActive(PosePartMutator mutator, class_1531 armorStand) {
        return POSE_PART_MUTATOR_FILTERS.getOrDefault(mutator, armorStand1 -> true).test(armorStand);
    }

    private /* synthetic */ void lambda$init$12(PosePartMutator mutator, boolean isLeft, VerticalSliderButton button, class_4587 poseStack, int mouseX, int mouseY) {
        ArrayList lines = Lists.newArrayList();
        lines.add(class_2561.method_43471((String)mutator.getTranslationKey()));
        lines.add(mutator.getAxisComponent(this.currentPose, 2));
        int offset = isLeft ? 24 + lines.stream().mapToInt(arg_0 -> ((class_327)this.field_22787.field_1772).method_27525(arg_0)).max().orElse(0) : 0;
        this.method_25417(poseStack, lines.stream().map(class_2561::method_30937).collect(Collectors.toList()), mouseX - offset, mouseY);
    }

    private /* synthetic */ double lambda$init$11(PosePartMutator mutator) {
        return mutator.getNormalizedRotationsAtAxis(2, this.currentPose, clampRotations);
    }

    private /* synthetic */ void lambda$init$10(PosePartMutator mutator, boolean isLeft, BoxedSliderButton button, class_4587 poseStack, int mouseX, int mouseY) {
        ArrayList lines = Lists.newArrayList();
        lines.add(class_2561.method_43471((String)mutator.getTranslationKey()));
        lines.add(mutator.getAxisComponent(this.currentPose, 0));
        lines.add(mutator.getAxisComponent(this.currentPose, 1));
        int offset = isLeft ? 24 + lines.stream().mapToInt(arg_0 -> ((class_327)this.field_22787.field_1772).method_27525(arg_0)).max().orElse(0) : 0;
        this.method_25417(poseStack, lines.stream().map(class_2561::method_30937).collect(Collectors.toList()), mouseX - offset, mouseY);
    }

    private /* synthetic */ double lambda$init$9(PosePartMutator mutator) {
        return mutator.getNormalizedRotationsAtAxis(0, this.currentPose, clampRotations);
    }

    private /* synthetic */ double lambda$init$8(PosePartMutator mutator) {
        return mutator.getNormalizedRotationsAtAxis(1, this.currentPose, clampRotations);
    }
}

