/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.screens.armorstand;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.armorstatues.api.client.gui.screens.armorstand.AbstractArmorStandScreen;
import fuzs.armorstatues.api.client.gui.screens.armorstand.ArmorStandScreen;
import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.network.client.data.NetworkDataSyncHandler;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.ArmorStandMenu;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@FunctionalInterface
public interface ArmorStandScreenFactory<T extends class_437 & ArmorStandScreen> {
    public static final Map<ArmorStandScreenType, ArmorStandScreenFactory<?>> FACTORIES = Maps.newHashMap();

    public T create(ArmorStandHolder var1, class_1661 var2, class_2561 var3, DataSyncHandler var4);

    public static <T extends class_437 & ArmorStandScreen> T createScreenType(ArmorStandScreenType screenType, ArmorStandHolder holder, class_1661 inventory, class_2561 component, DataSyncHandler dataSyncHandler) {
        AbstractArmorStandScreen.lastScreenType = screenType;
        ArmorStandScreenFactory<?> factory = FACTORIES.get(screenType);
        if (factory == null) {
            throw new IllegalStateException("No screen factory registered for armor stand screen type %s".formatted(screenType));
        }
        Object screen = factory.create(holder, inventory, component, dataSyncHandler);
        if (((ArmorStandScreen)screen).getScreenType() != screenType) {
            throw new IllegalStateException("Armor stand screen type mismatch: %s and %s".formatted(((ArmorStandScreen)screen).getScreenType(), screenType));
        }
        return (T)screen;
    }

    public static <T extends class_437 & ArmorStandScreen> T createLastScreenType(ArmorStandMenu menu, class_1661 inventory, class_2561 component) {
        return ArmorStandScreenFactory.createLastScreenType(menu, inventory, component, new NetworkDataSyncHandler(menu));
    }

    public static <T extends class_437 & ArmorStandScreen> T createLastScreenType(ArmorStandHolder holder, class_1661 inventory, class_2561 component, DataSyncHandler dataSyncHandler) {
        HashSet screenTypes = Sets.newHashSet((Object[])dataSyncHandler.getScreenTypes());
        Optional<ArmorStandScreenType> lastScreenType = Optional.ofNullable(AbstractArmorStandScreen.lastScreenType).filter(screenTypes::contains).filter(dataSyncHandler::supportsScreenType);
        ArmorStandScreenType screenType = lastScreenType.orElse(dataSyncHandler.getArmorStandHolder().getDataProvider().getDefaultScreenType());
        return ArmorStandScreenFactory.createScreenType(screenType, holder, inventory, component, dataSyncHandler);
    }

    public static void register(ArmorStandScreenType screenType, ArmorStandScreenFactory<?> factory) {
        if (FACTORIES.put(screenType, factory) != null) {
            throw new IllegalStateException("Attempted to register duplicate screen factory for armor stand screen type %s".formatted(screenType));
        }
    }
}

