/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.screens.armorstand;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import fuzs.armorstatues.api.client.gui.components.NewTextureButton;
import fuzs.armorstatues.api.client.gui.components.TickingButton;
import fuzs.armorstatues.api.client.gui.screens.armorstand.AbstractArmorStandScreen;
import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1531;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

public abstract class ArmorStandWidgetsScreen
extends AbstractArmorStandScreen {
    protected final List<ArmorStandWidget> widgets;
    @Nullable
    private ArmorStandWidget activeWidget;

    public ArmorStandWidgetsScreen(ArmorStandHolder holder, class_1661 inventory, class_2561 component, DataSyncHandler dataSyncHandler) {
        super(holder, inventory, component, dataSyncHandler);
        this.widgets = ImmutableList.copyOf(this.buildWidgets(holder.getArmorStand()));
    }

    protected abstract List<ArmorStandWidget> buildWidgets(class_1531 var1);

    private Collection<ArmorStandWidget> getActivePositionComponentWidgets() {
        if (this.activeWidget != null) {
            ArrayList activeWidgets = Lists.newArrayList((Object[])new ArmorStandWidget[]{this.activeWidget});
            for (ArmorStandWidget widget : this.widgets) {
                if (!widget.alwaysVisible(this.activeWidget)) continue;
                activeWidgets.add(widget);
            }
            return activeWidgets;
        }
        return this.widgets;
    }

    protected void setActiveWidget(ArmorStandWidget widget) {
        if (this.activeWidget == widget) {
            this.toggleMenuRendering(false);
            this.activeWidget = null;
        } else {
            this.activeWidget = widget;
            this.toggleMenuRendering(true);
        }
    }

    @Override
    protected boolean renderInventoryEntity() {
        return false;
    }

    @Override
    protected boolean disableMenuRendering() {
        return this.activeWidget != null;
    }

    @Override
    protected void toggleMenuRendering(boolean disableMenuRendering) {
        super.toggleMenuRendering(disableMenuRendering);
        for (ArmorStandWidget widget : this.widgets) {
            widget.setVisible(!disableMenuRendering || widget.alwaysVisible(this.activeWidget));
        }
    }

    @Override
    public void method_25393() {
        super.method_25393();
        this.getActivePositionComponentWidgets().forEach(ArmorStandWidget::tick);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        Objects.requireNonNull(this);
        int startY = (188 - this.widgets.size() * 22 - (this.widgets.size() - 1) * 7) / 2;
        for (int i = 0; i < this.widgets.size(); ++i) {
            this.widgets.get(i).init(this.leftPos + 8, this.topPos + startY + this.getWidgetRenderOffset() + i * 29);
        }
    }

    protected int getWidgetRenderOffset() {
        return 7;
    }

    @Override
    protected void renderBg(class_4587 poseStack, float partialTick, int mouseX, int mouseY) {
        super.renderBg(poseStack, partialTick, mouseX, mouseY);
        for (ArmorStandWidget widget : this.getActivePositionComponentWidgets()) {
            widget.render(poseStack, mouseX, mouseY, partialTick);
        }
    }

    protected static interface ArmorStandWidget {
        public void tick();

        public void reset();

        public void init(int var1, int var2);

        public void setVisible(boolean var1);

        public void render(class_4587 var1, int var2, int var3, float var4);

        public boolean alwaysVisible(@Nullable ArmorStandWidget var1);
    }

    protected abstract class AbstractArmorStandWidget
    implements ArmorStandWidget {
        protected final class_2561 title;
        protected int posX;
        protected int posY;
        protected List<class_339> children;

        protected AbstractArmorStandWidget() {
            this(class_5244.field_39003);
        }

        protected AbstractArmorStandWidget(class_2561 title) {
            this.title = title;
        }

        @Override
        public void tick() {
            if (this.shouldTick()) {
                for (class_339 widget : this.children) {
                    if (!(widget instanceof TickingButton)) continue;
                    TickingButton tickButton = (TickingButton)widget;
                    tickButton.tick();
                }
            }
        }

        protected boolean shouldTick() {
            return false;
        }

        @Override
        public void reset() {
        }

        @Override
        public void init(int posX, int posY) {
            this.posX = posX;
            this.posY = posY;
            this.children = Lists.newArrayList();
        }

        @Override
        public final void setVisible(boolean visible) {
            for (class_339 widget : this.children) {
                widget.field_22764 = visible;
            }
        }

        @Override
        public void render(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
            if (ArmorStandWidgetsScreen.this.disableMenuRendering()) {
                NewTextureButton.drawCenteredString(poseStack, ArmorStandWidgetsScreen.this.field_22793, this.title, this.posX + 36, this.posY + 6, -1, true);
            } else {
                NewTextureButton.drawCenteredString(poseStack, ArmorStandWidgetsScreen.this.field_22793, this.title, this.posX + 36, this.posY + 6, 0x404040, false);
            }
        }

        @Override
        public boolean alwaysVisible(@Nullable ArmorStandWidget activeWidget) {
            return activeWidget == this;
        }
    }
}

