/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.network.client;

import fuzs.armorstatues.api.StatuesApi;
import fuzs.armorstatues.api.world.inventory.ArmorStandMenu;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;

public class C2SArmorStandPositionMessage
implements MessageV2<C2SArmorStandPositionMessage> {
    private double posX;
    private double posY;
    private double posZ;

    public C2SArmorStandPositionMessage() {
    }

    public C2SArmorStandPositionMessage(double posX, double posY, double posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public void write(class_2540 buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public void read(class_2540 buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    public MessageV2.MessageHandler<C2SArmorStandPositionMessage> makeHandler() {
        return new MessageV2.MessageHandler<C2SArmorStandPositionMessage>(){

            public void handle(C2SArmorStandPositionMessage message, class_1657 player, Object gameInstance) {
                ArmorStandMenu menu;
                class_1703 class_17032 = player.field_7512;
                if (class_17032 instanceof ArmorStandMenu && (menu = (ArmorStandMenu)class_17032).method_7597(player) && !C2SArmorStandPositionMessage.tryMoveArmorStandTo(menu.getArmorStand(), message.posX, message.posY, message.posZ)) {
                    StatuesApi.LOGGER.warn("Player {} attempted to move armor stand further than allowed", (Object)player);
                }
            }
        };
    }

    private static boolean tryMoveArmorStandTo(class_1531 armorStand, double posX, double posY, double posZ) {
        if (!C2SArmorStandPositionMessage.testDistance(armorStand, posX, posY, posZ)) {
            return false;
        }
        armorStand.method_24203(posX, posY, posZ);
        return true;
    }

    private static boolean testDistance(class_1531 armorStand, double posX, double posY, double posZ) {
        return armorStand.method_5649(posX, posY, posZ) < 64.0;
    }
}

