/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.world.inventory;

import com.mojang.datafixers.util.Pair;
import fuzs.armorstatues.api.StatuesApi;
import fuzs.armorstatues.api.world.entity.decoration.ArmorStandDataProvider;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandStyleOption;
import fuzs.armorstatues.mixin.accessor.ArmorStandAccessor;
import fuzs.armorstatues.mixin.accessor.SimpleContainerAccessor;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class ArmorStandMenu
extends class_1703
implements ArmorStandHolder {
    public static final class_2960 EMPTY_ARMOR_SLOT_SWORD = StatuesApi.id("item/empty_armor_slot_sword");
    static final class_2960[] TEXTURE_EMPTY_SLOTS = new class_2960[]{class_1723.field_21672, class_1723.field_21671, class_1723.field_21670, class_1723.field_21669, class_1723.field_21673, EMPTY_ARMOR_SLOT_SWORD};
    public static final class_1304[] SLOT_IDS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166, class_1304.field_6173, class_1304.field_6171};
    private final class_1263 container;
    private final class_1531 armorStand;
    @Nullable
    private final ArmorStandDataProvider dataProvider;

    public static ArmorStandMenu create(class_3917<?> menuType, int containerId, class_1661 inventory, class_2540 buf, @Nullable ArmorStandDataProvider dataProvider) {
        int entityId = buf.readInt();
        class_1531 entity = (class_1531)inventory.field_7546.field_6002.method_8469(entityId);
        if (entity != null) {
            entity.method_5684(buf.readBoolean());
            ((ArmorStandAccessor)entity).setDisabledSlots(buf.readInt());
            return ArmorStandMenu.create(menuType, containerId, inventory, entity, dataProvider);
        }
        throw new IllegalStateException("Entity for id %s missing on client".formatted(entityId));
    }

    public static ArmorStandMenu create(class_3917<?> menuType, int containerId, class_1661 inventory, class_1531 armorStand, @Nullable ArmorStandDataProvider dataProvider) {
        class_2371<class_1799> armorItems = ((ArmorStandAccessor)armorStand).getArmorItems();
        class_2371<class_1799> handItems = ((ArmorStandAccessor)armorStand).getHandItems();
        class_1277 handItemsContainer = ArmorStandMenu.simpleContainer(handItems);
        handItemsContainer.method_5489(container -> {
            if (container.method_43256(stack -> !stack.method_7960())) {
                ArmorStandStyleOption.setArmorStandData(armorStand, true, 4);
            }
        });
        class_1258 container2 = new class_1258((class_1263)ArmorStandMenu.simpleContainer(armorItems), (class_1263)handItemsContainer);
        return new ArmorStandMenu(menuType, containerId, inventory, (class_1263)container2, armorStand, dataProvider);
    }

    private static class_1277 simpleContainer(class_2371<class_1799> items) {
        class_1277 container = new class_1277(items.size());
        ((SimpleContainerAccessor)container).setItems(items);
        return container;
    }

    private ArmorStandMenu(class_3917<?> menuType, int containerId, final class_1661 inventory, class_1263 container, final class_1531 armorStand, @Nullable ArmorStandDataProvider dataProvider) {
        super(menuType, containerId);
        class_1304 equipmentslot;
        this.container = container;
        this.armorStand = armorStand;
        this.dataProvider = dataProvider;
        for (int k = 0; k < 4; ++k) {
            equipmentslot = SLOT_IDS[k];
            this.method_7621(new class_1735(this.container, 3 - k, 58, 20 + k * 18){

                public void method_7673(class_1799 stack) {
                    class_1799 oldStack = this.method_7677();
                    super.method_7673(stack);
                    armorStand.method_6116(equipmentslot, oldStack, stack);
                }

                public int method_7675() {
                    return 1;
                }

                public boolean method_7680(class_1799 stack) {
                    if (!inventory.field_7546.method_7337()) {
                        if (ArmorStandMenu.isSlotDisabled(armorStand, equipmentslot, 0)) {
                            return false;
                        }
                        if (ArmorStandMenu.isSlotDisabled(armorStand, equipmentslot, 16) && !this.method_7681()) {
                            return false;
                        }
                    }
                    if (equipmentslot == class_1304.field_6169) {
                        return true;
                    }
                    return CommonAbstractions.INSTANCE.canEquip(stack, equipmentslot, (class_1297)inventory.field_7546);
                }

                public boolean method_7674(class_1657 player) {
                    if (!inventory.field_7546.method_7337() && ArmorStandMenu.isSlotDisabled(armorStand, equipmentslot, 8)) {
                        return false;
                    }
                    return super.method_7674(player);
                }

                public Pair<class_2960, class_2960> method_7679() {
                    return Pair.of((Object)class_1723.field_21668, (Object)TEXTURE_EMPTY_SLOTS[equipmentslot.method_5927()]);
                }
            });
        }
        for (int i = 0; i < 2; ++i) {
            equipmentslot = SLOT_IDS[4 + i];
            final class_2960 slotTexture = TEXTURE_EMPTY_SLOTS[5 - i];
            this.method_7621(new class_1735(this.container, 4 + i, 136, 56 + i * 18){

                public boolean method_7680(class_1799 stack) {
                    if (!inventory.field_7546.method_7337()) {
                        if (ArmorStandMenu.isSlotDisabled(armorStand, equipmentslot, 0)) {
                            return false;
                        }
                        if (ArmorStandMenu.isSlotDisabled(armorStand, equipmentslot, 16) && !this.method_7681()) {
                            return false;
                        }
                    }
                    return super.method_7680(stack);
                }

                public boolean method_7674(class_1657 player) {
                    if (!inventory.field_7546.method_7337() && ArmorStandMenu.isSlotDisabled(armorStand, equipmentslot, 8)) {
                        return false;
                    }
                    return super.method_7674(player);
                }

                public Pair<class_2960, class_2960> method_7679() {
                    return Pair.of((Object)class_1723.field_21668, (Object)slotTexture);
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.method_7621(new class_1735((class_1263)inventory, j1 + (l + 1) * 9, 25 + j1 * 18, 96 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.method_7621(new class_1735((class_1263)inventory, i1, 25 + i1 * 18, 154));
        }
    }

    public static boolean isSlotDisabled(class_1531 armorStand, class_1304 slot, int offset) {
        return (((ArmorStandAccessor)armorStand).getDisabledSlots() & 1 << slot.method_5926() + offset) != 0;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            int i;
            class_1799 itemStack2 = slot.method_7677();
            itemStack = itemStack2.method_7972();
            class_1304 equipmentSlot = class_1308.method_32326((class_1799)itemStack);
            if (index >= 0 && index < 6 ? !this.method_7616(itemStack2, 6, 42, false) : (equipmentSlot.method_5925() == class_1304.class_1305.field_6178 && !((class_1735)this.field_7761.get(3 - equipmentSlot.method_5927())).method_7681() ? !this.method_7616(itemStack2, i = 3 - equipmentSlot.method_5927(), i + 1, false) : (equipmentSlot == class_1304.field_6171 && !((class_1735)this.field_7761.get(5)).method_7681() ? !this.method_7616(itemStack2, 5, 6, false) : (index >= 6 && index < 33 ? !this.method_7616(itemStack2, 33, 42, false) : (index >= 33 && index < 42 ? !this.method_7616(itemStack2, 6, 33, false) : !this.method_7616(itemStack2, 6, 42, false)))))) {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemStack2);
        }
        return itemStack;
    }

    public boolean method_7597(class_1657 player) {
        return this.armorStand != null && !this.armorStand.method_31481();
    }

    @Override
    public class_1531 getArmorStand() {
        return this.armorStand;
    }

    @Override
    public ArmorStandDataProvider getDataProvider() {
        return this.dataProvider != null ? this.dataProvider : ArmorStandHolder.super.getDataProvider();
    }
}

