/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.world.inventory.data;

import fuzs.armorstatues.api.world.inventory.data.PosePartMutator;
import fuzs.armorstatues.mixin.accessor.ArmorStandAccessor;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1531;
import net.minecraft.class_156;
import net.minecraft.class_2379;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class ArmorStandPose {
    private static final class_2379 ZERO_ROTATIONS = new class_2379(0.0f, 0.0f, 0.0f);
    public static final double DEGREES_SNAP_INTERVAL = 0.125;
    public static final DecimalFormat ROTATION_FORMAT = (DecimalFormat)class_156.method_654((Object)new DecimalFormat("#.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final ArmorStandPose EMPTY = new ArmorStandPose(null).withSourceType(SourceType.EMPTY);
    public static final ArmorStandPose ATHENA = new ArmorStandPose("athena").withBodyPose(new class_2379(0.0f, 0.0f, 2.0f)).withHeadPose(new class_2379(-5.0f, 0.0f, 0.0f)).withLeftArmPose(new class_2379(10.0f, 0.0f, -5.0f)).withLeftLegPose(new class_2379(-3.0f, -3.0f, -3.0f)).withRightArmPose(new class_2379(-60.0f, 20.0f, -10.0f)).withRightLegPose(new class_2379(3.0f, 3.0f, 3.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose BRANDISH = new ArmorStandPose("brandish").withBodyPose(new class_2379(0.0f, 0.0f, -2.0f)).withHeadPose(new class_2379(-15.0f, 0.0f, 0.0f)).withLeftArmPose(new class_2379(20.0f, 0.0f, -10.0f)).withLeftLegPose(new class_2379(5.0f, -3.0f, -3.0f)).withRightArmPose(new class_2379(-110.0f, 50.0f, 0.0f)).withRightLegPose(new class_2379(-5.0f, 3.0f, 3.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose CANCAN = new ArmorStandPose("cancan").withBodyPose(new class_2379(0.0f, 22.0f, 0.0f)).withHeadPose(new class_2379(-5.0f, 18.0f, 0.0f)).withLeftArmPose(new class_2379(8.0f, 0.0f, -114.0f)).withLeftLegPose(new class_2379(-111.0f, 55.0f, 0.0f)).withRightArmPose(new class_2379(0.0f, 84.0f, 111.0f)).withRightLegPose(new class_2379(0.0f, 23.0f, -13.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose DEFAULT = new ArmorStandPose("default").withLeftArmPose(new class_2379(-10.0f, 0.0f, -10.0f)).withLeftLegPose(new class_2379(-1.0f, 0.0f, -1.0f)).withRightArmPose(new class_2379(-15.0f, 0.0f, 10.0f)).withRightLegPose(new class_2379(1.0f, 0.0f, 1.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose ENTERTAIN = new ArmorStandPose("entertain").withHeadPose(new class_2379(-15.0f, 0.0f, 0.0f)).withLeftArmPose(new class_2379(-110.0f, -35.0f, 0.0f)).withLeftLegPose(new class_2379(5.0f, -3.0f, -3.0f)).withRightArmPose(new class_2379(-110.0f, 35.0f, 0.0f)).withRightLegPose(new class_2379(-5.0f, 3.0f, 3.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose HERO = new ArmorStandPose("hero").withBodyPose(new class_2379(0.0f, 8.0f, 0.0f)).withHeadPose(new class_2379(-4.0f, 67.0f, 0.0f)).withLeftArmPose(new class_2379(16.0f, 32.0f, -8.0f)).withLeftLegPose(new class_2379(0.0f, -75.0f, -8.0f)).withRightArmPose(new class_2379(-99.0f, 63.0f, 0.0f)).withRightLegPose(new class_2379(4.0f, 63.0f, 8.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose HONOR = new ArmorStandPose("honor").withHeadPose(new class_2379(-15.0f, 0.0f, 0.0f)).withLeftArmPose(new class_2379(-110.0f, 35.0f, 0.0f)).withLeftLegPose(new class_2379(5.0f, -3.0f, -3.0f)).withRightArmPose(new class_2379(-110.0f, -35.0f, 0.0f)).withRightLegPose(new class_2379(-5.0f, 3.0f, 3.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose RIPOSTE = new ArmorStandPose("riposte").withHeadPose(new class_2379(16.0f, 20.0f, 0.0f)).withLeftArmPose(new class_2379(4.0f, 8.0f, 237.0f)).withLeftLegPose(new class_2379(-14.0f, -18.0f, -16.0f)).withRightArmPose(new class_2379(246.0f, 0.0f, 89.0f)).withRightLegPose(new class_2379(8.0f, 20.0f, 4.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose SALUTE = new ArmorStandPose("salute").withLeftArmPose(new class_2379(10.0f, 0.0f, -5.0f)).withLeftLegPose(new class_2379(-1.0f, 0.0f, -1.0f)).withRightArmPose(new class_2379(-70.0f, -40.0f, 0.0f)).withRightLegPose(new class_2379(1.0f, 0.0f, 1.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose SOLEMN = new ArmorStandPose("solemn").withBodyPose(new class_2379(0.0f, 0.0f, 2.0f)).withHeadPose(new class_2379(15.0f, 0.0f, 0.0f)).withLeftArmPose(new class_2379(-30.0f, 15.0f, 15.0f)).withLeftLegPose(new class_2379(-1.0f, 0.0f, -1.0f)).withRightArmPose(new class_2379(-60.0f, -20.0f, -10.0f)).withRightLegPose(new class_2379(1.0f, 0.0f, 1.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose ZOMBIE = new ArmorStandPose("zombie").withHeadPose(new class_2379(-10.0f, 0.0f, -5.0f)).withLeftArmPose(new class_2379(-105.0f, 0.0f, 0.0f)).withLeftLegPose(new class_2379(7.0f, 0.0f, 0.0f)).withRightArmPose(new class_2379(-100.0f, 0.0f, 0.0f)).withRightLegPose(new class_2379(-46.0f, 0.0f, 0.0f)).withSourceType(SourceType.MINECRAFT);
    public static final ArmorStandPose WALKING = new ArmorStandPose("walking").withRightArmPose(new class_2379(20.0f, 0.0f, 10.0f)).withLeftArmPose(new class_2379(-20.0f, 0.0f, -10.0f)).withRightLegPose(new class_2379(-20.0f, 0.0f, 0.0f)).withLeftLegPose(new class_2379(20.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose RUNNING = new ArmorStandPose("running").withRightArmPose(new class_2379(-40.0f, 0.0f, 10.0f)).withLeftArmPose(new class_2379(40.0f, 0.0f, -10.0f)).withRightLegPose(new class_2379(40.0f, 0.0f, 0.0f)).withLeftLegPose(new class_2379(-40.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose POINTING = new ArmorStandPose("pointing").withHeadPose(new class_2379(0.0f, 20.0f, 0.0f)).withRightArmPose(new class_2379(-90.0f, 18.0f, 0.0f)).withLeftArmPose(new class_2379(0.0f, 0.0f, -10.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose BLOCKING = new ArmorStandPose("blocking").withRightArmPose(new class_2379(-20.0f, -20.0f, 0.0f)).withLeftArmPose(new class_2379(-50.0f, 50.0f, 0.0f)).withRightLegPose(new class_2379(-20.0f, 0.0f, 0.0f)).withLeftLegPose(new class_2379(20.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose LUNGEING = new ArmorStandPose("lungeing").withBodyPose(new class_2379(15.0f, 0.0f, 0.0f)).withRightArmPose(new class_2379(-60.0f, -10.0f, 0.0f)).withLeftArmPose(new class_2379(10.0f, 0.0f, -10.0f)).withRightLegPose(new class_2379(-15.0f, 0.0f, 0.0f)).withLeftLegPose(new class_2379(30.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose WINNING = new ArmorStandPose("winning").withHeadPose(new class_2379(-15.0f, 0.0f, 0.0f)).withRightArmPose(new class_2379(-120.0f, -10.0f, 0.0f)).withLeftArmPose(new class_2379(10.0f, 0.0f, -10.0f)).withLeftLegPose(new class_2379(15.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose SITTING = new ArmorStandPose("sitting").withRightArmPose(new class_2379(-80.0f, 20.0f, 0.0f)).withLeftArmPose(new class_2379(-80.0f, -20.0f, 0.0f)).withRightLegPose(new class_2379(-90.0f, 10.0f, 0.0f)).withLeftLegPose(new class_2379(-90.0f, -10.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose ARABESQUE = new ArmorStandPose("arabesque").withHeadPose(new class_2379(-15.0f, 0.0f, 0.0f)).withBodyPose(new class_2379(10.0f, 0.0f, 0.0f)).withRightArmPose(new class_2379(-140.0f, -10.0f, 0.0f)).withLeftArmPose(new class_2379(70.0f, 0.0f, -10.0f)).withLeftLegPose(new class_2379(75.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose CUPID = new ArmorStandPose("cupid").withBodyPose(new class_2379(10.0f, 0.0f, 0.0f)).withRightArmPose(new class_2379(-90.0f, -10.0f, 0.0f)).withLeftArmPose(new class_2379(-75.0f, 0.0f, 10.0f)).withLeftLegPose(new class_2379(75.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose CONFIDENT = new ArmorStandPose("confident").withHeadPose(new class_2379(-10.0f, 20.0f, 0.0f)).withBodyPose(new class_2379(-2.0f, 0.0f, 0.0f)).withRightArmPose(new class_2379(5.0f, 0.0f, 0.0f)).withLeftArmPose(new class_2379(5.0f, 0.0f, 0.0f)).withRightLegPose(new class_2379(16.0f, 2.0f, 10.0f)).withLeftLegPose(new class_2379(0.0f, -10.0f, -4.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose DEATH = new ArmorStandPose("death").withHeadPose(new class_2379(-85.0f, 0.0f, 0.0f)).withBodyPose(new class_2379(-90.0f, 0.0f, 0.0f)).withRightArmPose(new class_2379(-90.0f, 10.0f, 0.0f)).withLeftArmPose(new class_2379(-90.0f, -10.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose FACEPALM = new ArmorStandPose("facepalm").withHeadPose(new class_2379(45.0f, -4.0f, 1.0f)).withBodyPose(new class_2379(10.0f, 0.0f, 0.0f)).withRightArmPose(new class_2379(18.0f, -14.0f, 0.0f)).withLeftArmPose(new class_2379(-72.0f, 24.0f, 47.0f)).withRightLegPose(new class_2379(25.0f, -2.0f, 0.0f)).withLeftLegPose(new class_2379(-4.0f, -6.0f, -2.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose LAZING = new ArmorStandPose("lazing").withHeadPose(new class_2379(14.0f, -12.0f, 6.0f)).withBodyPose(new class_2379(5.0f, 0.0f, 0.0f)).withRightArmPose(new class_2379(-40.0f, 20.0f, 0.0f)).withLeftArmPose(new class_2379(-4.0f, -20.0f, -10.0f)).withRightLegPose(new class_2379(-88.0f, 71.0f, 0.0f)).withLeftLegPose(new class_2379(-88.0f, 46.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose CONFUSED = new ArmorStandPose("confused").withHeadPose(new class_2379(0.0f, 30.0f, 0.0f)).withBodyPose(new class_2379(0.0f, 13.0f, 0.0f)).withRightArmPose(new class_2379(-22.0f, 31.0f, 10.0f)).withLeftArmPose(new class_2379(145.0f, 22.0f, -49.0f)).withRightLegPose(new class_2379(6.0f, -20.0f, 0.0f)).withLeftLegPose(new class_2379(-6.0f, 0.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose FORMAL = new ArmorStandPose("formal").withHeadPose(new class_2379(4.0f, 0.0f, 0.0f)).withBodyPose(new class_2379(4.0f, 0.0f, 0.0f)).withRightArmPose(new class_2379(30.0f, 22.0f, -20.0f)).withLeftArmPose(new class_2379(30.0f, -20.0f, 21.0f)).withRightLegPose(new class_2379(0.0f, 0.0f, 5.0f)).withLeftLegPose(new class_2379(0.0f, 0.0f, -5.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose SAD = new ArmorStandPose("sad").withHeadPose(new class_2379(63.0f, 0.0f, 0.0f)).withBodyPose(new class_2379(10.0f, 0.0f, 0.0f)).withRightArmPose(new class_2379(-5.0f, 0.0f, 5.0f)).withLeftArmPose(new class_2379(-5.0f, 0.0f, -5.0f)).withRightLegPose(new class_2379(-5.0f, -10.0f, 5.0f)).withLeftLegPose(new class_2379(-5.0f, 16.0f, -5.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose JOYOUS = new ArmorStandPose("joyous").withHeadPose(new class_2379(-11.0f, 0.0f, 0.0f)).withBodyPose(new class_2379(-4.0f, 0.0f, 0.0f)).withRightArmPose(new class_2379(0.0f, 0.0f, 100.0f)).withLeftArmPose(new class_2379(0.0f, 0.0f, -100.0f)).withRightLegPose(new class_2379(-8.0f, 0.0f, 60.0f)).withLeftLegPose(new class_2379(-8.0f, 0.0f, -60.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    public static final ArmorStandPose STARGAZING = new ArmorStandPose("stargazing").withHeadPose(new class_2379(-22.0f, 25.0f, 0.0f)).withBodyPose(new class_2379(-4.0f, 10.0f, 0.0f)).withRightArmPose(new class_2379(-153.0f, 34.0f, -3.0f)).withLeftArmPose(new class_2379(4.0f, 18.0f, 0.0f)).withRightLegPose(new class_2379(-4.0f, 17.0f, 2.0f)).withLeftLegPose(new class_2379(6.0f, 24.0f, 0.0f)).withSourceType(SourceType.VANILLA_TWEAKS);
    private static final ArmorStandPose[] VALUES = new ArmorStandPose[]{DEFAULT, SOLEMN, ATHENA, BRANDISH, HONOR, ENTERTAIN, SALUTE, HERO, RIPOSTE, ZOMBIE, CANCAN, WALKING, RUNNING, POINTING, BLOCKING, LUNGEING, WINNING, SITTING, ARABESQUE, CUPID, CONFIDENT, DEATH, FACEPALM, LAZING, CONFUSED, FORMAL, SAD, JOYOUS, STARGAZING};
    @Nullable
    private final String name;
    @Nullable
    private final SourceType sourceType;
    @Nullable
    private final class_2379 headPose;
    @Nullable
    private final class_2379 bodyPose;
    @Nullable
    private final class_2379 leftArmPose;
    @Nullable
    private final class_2379 rightArmPose;
    @Nullable
    private final class_2379 leftLegPose;
    @Nullable
    private final class_2379 rightLegPose;

    private ArmorStandPose(@Nullable String name) {
        this(name, null, ZERO_ROTATIONS, ZERO_ROTATIONS, ZERO_ROTATIONS, ZERO_ROTATIONS, ZERO_ROTATIONS, ZERO_ROTATIONS);
    }

    private ArmorStandPose(@Nullable String name, @Nullable SourceType sourceType, @Nullable class_2379 headPose, @Nullable class_2379 bodyPose, @Nullable class_2379 leftArmPose, @Nullable class_2379 rightArmPose, @Nullable class_2379 leftLegPose, @Nullable class_2379 rightLegPose) {
        this.name = name;
        this.sourceType = sourceType;
        this.headPose = headPose;
        this.bodyPose = bodyPose;
        this.leftArmPose = leftArmPose;
        this.rightArmPose = rightArmPose;
        this.leftLegPose = leftLegPose;
        this.rightLegPose = rightLegPose;
    }

    public static ArmorStandPose empty() {
        return new ArmorStandPose(null, null, null, null, null, null, null, null);
    }

    public String toString() {
        return this.name != null ? this.name.toUpperCase(Locale.ROOT) : "POSE";
    }

    public String getTranslationKey() {
        return this.name != null ? "statues.screen.pose." + this.name : null;
    }

    public SourceType getSourceType() {
        return this.sourceType != null ? this.sourceType : SourceType.TRANSIENT;
    }

    public class_2379 getHeadPose() {
        return this.headPose != null ? this.headPose : ZERO_ROTATIONS;
    }

    public class_2379 getBodyPose() {
        return this.bodyPose != null ? this.bodyPose : ZERO_ROTATIONS;
    }

    public class_2379 getLeftArmPose() {
        return this.leftArmPose != null ? this.leftArmPose : ZERO_ROTATIONS;
    }

    public class_2379 getRightArmPose() {
        return this.rightArmPose != null ? this.rightArmPose : ZERO_ROTATIONS;
    }

    public class_2379 getLeftLegPose() {
        return this.leftLegPose != null ? this.leftLegPose : ZERO_ROTATIONS;
    }

    public class_2379 getRightLegPose() {
        return this.rightLegPose != null ? this.rightLegPose : ZERO_ROTATIONS;
    }

    @Nullable
    public class_2379 getNullableHeadPose() {
        return this.headPose;
    }

    @Nullable
    public class_2379 getNullableBodyPose() {
        return this.bodyPose;
    }

    @Nullable
    public class_2379 getNullableLeftArmPose() {
        return this.leftArmPose;
    }

    @Nullable
    public class_2379 getNullableRightArmPose() {
        return this.rightArmPose;
    }

    @Nullable
    public class_2379 getNullableLeftLegPose() {
        return this.leftLegPose;
    }

    @Nullable
    public class_2379 getNullableRightLegPose() {
        return this.rightLegPose;
    }

    public ArmorStandPose withHeadPose(class_2379 rotation) {
        return new ArmorStandPose(this.name, null, rotation, this.bodyPose, this.leftArmPose, this.rightArmPose, this.leftLegPose, this.rightLegPose);
    }

    public ArmorStandPose withBodyPose(class_2379 rotation) {
        return new ArmorStandPose(this.name, null, this.headPose, rotation, this.leftArmPose, this.rightArmPose, this.leftLegPose, this.rightLegPose);
    }

    public ArmorStandPose withLeftArmPose(class_2379 rotation) {
        return new ArmorStandPose(this.name, null, this.headPose, this.bodyPose, rotation, this.rightArmPose, this.leftLegPose, this.rightLegPose);
    }

    public ArmorStandPose withRightArmPose(class_2379 rotation) {
        return new ArmorStandPose(this.name, null, this.headPose, this.bodyPose, this.leftArmPose, rotation, this.leftLegPose, this.rightLegPose);
    }

    public ArmorStandPose withLeftLegPose(class_2379 rotation) {
        return new ArmorStandPose(this.name, null, this.headPose, this.bodyPose, this.leftArmPose, this.rightArmPose, rotation, this.rightLegPose);
    }

    public ArmorStandPose withRightLegPose(class_2379 rotation) {
        return new ArmorStandPose(this.name, null, this.headPose, this.bodyPose, this.leftArmPose, this.rightArmPose, this.leftLegPose, rotation);
    }

    public ArmorStandPose withSourceType(SourceType sourceType) {
        return new ArmorStandPose(this.name, sourceType, this.headPose, this.bodyPose, this.leftArmPose, this.rightArmPose, this.leftLegPose, this.rightLegPose);
    }

    public ArmorStandPose mirror() {
        return new ArmorStandPose(this.name, SourceType.MIRRORED, ArmorStandPose.mirrorRotations(this.headPose), ArmorStandPose.mirrorRotations(this.bodyPose), ArmorStandPose.mirrorRotations(this.rightArmPose), ArmorStandPose.mirrorRotations(this.leftArmPose), ArmorStandPose.mirrorRotations(this.rightLegPose), ArmorStandPose.mirrorRotations(this.leftLegPose));
    }

    @Nullable
    private static class_2379 mirrorRotations(@Nullable class_2379 rotations) {
        return rotations != null ? new class_2379(rotations.method_10256(), -rotations.method_10257(), -rotations.method_10258()) : null;
    }

    public ArmorStandPose copyAndFillFrom(ArmorStandPose fillFrom) {
        return new ArmorStandPose(this.name, this.sourceType, this.headPose != null ? this.headPose : fillFrom.headPose, this.bodyPose != null ? this.bodyPose : fillFrom.bodyPose, this.leftArmPose != null ? this.leftArmPose : fillFrom.leftArmPose, this.rightArmPose != null ? this.rightArmPose : fillFrom.rightArmPose, this.leftLegPose != null ? this.leftLegPose : fillFrom.leftLegPose, this.rightLegPose != null ? this.rightLegPose : fillFrom.rightLegPose);
    }

    public void applyToEntity(class_1531 armorStand) {
        armorStand.method_6919(this.getHeadPose());
        armorStand.method_6927(this.getBodyPose());
        armorStand.method_6910(this.getLeftArmPose());
        armorStand.method_6925(this.getRightArmPose());
        armorStand.method_6909(this.getLeftLegPose());
        armorStand.method_6926(this.getRightLegPose());
    }

    public void serializeAllPoses(class_2487 tag) {
        this.serializeBodyPoses(tag, null);
        this.serializeArmPoses(tag, null);
        this.serializeLegPoses(tag, null);
    }

    public boolean serializeBodyPoses(class_2487 tag, @Nullable ArmorStandPose lastSentPose) {
        boolean hasChanged = false;
        if (!(this.headPose == null || lastSentPose != null && this.headPose.equals((Object)lastSentPose.headPose))) {
            tag.method_10566("Head", (class_2520)this.headPose.method_10255());
            hasChanged = true;
        }
        if (!(this.bodyPose == null || lastSentPose != null && this.bodyPose.equals((Object)lastSentPose.bodyPose))) {
            tag.method_10566("Body", (class_2520)this.bodyPose.method_10255());
            hasChanged = true;
        }
        return hasChanged;
    }

    public boolean serializeArmPoses(class_2487 tag, @Nullable ArmorStandPose lastSentPose) {
        boolean hasChanged = false;
        if (!(this.leftArmPose == null || lastSentPose != null && this.leftArmPose.equals((Object)lastSentPose.leftArmPose))) {
            tag.method_10566("LeftArm", (class_2520)this.leftArmPose.method_10255());
            hasChanged = true;
        }
        if (!(this.rightArmPose == null || lastSentPose != null && this.rightArmPose.equals((Object)lastSentPose.rightArmPose))) {
            tag.method_10566("RightArm", (class_2520)this.rightArmPose.method_10255());
            hasChanged = true;
        }
        return hasChanged;
    }

    public boolean serializeLegPoses(class_2487 tag, @Nullable ArmorStandPose lastSentPose) {
        boolean hasChanged = false;
        if (!(this.leftLegPose == null || lastSentPose != null && this.leftLegPose.equals((Object)lastSentPose.leftLegPose))) {
            tag.method_10566("LeftLeg", (class_2520)this.leftLegPose.method_10255());
            hasChanged = true;
        }
        if (!(this.rightLegPose == null || lastSentPose != null && this.rightLegPose.equals((Object)lastSentPose.rightLegPose))) {
            tag.method_10566("RightLeg", (class_2520)this.rightLegPose.method_10255());
            hasChanged = true;
        }
        return hasChanged;
    }

    public static ArmorStandPose fromEntity(class_1531 armorStand) {
        return new ArmorStandPose(null, null, armorStand.method_6921(), armorStand.method_6923(), armorStand.method_6930(), armorStand.method_6903(), armorStand.method_6917(), armorStand.method_6900());
    }

    public static void applyTagToEntity(class_1531 armorStand, class_2487 tag) {
        ((ArmorStandAccessor)armorStand).callReadPose(tag);
    }

    public static ArmorStandPose random(PosePartMutator[] mutators, boolean clampRotations) {
        ArmorStandPose.checkMutatorsSize(mutators);
        return new ArmorStandPose(null, null, mutators[0].randomRotations(clampRotations), mutators[1].randomRotations(clampRotations), mutators[2].randomRotations(clampRotations), mutators[3].randomRotations(clampRotations), mutators[4].randomRotations(clampRotations), mutators[5].randomRotations(clampRotations));
    }

    public static ArmorStandPose[] values() {
        return (ArmorStandPose[])VALUES.clone();
    }

    public static int valuesLength() {
        return VALUES.length;
    }

    public static ArmorStandPose randomValue() {
        List<ArmorStandPose> poses = Arrays.asList(VALUES);
        Collections.shuffle(poses);
        return (ArmorStandPose)poses.stream().findAny().orElseThrow();
    }

    public static void checkMutatorsSize(PosePartMutator[] mutators) {
        if (mutators.length != 6) {
            throw new IllegalArgumentException("Invalid mutators size: Expected 6, was %s".formatted(mutators.length));
        }
    }

    public static double snapValue(double value, double snapInterval) {
        if (snapInterval > 0.0 && snapInterval < 1.0) {
            for (double currentSnap = 0.0; currentSnap < 1.0; currentSnap += snapInterval) {
                double snapRegion = snapInterval * 0.1;
                if (!(value >= currentSnap - snapRegion) || !(value < currentSnap + snapRegion)) continue;
                return currentSnap;
            }
        }
        return value;
    }

    public static enum SourceType {
        MINECRAFT,
        VANILLA_TWEAKS,
        TRANSIENT,
        EMPTY,
        MIRRORED;


        @Nullable
        public String getDisplayName() {
            if (this == MINECRAFT) {
                return "Minecraft";
            }
            if (this == VANILLA_TWEAKS) {
                return "Vanilla Tweaks";
            }
            return null;
        }
    }
}

