/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.world.inventory.data;

import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import java.util.Locale;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2350;
import net.minecraft.class_2379;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public final class PosePartMutator {
    public static final PosePartMutator HEAD = new PosePartMutator("head", ArmorStandPose::getHeadPose, ArmorStandPose::withHeadPose, PosePartAxisRange.range(-60.0, 60.0), PosePartAxisRange.range(-60.0, 60.0), PosePartAxisRange.range(-120.0, 120.0));
    public static final PosePartMutator BODY = new PosePartMutator("body", ArmorStandPose::getBodyPose, ArmorStandPose::withBodyPose, PosePartAxisRange.range(-30.0, 30.0), PosePartAxisRange.range(-30.0, 30.0), PosePartAxisRange.range(-120.0, 120.0));
    public static final PosePartMutator RIGHT_ARM = new PosePartMutator("rightArm", ArmorStandPose::getRightArmPose, ArmorStandPose::withRightArmPose, PosePartAxisRange.range(-180.0, 0.0), PosePartAxisRange.range(-90.0, 45.0), PosePartAxisRange.range(-120.0, 120.0));
    public static final PosePartMutator LEFT_ARM = new PosePartMutator("leftArm", ArmorStandPose::getLeftArmPose, ArmorStandPose::withLeftArmPose, PosePartAxisRange.range(-180.0, 0.0), PosePartAxisRange.range(-45.0, 90.0), PosePartAxisRange.range(-120.0, 120.0));
    public static final PosePartMutator RIGHT_LEG = new PosePartMutator("rightLeg", ArmorStandPose::getRightLegPose, ArmorStandPose::withRightLegPose, PosePartAxisRange.range(-120.0, 120.0), PosePartAxisRange.range(-90.0, 0.0), PosePartAxisRange.range(-120.0, 120.0));
    public static final PosePartMutator LEFT_LEG = new PosePartMutator("leftLeg", ArmorStandPose::getLeftLegPose, ArmorStandPose::withLeftLegPose, PosePartAxisRange.range(-120.0, 120.0), PosePartAxisRange.range(0.0, 90.0), PosePartAxisRange.range(-120.0, 120.0));
    public static final String AXIS_X_TRANSLATION_KEY = "statues.screen.rotations.x";
    public static final String AXIS_Y_TRANSLATION_KEY = "statues.screen.rotations.y";
    public static final String AXIS_Z_TRANSLATION_KEY = "statues.screen.rotations.z";
    private final String name;
    private final Function<ArmorStandPose, class_2379> getRotations;
    private final BiFunction<ArmorStandPose, class_2379, ArmorStandPose> setRotations;
    private final PosePartAxisRange[] axisRanges;
    private final class_2350.class_2351[] axisOrder;
    private final byte invertedIndices;

    public PosePartMutator(String name, Function<ArmorStandPose, class_2379> getRotations, BiFunction<ArmorStandPose, class_2379, ArmorStandPose> setRotations, PosePartAxisRange rangeX, PosePartAxisRange rangeY, PosePartAxisRange rangeZ) {
        this(name, getRotations, setRotations, rangeX, rangeY, rangeZ, new class_2350.class_2351[]{class_2350.class_2351.field_11048, class_2350.class_2351.field_11052, class_2350.class_2351.field_11051}, class_2350.class_2351.field_11052);
    }

    public PosePartMutator(String name, Function<ArmorStandPose, class_2379> getRotations, BiFunction<ArmorStandPose, class_2379, ArmorStandPose> setRotations, PosePartAxisRange rangeX, PosePartAxisRange rangeY, PosePartAxisRange rangeZ, class_2350.class_2351[] axisOrder, class_2350.class_2351 ... invertedAxes) {
        this.name = name;
        this.getRotations = getRotations;
        this.setRotations = setRotations;
        this.axisRanges = new PosePartAxisRange[]{rangeX, rangeY, rangeZ};
        this.axisOrder = axisOrder;
        this.invertedIndices = PosePartMutator.computeInvertedIndices(invertedAxes);
    }

    private static byte computeInvertedIndices(class_2350.class_2351[] invertedAxes) {
        byte invertedIndices = 0;
        for (class_2350.class_2351 axis : invertedAxes) {
            invertedIndices = (byte)(invertedIndices | 1 << axis.ordinal());
        }
        return invertedIndices;
    }

    public String toString() {
        return this.name.toUpperCase(Locale.ROOT);
    }

    public String getTranslationKey() {
        return "statues.screen.rotations.pose." + this.name;
    }

    public class_2561 getAxisComponent(ArmorStandPose pose, int index) {
        double value = ArmorStandPose.snapValue(this.getRotationsAtAxis(index, pose), 0.125);
        return class_2561.method_43469((String)this.getAxisTranslationKey(this.getAxisAt(index)), (Object[])new Object[]{ArmorStandPose.ROTATION_FORMAT.format(value)});
    }

    private String getAxisTranslationKey(class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> AXIS_X_TRANSLATION_KEY;
            case class_2350.class_2351.field_11052 -> AXIS_Y_TRANSLATION_KEY;
            case class_2350.class_2351.field_11051 -> AXIS_Z_TRANSLATION_KEY;
        };
    }

    public double getRotationsAtAxis(int index, ArmorStandPose pose) {
        return this.getRotationsAtAxis(index, this.getRotations.apply(pose));
    }

    private double getRotationsAtAxis(int index, class_2379 rotations) {
        return switch (this.getAxisAt(index)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> this.invertAtAxis(class_2350.class_2351.field_11048, rotations.method_35845());
            case class_2350.class_2351.field_11052 -> this.invertAtAxis(class_2350.class_2351.field_11052, rotations.method_35846());
            case class_2350.class_2351.field_11051 -> this.invertAtAxis(class_2350.class_2351.field_11051, rotations.method_35847());
        };
    }

    public double getNormalizedRotationsAtAxis(int index, ArmorStandPose pose, boolean clampRotations) {
        return this.getNormalizedRotationsAtAxis(index, this.getRotations.apply(pose), clampRotations);
    }

    private double getNormalizedRotationsAtAxis(int index, class_2379 rotations, boolean clampRotations) {
        return switch (this.getAxisAt(index)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> (float)this.getAxisRangeAtAxis(class_2350.class_2351.field_11048, clampRotations).normalize(this.invertAtAxis(class_2350.class_2351.field_11048, rotations.method_35845()));
            case class_2350.class_2351.field_11052 -> (float)this.getAxisRangeAtAxis(class_2350.class_2351.field_11052, clampRotations).normalize(this.invertAtAxis(class_2350.class_2351.field_11052, rotations.method_35846()));
            case class_2350.class_2351.field_11051 -> (float)this.getAxisRangeAtAxis(class_2350.class_2351.field_11051, clampRotations).normalize(this.invertAtAxis(class_2350.class_2351.field_11051, rotations.method_35847()));
        };
    }

    private float invertAtAxis(class_2350.class_2351 axis, float value) {
        return (this.invertedIndices >> axis.ordinal() & 1) == 1 ? value * -1.0f : value;
    }

    public ArmorStandPose setRotationsAtAxis(int index, ArmorStandPose pose, double newValue, boolean clampRotations) {
        return this.setRotations.apply(pose, this.setRotationsAtAxis(index, this.getRotations.apply(pose), (float)this.getAxisRangeAtAxis(index, clampRotations).expand(newValue)));
    }

    private PosePartAxisRange getAxisRangeAtAxis(int index, boolean clampRotations) {
        return this.getAxisRangeAtAxis(this.getAxisAt(index), clampRotations);
    }

    private PosePartAxisRange getAxisRangeAtAxis(class_2350.class_2351 axis, boolean clampRotations) {
        return clampRotations ? this.axisRanges[axis.ordinal()] : PosePartAxisRange.fullRange();
    }

    private class_2379 setRotationsAtAxis(int index, class_2379 rotations, float newValue) {
        return switch (this.getAxisAt(index)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> new class_2379(this.invertAtAxis(class_2350.class_2351.field_11048, newValue), rotations.method_10257(), rotations.method_10258());
            case class_2350.class_2351.field_11052 -> new class_2379(rotations.method_10256(), this.invertAtAxis(class_2350.class_2351.field_11052, newValue), rotations.method_10258());
            case class_2350.class_2351.field_11051 -> new class_2379(rotations.method_10256(), rotations.method_10257(), this.invertAtAxis(class_2350.class_2351.field_11051, newValue));
        };
    }

    public class_2350.class_2351 getAxisAt(int index) {
        return this.axisOrder[index];
    }

    class_2379 randomRotations(boolean clampRotations) {
        class_2379 rotations = new class_2379((float)this.getAxisRangeAtAxis(class_2350.class_2351.field_11048, clampRotations).random(), (float)this.getAxisRangeAtAxis(class_2350.class_2351.field_11052, clampRotations).random(), (float)this.getAxisRangeAtAxis(class_2350.class_2351.field_11051, clampRotations).random());
        return clampRotations ? this.setRotationsAtAxis(2, rotations, 0.0f) : rotations;
    }

    public record PosePartAxisRange(double min, double max) {
        public static final double MIN_VALUE = -180.0;
        public static final double MAX_VALUE = 180.0;
        private static final Random RANDOM = new Random();

        public PosePartAxisRange {
            if (min >= max) {
                throw new IllegalArgumentException("Min must be smaller than max: %s >= %s".formatted(min, max));
            }
            if (class_3532.method_15350((double)min, (double)-180.0, (double)180.0) != min) {
                throw new IllegalArgumentException("Min out of bounds, must be between %s and %s, was %s".formatted(-180.0, 180.0, min));
            }
            if (class_3532.method_15350((double)max, (double)-180.0, (double)180.0) != max) {
                throw new IllegalArgumentException("Max out of bounds, must be between %s and %s, was %s".formatted(-180.0, 180.0, max));
            }
        }

        public static PosePartAxisRange fullRange() {
            return PosePartAxisRange.range(-180.0, 180.0);
        }

        public static PosePartAxisRange range(double min, double max) {
            return new PosePartAxisRange(min, max);
        }

        public double normalize(double expandedValue) {
            return (this.clamp(expandedValue) - this.min) / this.range();
        }

        public double expand(double normalizedValue) {
            return normalizedValue * this.range() + this.min;
        }

        public double clamp(double value) {
            return class_3532.method_15350((double)value, (double)this.min, (double)this.max);
        }

        public double random() {
            return RANDOM.nextDouble(this.range()) + this.min;
        }

        public double range() {
            return this.max - this.min;
        }
    }
}

