/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.network.client.data;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Unit;
import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandAlignment;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandStyleOption;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.BiPredicate;
import net.minecraft.class_124;
import net.minecraft.class_1531;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class CommandDataSyncHandler
implements DataSyncHandler {
    public static final String NO_PERMISSION_TRANSLATION_KEY = "armorstatues.dataSync.failure.noPermission";
    public static final String NO_ARMOR_STAND_TRANSLATION_KEY = "armorstatues.dataSync.failure.noArmorStand";
    public static final String OUT_OF_RANGE_TRANSLATION_KEY = "armorstatues.dataSync.failure.outOfRange";
    public static final String NOT_FINISHED_TRANSLATION_KEY = "armorstatues.dataSync.failure.notFinished";
    public static final String FINISHED_TRANSLATION_KEY = "armorstatues.dataSync.finished";
    public static final String FAILURE_TRANSLATION_KEY = "armorstatues.dataSync.failure";
    private static final Queue<String> CLIENT_COMMAND_QUEUE = new ArrayDeque<String>();
    @Nullable
    private static class_1531 queueArmorStand;
    private static int itemDequeuedTicks;
    private final ArmorStandHolder holder;
    protected final class_746 player;
    protected ArmorStandPose lastSyncedPose;

    public CommandDataSyncHandler(ArmorStandHolder holder, class_746 player) {
        this.holder = holder;
        this.lastSyncedPose = ArmorStandPose.fromEntity(this.holder.getArmorStand());
        this.player = player;
    }

    @Override
    public ArmorStandHolder getArmorStandHolder() {
        return this.holder;
    }

    @Override
    public void sendName(String name) {
        if (!this.isEditingAllowed()) {
            return;
        }
        DataSyncHandler.setCustomArmorStandName(this.getArmorStand(), name);
        class_2487 tag = new class_2487();
        tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)class_2561.method_43470((String)name)));
        this.enqueueEntityData(tag);
        this.finalizeCurrentOperation();
    }

    @Override
    public final void sendPose(ArmorStandPose pose) {
        this.sendPose(pose, true);
    }

    @Override
    public void sendPose(ArmorStandPose pose, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        this.sendPosePart(pose::serializeBodyPoses, this.lastSyncedPose);
        this.sendPosePart(pose::serializeArmPoses, this.lastSyncedPose);
        this.sendPosePart(pose::serializeLegPoses, this.lastSyncedPose);
        pose.applyToEntity(this.getArmorStand());
        this.lastSyncedPose = pose.copyAndFillFrom(this.lastSyncedPose);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    private void sendPosePart(BiPredicate<class_2487, ArmorStandPose> dataWriter, ArmorStandPose lastSyncedPose) {
        class_2487 tag = new class_2487();
        if (dataWriter.test(tag, lastSyncedPose)) {
            class_2487 tagToSend = new class_2487();
            tagToSend.method_10566("Pose", (class_2520)tag);
            this.enqueueEntityData(tagToSend);
        }
    }

    @Override
    @Nullable
    public ArmorStandPose getLastSyncedPose() {
        return this.lastSyncedPose;
    }

    @Override
    public final void sendPosition(double posX, double posY, double posZ) {
        this.sendPosition(posX, posY, posZ, true);
    }

    @Override
    public void sendPosition(double posX, double posY, double posZ, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        class_2499 listTag = new class_2499();
        listTag.add((Object)class_2489.method_23241((double)posX));
        listTag.add((Object)class_2489.method_23241((double)posY));
        listTag.add((Object)class_2489.method_23241((double)posZ));
        class_2487 tag = new class_2487();
        tag.method_10566("Pos", (class_2520)listTag);
        this.enqueueEntityData(tag);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    @Override
    public final void sendRotation(float rotation) {
        this.sendRotation(rotation, true);
    }

    @Override
    public void sendRotation(float rotation, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        class_2499 listTag = new class_2499();
        listTag.add((Object)class_2494.method_23244((float)rotation));
        class_2487 tag = new class_2487();
        tag.method_10566("Rotation", (class_2520)listTag);
        this.enqueueEntityData(tag);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    @Override
    public final void sendStyleOption(ArmorStandStyleOption styleOption, boolean value) {
        this.sendStyleOption(styleOption, value, true);
    }

    @Override
    public void sendStyleOption(ArmorStandStyleOption styleOption, boolean value, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        class_2487 tag = new class_2487();
        styleOption.toTag(tag, value);
        this.enqueueEntityData(tag);
        styleOption.setOption(this.getArmorStand(), value);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    @Override
    public void sendAlignment(ArmorStandAlignment alignment) {
        if (!this.isEditingAllowed()) {
            return;
        }
        DataSyncHandler.super.sendAlignment(alignment);
    }

    @Override
    public boolean supportsScreenType(ArmorStandScreenType screenType) {
        return !screenType.requiresServer();
    }

    @Override
    public void tick() {
        if (itemDequeuedTicks > 0) {
            --itemDequeuedTicks;
        }
        if (itemDequeuedTicks == 0 && queueArmorStand != null && !CLIENT_COMMAND_QUEUE.isEmpty()) {
            if (this.testArmorStand(queueArmorStand).right().isPresent()) {
                this.player.field_3944.method_45730(CLIENT_COMMAND_QUEUE.poll());
            } else {
                CLIENT_COMMAND_QUEUE.clear();
            }
            itemDequeuedTicks = this.getDequeueDelayTicks();
        } else if (itemDequeuedTicks == 1 && CLIENT_COMMAND_QUEUE.isEmpty()) {
            this.sendDisplayMessage((class_2561)class_2561.method_43471((String)FINISHED_TRANSLATION_KEY), false);
        }
    }

    protected int getDequeueDelayTicks() {
        return 5;
    }

    @Override
    public boolean shouldContinueTicking() {
        return !CLIENT_COMMAND_QUEUE.isEmpty() || itemDequeuedTicks != 0;
    }

    protected boolean isEditingAllowed() {
        return this.isEditingAllowed(true);
    }

    protected final boolean isEditingAllowed(boolean testPermissionLevel) {
        if (testPermissionLevel && !this.player.method_5687(2)) {
            this.sendFailureMessage((class_2561)class_2561.method_43471((String)NO_PERMISSION_TRANSLATION_KEY));
            return false;
        }
        return this.testArmorStand(this.getArmorStand()).ifLeft(this::sendFailureMessage).right().isPresent();
    }

    protected Either<class_2561, Unit> testArmorStand(class_1531 armorStand) {
        return !armorStand.method_5805() ? Either.left((Object)class_2561.method_43471((String)NO_ARMOR_STAND_TRANSLATION_KEY)) : Either.right((Object)Unit.INSTANCE);
    }

    protected boolean enqueueClientCommand(String clientCommand) {
        if (CLIENT_COMMAND_QUEUE.isEmpty()) {
            queueArmorStand = null;
        } else if (queueArmorStand != null) {
            this.sendFailureMessage((class_2561)class_2561.method_43471((String)NOT_FINISHED_TRANSLATION_KEY));
            return false;
        }
        CLIENT_COMMAND_QUEUE.offer(clientCommand);
        return true;
    }

    @Override
    public void finalizeCurrentOperation() {
        if (!CLIENT_COMMAND_QUEUE.isEmpty()) {
            queueArmorStand = this.getArmorStand();
        }
    }

    protected void sendFailureMessage(class_2561 component) {
        this.sendDisplayMessage((class_2561)class_2561.method_43469((String)FAILURE_TRANSLATION_KEY, (Object[])new Object[]{component}), true);
    }

    protected void sendDisplayMessage(class_2561 component, boolean failure) {
        this.player.method_7353((class_2561)class_2561.method_43473().method_10852(component).method_27692(failure ? class_124.field_1061 : class_124.field_1060), false);
    }

    private void enqueueEntityData(class_2487 tag) {
        this.enqueueClientCommand("data merge entity %s %s".formatted(this.getArmorStand().method_5845(), tag.method_10714()));
    }
}

