/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic;

import io.github.kvverti.colormatic.ColormaticConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ColormaticConfigController {
    private static final Logger log = LogManager.getLogger();
    private static final File configFile;
    private static final ColormaticConfig defaults;
    private static final String CLEAR_SKY = "fog.clearSky";
    private static final String CLEAR_VOID = "fog.clearVoid";
    private static final String BLEND_SKY_LIGHT = "light.blendSkyLight";
    private static final String FLICKER_BLOCK_LIGHT = "light.flickerBlockLight";
    private static final String RELATIVE_BLOCK_LIGHT_INTENSITY = "light.relativeBlockLightIntensity";

    private ColormaticConfigController() {
    }

    public static class_437 getConfigScreen(ColormaticConfig config, class_437 parent) {
        return null;
    }

    public static void load(ColormaticConfig config) {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(configFile));
            config.clearSky = ColormaticConfigController.loadOrDefault(props, CLEAR_SKY, Boolean::valueOf, ColormaticConfigController.defaults.clearSky);
            config.clearVoid = ColormaticConfigController.loadOrDefault(props, CLEAR_VOID, Boolean::valueOf, ColormaticConfigController.defaults.clearVoid);
            config.blendSkyLight = ColormaticConfigController.loadOrDefault(props, BLEND_SKY_LIGHT, Boolean::valueOf, ColormaticConfigController.defaults.blendSkyLight);
            config.flickerBlockLight = ColormaticConfigController.loadOrDefault(props, FLICKER_BLOCK_LIGHT, Boolean::valueOf, ColormaticConfigController.defaults.flickerBlockLight);
            config.relativeBlockLightIntensityExponent = ColormaticConfigController.loadOrDefault(props, RELATIVE_BLOCK_LIGHT_INTENSITY, Double::valueOf, ColormaticConfigController.defaults.relativeBlockLightIntensityExponent);
        }
        catch (IOException e) {
            log.warn("Could not load configuration settings");
        }
    }

    private static <T> T loadOrDefault(Properties props, String key, Function<String, T> parse, T fallback) {
        String value = props.getProperty(key);
        if (value == null) {
            return fallback;
        }
        return parse.apply(value);
    }

    public static void persist(ColormaticConfig config) {
        Properties props = new Properties();
        props.setProperty(CLEAR_SKY, String.valueOf(config.clearSky));
        props.setProperty(CLEAR_VOID, String.valueOf(config.clearVoid));
        props.setProperty(BLEND_SKY_LIGHT, String.valueOf(config.blendSkyLight));
        props.setProperty(FLICKER_BLOCK_LIGHT, String.valueOf(config.flickerBlockLight));
        props.setProperty(RELATIVE_BLOCK_LIGHT_INTENSITY, String.valueOf(config.relativeBlockLightIntensityExponent));
        try {
            configFile.createNewFile();
            props.store(new FileOutputStream(configFile), "Colormatic Config");
        }
        catch (IOException e) {
            log.warn("Could not save configuration settings");
        }
    }

    static {
        defaults = new ColormaticConfig();
        configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "colormatic.properties");
        try {
            if (configFile.createNewFile()) {
                ColormaticConfigController.persist(new ColormaticConfig());
            }
        }
        catch (IOException e) {
            log.warn("Could not create configuration file");
        }
    }
}

