/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.colormap;

import io.github.kvverti.colormatic.Colormatic;
import io.github.kvverti.colormatic.colormap.ColormaticResolver;
import io.github.kvverti.colormatic.colormap.ExtendedColorResolver;
import io.github.kvverti.colormatic.properties.ColormapProperties;
import io.github.kvverti.colormatic.properties.HexColor;
import java.util.Random;
import net.minecraft.class_1011;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7924;

public class BiomeColormap
implements ColormaticResolver {
    private static final Random GRID_RANDOM = new Random(47L);
    private final ColormapProperties properties;
    private final class_1011 colormap;
    private transient int defaultColor;
    private final transient ExtendedColorResolver resolver;

    public BiomeColormap(ColormapProperties props, class_1011 image) {
        this.properties = props;
        this.colormap = image;
        HexColor col = props.getColor();
        this.defaultColor = col != null ? col.rgb() : -1;
        this.resolver = new ExtendedColorResolver(this);
    }

    private int computeDefaultColor(class_1920 world, ColormapProperties props) {
        switch (props.getFormat()) {
            case VANILLA: {
                return this.colormap.method_4315(128, 128);
            }
            case GRID: {
                try {
                    int x = props.getColumn((class_5321<class_1959>)class_1972.field_9451, (class_2378<class_1959>)class_310.method_1551().field_1687.method_30349().method_30530((class_5321)class_7924.field_41236)).column;
                    int y = class_3532.method_15340((int)(63 - props.getOffset()), (int)0, (int)(this.colormap.method_4323() - 1));
                    return this.colormap.method_4315(x, y);
                }
                catch (IllegalArgumentException e) {
                    return -1;
                }
            }
            case FIXED: {
                return -1;
            }
        }
        throw new AssertionError();
    }

    public ColormapProperties getProperties() {
        return this.properties;
    }

    private int getColor(double temp, double rain) {
        int x = (int)((1.0 - temp) * 255.0);
        int y = (int)((1.0 - (rain *= temp)) * 255.0);
        if (x >= this.colormap.method_4307() || y >= this.colormap.method_4323()) {
            return -65281;
        }
        return this.colormap.method_4315(x, y);
    }

    @Override
    public int getColor(class_5455 manager, class_1959 biome, int posX, int posY, int posZ) {
        switch (this.properties.getFormat()) {
            case VANILLA: {
                double temp = biome.method_8712();
                temp = class_3532.method_15350((double)temp, (double)0.0, (double)1.0);
                double rain = class_3532.method_15363((float)biome.field_26393.comp_846(), (float)0.0f, (float)1.0f);
                return this.getColor(temp, rain);
            }
            case GRID: {
                ColormapProperties.ColumnBounds cb = this.properties.getColumn(Colormatic.getBiomeKey(manager, biome), (class_2378<class_1959>)manager.method_30530(class_7924.field_41236));
                double frac = class_1959.field_9324.method_16451((double)posX * 0.0225, (double)posZ * 0.0225, false);
                frac = (frac + 1.0) / 2.0;
                int x = cb.column + (int)(frac * (double)cb.count);
                int y = posY - this.properties.getOffset();
                int variance = this.properties.getVariance();
                GRID_RANDOM.setSeed((long)posX * 31L + (long)posZ);
                y += GRID_RANDOM.nextInt(variance * 2 + 1) - variance;
                y = class_3532.method_15340((int)y, (int)0, (int)(this.colormap.method_4323() - 1));
                return this.colormap.method_4315(x %= this.colormap.method_4307(), y);
            }
            case FIXED: {
                return this.getDefaultColor();
            }
        }
        throw new AssertionError();
    }

    public int getDefaultColor() {
        return this.defaultColor;
    }

    public static int getBiomeColor(class_1920 world, class_2338 pos, BiomeColormap colormap) {
        if (world == null || pos == null) {
            return colormap.getDefaultColor();
        }
        if (colormap.defaultColor == -1) {
            colormap.defaultColor = colormap.computeDefaultColor(world, colormap.properties);
        }
        return colormap.resolver.resolveExtendedColor(world, pos);
    }
}

