/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.colormap;

import io.github.kvverti.colormatic.colormap.BiomeColormap;
import io.github.kvverti.colormatic.colormap.ColormapStorage;
import io.github.kvverti.colormatic.colormap.ColormaticResolver;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_5455;
import net.minecraft.class_6539;
import org.jetbrains.annotations.Nullable;

public final class ExtendedColorResolver
implements class_6539 {
    @Nullable
    private static class_5455 registryManager;
    private final ThreadLocal<CoordinateY> posY = ThreadLocal.withInitial(CoordinateY::new);
    private final ColormaticResolver wrappedResolver;

    <K> ExtendedColorResolver(ColormapStorage<K> storage, K key, ColormaticResolver fallback) {
        this.wrappedResolver = ExtendedColorResolver.createResolver(storage, key, fallback);
    }

    ExtendedColorResolver(ColormaticResolver wrappedResolver) {
        this.wrappedResolver = wrappedResolver;
    }

    public int resolveExtendedColor(class_1920 world, class_2338 pos) {
        this.posY.get().y = pos.method_10264();
        return world.method_23752(pos, (class_6539)this);
    }

    public ColormaticResolver getWrappedResolver() {
        return this.wrappedResolver;
    }

    public int getColor(class_1959 biome, double x, double z) {
        return 0xFFFEFEFE & this.wrappedResolver.getColor(registryManager, biome, (int)x, this.posY.get().y, (int)z);
    }

    public static void setRegistryManager(@Nullable class_5455 manager) {
        registryManager = manager;
    }

    private static <K> ColormaticResolver createResolver(ColormapStorage<K> storage, K key, ColormaticResolver fallback) {
        final class StoredData {
            @Nullable
            class_1959 lastBiome;
            @Nullable
            BiomeColormap lastColormap;

            StoredData() {
            }
        }
        ThreadLocal<StoredData> data = ThreadLocal.withInitial(() -> new StoredData());
        return (manager, biome, posX, posY, posZ) -> {
            BiomeColormap colormap;
            StoredData storedData = (StoredData)data.get();
            if (storedData.lastBiome != biome) {
                storedData.lastColormap = storage.get(manager, key, biome);
                storedData.lastBiome = biome;
            }
            return (colormap = storedData.lastColormap) != null ? colormap.getColor(manager, biome, posX, posY, posZ) : fallback.getColor(manager, biome, posX, posY, posZ);
        };
    }

    private static final class CoordinateY {
        int y;

        private CoordinateY() {
        }
    }
}

