/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.properties;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class BiomeRenaming {
    private static final Logger log = LogManager.getLogger((String)"colormatic");
    private static final Set<class_2960> REMOVED_BIOMES = BiomeRenaming.createRemovedBiomeSet();
    private static final Map<class_2960, class_2960> RENAMED_BIOMES = BiomeRenaming.createRenamedBiomeMap();

    @Nullable
    public static class_2960 updateName(class_2960 biomeId, class_2960 context) {
        if (REMOVED_BIOMES.contains(biomeId)) {
            log.warn("{}: Biome ID '{}' no longer exists and should be removed", (Object)context, (Object)biomeId);
            return null;
        }
        class_2960 renamed = RENAMED_BIOMES.get(biomeId);
        if (renamed != null) {
            log.warn("{}: Biome ID '{}' has been renamed to '{}' and should be updated", (Object)context, (Object)biomeId, (Object)renamed);
            return renamed;
        }
        return biomeId;
    }

    private static Set<class_2960> createRemovedBiomeSet() {
        HashSet<class_2960> set = new HashSet<class_2960>();
        set.add(new class_2960("snowy_taiga_mountains"));
        set.add(new class_2960("giant_tree_taiga_hills"));
        set.add(new class_2960("taiga_hills"));
        set.add(new class_2960("modified_gravelly_mountains"));
        set.add(new class_2960("desert_hills"));
        set.add(new class_2960("snowy_taiga_hills"));
        set.add(new class_2960("jungle_hills"));
        set.add(new class_2960("mushroom_field_shore"));
        set.add(new class_2960("shattered_savanna_plateau"));
        set.add(new class_2960("mountain_edge"));
        set.add(new class_2960("wooded_hills"));
        set.add(new class_2960("bamboo_jungle_hills"));
        set.add(new class_2960("modified_wooded_badlands_plateau"));
        set.add(new class_2960("desert_lakes"));
        set.add(new class_2960("dark_forest_hills"));
        set.add(new class_2960("birch_forest_hills"));
        set.add(new class_2960("modified_badlands_plateau"));
        set.add(new class_2960("badlands_plateau"));
        set.add(new class_2960("modified_jungle_edge"));
        set.add(new class_2960("giant_spruce_taiga_hills"));
        set.add(new class_2960("swamp_hills"));
        set.add(new class_2960("modified_jungle"));
        set.add(new class_2960("tall_birch_hills"));
        set.add(new class_2960("snowy_mountains"));
        set.add(new class_2960("deep_warm_ocean"));
        return set;
    }

    private static Map<class_2960, class_2960> createRenamedBiomeMap() {
        HashMap<class_2960, class_2960> map = new HashMap<class_2960, class_2960>();
        map.put(new class_2960("mountains"), new class_2960("windswept_hills"));
        map.put(new class_2960("snowy_tundra"), new class_2960("snowy_plains"));
        map.put(new class_2960("jungle_edge"), new class_2960("sparse_jungle"));
        map.put(new class_2960("stone_shore"), new class_2960("stony_shore"));
        map.put(new class_2960("giant_tree_taiga"), new class_2960("old_growth_pine_taiga"));
        map.put(new class_2960("wooded_mountains"), new class_2960("windswept_forest"));
        map.put(new class_2960("wooded_badlands_plateau"), new class_2960("wooded_badlands"));
        map.put(new class_2960("gravelly_mountains"), new class_2960("windswept_gravelly_hills"));
        map.put(new class_2960("tall_birch_forest"), new class_2960("old_growth_birch_forest"));
        map.put(new class_2960("giant_spruce_taiga"), new class_2960("old_growth_spruce_taiga"));
        map.put(new class_2960("shattered_savanna"), new class_2960("windswept_savanna"));
        return map;
    }
}

