/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.properties;

import com.mojang.serialization.Lifecycle;
import io.github.kvverti.colormatic.properties.ColormapProperties;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DefaultColumns {
    private static final Logger log = LogManager.getLogger();
    private static final Map<class_2960, class_2960> dynamicColumns = new HashMap<class_2960, class_2960>();
    public static Map<class_2960, ColormapProperties.ColumnBounds> currentColumns;
    private static final Map<class_2960, ColormapProperties.ColumnBounds> legacyColumns;
    private static final Map<class_2960, ColormapProperties.ColumnBounds> stableColumns;
    private static final int LEGACY_1_17_BIOME_COUNT = 176;
    private static final Object2IntMap<String> biomes;

    private DefaultColumns() {
    }

    public static ColormapProperties.ColumnBounds getDefaultBounds(class_5321<class_1959> biomeKey) {
        ColormapProperties.ColumnBounds bounds = currentColumns.get(biomeKey.method_29177());
        if (bounds == null && (bounds = currentColumns.get(DefaultColumns.approximateToVanilla(biomeKey))) == null) {
            String msg = "Custom biome has no approximate: " + biomeKey.method_29177();
            log.error(msg);
            throw new IllegalStateException(msg);
        }
        return bounds;
    }

    public static ColormapProperties.ColumnBounds getOptifineBounds(class_5321<class_1959> biomeKey, class_2378<class_1959> biomeRegistry) {
        int rawID = biomes.getOrDefault((Object)biomeKey.method_29177().method_12832(), -1);
        return new ColormapProperties.ColumnBounds(rawID, 1);
    }

    private static class_2378<class_1959> fixBiomeIds(class_2378<class_1959> idRegistry, class_2378<class_1959> valueRegistry) {
        class_1959 biome;
        class_2370 registry = new class_2370(class_5321.method_29180((class_2960)new class_2960("biomes")), Lifecycle.stable(), true);
        for (class_5321 biomeKey : idRegistry.method_42021()) {
            biome = (class_1959)valueRegistry.method_29107(biomeKey);
            if (biome == null) {
                biome = (class_1959)idRegistry.method_29107(biomeKey);
            }
            int id = idRegistry.method_10206((Object)((class_1959)idRegistry.method_29107(biomeKey)));
            registry.method_40269((Object)biome);
            class_6880.class_6883 class_68832 = registry.method_46744(id, biomeKey, (Object)biome, Lifecycle.stable());
        }
        for (class_5321 biomeKey : valueRegistry.method_42021()) {
            if (registry.method_35842(biomeKey)) continue;
            biome = (class_1959)valueRegistry.method_29107(biomeKey);
            registry.method_40269((Object)biome);
            class_6880.class_6883 class_68833 = registry.method_10272(biomeKey, (Object)biome, Lifecycle.stable());
        }
        return registry;
    }

    public static ColormapProperties.ColumnBounds getLegacyBounds(class_5321<class_1959> biomeKey, class_2378<class_1959> biomeRegistry, boolean optifine) {
        ColormapProperties.ColumnBounds bounds = legacyColumns.get(biomeKey.method_29177());
        if (bounds == null) {
            if (optifine) {
                int rawID = biomeRegistry.method_10206((Object)((class_1959)biomeRegistry.method_29107(biomeKey)));
                return new ColormapProperties.ColumnBounds(rawID - biomeRegistry.method_10204() + 176, 1);
            }
            bounds = legacyColumns.get(DefaultColumns.approximateToVanilla(biomeKey));
            if (bounds == null) {
                String msg = "Custom biome has no approximate: " + biomeKey.method_29177();
                log.error(msg);
                throw new IllegalStateException(msg);
            }
        }
        return bounds;
    }

    public static ColormapProperties.ColumnBounds getStableBounds(class_5321<class_1959> biomeKey) {
        ColormapProperties.ColumnBounds bounds = stableColumns.get(biomeKey.method_29177());
        if (bounds == null && (bounds = stableColumns.get(DefaultColumns.approximateToVanilla(biomeKey))) == null) {
            String msg = "Custom biome has no approximate: " + biomeKey.method_29177();
            log.error(msg);
            throw new IllegalStateException(msg);
        }
        return bounds;
    }

    private static class_2960 approximateToVanilla(class_5321<class_1959> biomeKey) {
        class_2960 id = dynamicColumns.get(biomeKey.method_29177());
        if (id == null) {
            String msg = "No column bounds for dynamic biome: " + biomeKey.method_29177();
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        return id;
    }

    public static void reloadDefaultColumnBounds(class_5455 manager) {
        dynamicColumns.clear();
        if (manager != null) {
            class_2378 biomeRegistry = manager.method_30530(class_7924.field_41236);
            for (Map.Entry entry : biomeRegistry.method_29722()) {
                class_5321 key = (class_5321)entry.getKey();
                if (currentColumns.containsKey(key.method_29177())) continue;
                dynamicColumns.put(key.method_29177(), DefaultColumns.computeClosestDefaultBiome((class_5321<class_1959>)key, (class_2378<class_1959>)biomeRegistry));
            }
        }
    }

    private static class_2960 computeClosestDefaultBiome(class_5321<class_1959> biomeKey, class_2378<class_1959> biomeRegistry) {
        class_1959 customBiome = (class_1959)biomeRegistry.method_29107(biomeKey);
        if (customBiome == null) {
            throw new IllegalStateException("Biome is not registered: " + biomeKey.method_29177());
        }
        double temperature = customBiome.method_8712();
        double humidity = class_3532.method_15350((double)customBiome.field_26393.comp_846(), (double)0.0, (double)1.0);
        double minDistanceSq = Double.POSITIVE_INFINITY;
        class_2960 minBiomeId = null;
        for (Map.Entry<class_2960, ColormapProperties.ColumnBounds> entry : currentColumns.entrySet()) {
            double dHumidity;
            class_1959 vanillaBiome = (class_1959)biomeRegistry.method_10223(entry.getKey());
            if (vanillaBiome == null) {
                log.error("Vanilla biome is not registered????? : {}", (Object)entry.getKey());
                continue;
            }
            double dTemperature = temperature - (double)vanillaBiome.method_8712();
            double thisDistanceSq = dTemperature * dTemperature + (dHumidity = humidity - class_3532.method_15350((double)vanillaBiome.field_26393.comp_846(), (double)0.0, (double)1.0)) * dHumidity;
            if (!(thisDistanceSq < minDistanceSq)) continue;
            minDistanceSq = thisDistanceSq;
            minBiomeId = entry.getKey();
        }
        return minBiomeId;
    }

    public static Map<class_2960, ColormapProperties.ColumnBounds> createCurrentColumnBounds(class_1937 world) {
        if (world == null) {
            return Collections.emptyMap();
        }
        HashMap<class_2960, ColormapProperties.ColumnBounds> map = new HashMap<class_2960, ColormapProperties.ColumnBounds>();
        class_2378 biomeRegistry = world.method_30349().method_30530(class_7924.field_41236);
        for (class_1959 biome : biomeRegistry) {
            class_2960 id = biomeRegistry.method_10221((Object)biome);
            int rawId = biomeRegistry.method_10206((Object)biome);
            map.put(id, new ColormapProperties.ColumnBounds(rawId, 1));
        }
        return map;
    }

    private static Map<class_2960, ColormapProperties.ColumnBounds> createLegacyColumnBounds() {
        HashMap<class_2960, ColormapProperties.ColumnBounds> map = new HashMap<class_2960, ColormapProperties.ColumnBounds>();
        map.put(class_1972.field_9423.method_29177(), new ColormapProperties.ColumnBounds(0, 1));
        map.put(class_1972.field_9451.method_29177(), new ColormapProperties.ColumnBounds(1, 1));
        map.put(class_1972.field_9424.method_29177(), new ColormapProperties.ColumnBounds(2, 1));
        map.put(class_1972.field_35116.method_29177(), new ColormapProperties.ColumnBounds(3, 1));
        map.put(class_1972.field_9409.method_29177(), new ColormapProperties.ColumnBounds(4, 1));
        map.put(class_1972.field_9420.method_29177(), new ColormapProperties.ColumnBounds(5, 1));
        map.put(class_1972.field_9471.method_29177(), new ColormapProperties.ColumnBounds(6, 1));
        map.put(class_1972.field_9438.method_29177(), new ColormapProperties.ColumnBounds(7, 1));
        map.put(class_1972.field_9461.method_29177(), new ColormapProperties.ColumnBounds(8, 1));
        map.put(class_1972.field_9411.method_29177(), new ColormapProperties.ColumnBounds(9, 1));
        map.put(class_1972.field_9435.method_29177(), new ColormapProperties.ColumnBounds(10, 1));
        map.put(class_1972.field_9463.method_29177(), new ColormapProperties.ColumnBounds(11, 1));
        map.put(class_1972.field_35117.method_29177(), new ColormapProperties.ColumnBounds(12, 1));
        map.put(class_1972.field_9462.method_29177(), new ColormapProperties.ColumnBounds(14, 1));
        map.put(class_1972.field_9434.method_29177(), new ColormapProperties.ColumnBounds(16, 1));
        map.put(class_1972.field_9417.method_29177(), new ColormapProperties.ColumnBounds(21, 1));
        map.put(class_1972.field_35118.method_29177(), new ColormapProperties.ColumnBounds(23, 1));
        map.put(class_1972.field_9446.method_29177(), new ColormapProperties.ColumnBounds(24, 1));
        map.put(class_1972.field_9419.method_29177(), new ColormapProperties.ColumnBounds(25, 1));
        map.put(class_1972.field_9478.method_29177(), new ColormapProperties.ColumnBounds(26, 1));
        map.put(class_1972.field_9412.method_29177(), new ColormapProperties.ColumnBounds(27, 1));
        map.put(class_1972.field_9475.method_29177(), new ColormapProperties.ColumnBounds(29, 1));
        map.put(class_1972.field_9454.method_29177(), new ColormapProperties.ColumnBounds(30, 1));
        map.put(class_1972.field_35119.method_29177(), new ColormapProperties.ColumnBounds(32, 1));
        map.put(class_1972.field_35120.method_29177(), new ColormapProperties.ColumnBounds(34, 1));
        map.put(class_1972.field_9449.method_29177(), new ColormapProperties.ColumnBounds(35, 1));
        map.put(class_1972.field_9430.method_29177(), new ColormapProperties.ColumnBounds(36, 1));
        map.put(class_1972.field_9415.method_29177(), new ColormapProperties.ColumnBounds(37, 1));
        map.put(class_1972.field_35110.method_29177(), new ColormapProperties.ColumnBounds(38, 1));
        map.put(class_1972.field_9457.method_29177(), new ColormapProperties.ColumnBounds(40, 1));
        map.put(class_1972.field_9447.method_29177(), new ColormapProperties.ColumnBounds(41, 1));
        map.put(class_1972.field_9442.method_29177(), new ColormapProperties.ColumnBounds(42, 1));
        map.put(class_1972.field_9465.method_29177(), new ColormapProperties.ColumnBounds(43, 1));
        map.put(class_1972.field_9408.method_29177(), new ColormapProperties.ColumnBounds(44, 1));
        map.put(class_1972.field_9441.method_29177(), new ColormapProperties.ColumnBounds(45, 1));
        map.put(class_1972.field_9467.method_29177(), new ColormapProperties.ColumnBounds(46, 1));
        map.put(class_1972.field_9439.method_29177(), new ColormapProperties.ColumnBounds(48, 1));
        map.put(class_1972.field_9470.method_29177(), new ColormapProperties.ColumnBounds(49, 1));
        map.put(class_1972.field_9418.method_29177(), new ColormapProperties.ColumnBounds(50, 1));
        map.put(class_1972.field_9473.method_29177(), new ColormapProperties.ColumnBounds(127, 1));
        map.put(class_1972.field_9455.method_29177(), new ColormapProperties.ColumnBounds(129, 1));
        map.put(class_1972.field_35111.method_29177(), new ColormapProperties.ColumnBounds(131, 1));
        map.put(class_1972.field_9414.method_29177(), new ColormapProperties.ColumnBounds(132, 1));
        map.put(class_1972.field_9453.method_29177(), new ColormapProperties.ColumnBounds(140, 1));
        map.put(class_1972.field_35112.method_29177(), new ColormapProperties.ColumnBounds(155, 1));
        map.put(class_1972.field_35113.method_29177(), new ColormapProperties.ColumnBounds(160, 1));
        map.put(class_1972.field_35114.method_29177(), new ColormapProperties.ColumnBounds(163, 1));
        map.put(class_1972.field_9443.method_29177(), new ColormapProperties.ColumnBounds(165, 1));
        map.put(class_1972.field_9440.method_29177(), new ColormapProperties.ColumnBounds(168, 1));
        map.put(class_1972.field_22076.method_29177(), new ColormapProperties.ColumnBounds(170, 1));
        map.put(class_1972.field_22077.method_29177(), new ColormapProperties.ColumnBounds(171, 1));
        map.put(class_1972.field_22075.method_29177(), new ColormapProperties.ColumnBounds(172, 1));
        map.put(class_1972.field_23859.method_29177(), new ColormapProperties.ColumnBounds(173, 1));
        map.put(class_1972.field_28107.method_29177(), new ColormapProperties.ColumnBounds(174, 1));
        map.put(class_1972.field_29218.method_29177(), new ColormapProperties.ColumnBounds(175, 1));
        map.put(class_1972.field_34470.method_29177(), new ColormapProperties.ColumnBounds(1, 1));
        map.put(class_1972.field_34471.method_29177(), new ColormapProperties.ColumnBounds(30, 1));
        map.put(class_1972.field_34472.method_29177(), new ColormapProperties.ColumnBounds(12, 1));
        map.put(class_1972.field_35115.method_29177(), new ColormapProperties.ColumnBounds(12, 1));
        map.put(class_1972.field_34474.method_29177(), new ColormapProperties.ColumnBounds(3, 1));
        map.put(class_1972.field_34475.method_29177(), new ColormapProperties.ColumnBounds(3, 1));
        map.put(class_1972.field_38748.method_29177(), new ColormapProperties.ColumnBounds(6, 1));
        map.put(class_1972.field_37543.method_29177(), new ColormapProperties.ColumnBounds(175, 1));
        return map;
    }

    private static Map<class_2960, ColormapProperties.ColumnBounds> createStableColumnBounds() {
        HashMap<class_2960, ColormapProperties.ColumnBounds> map = new HashMap<class_2960, ColormapProperties.ColumnBounds>();
        map.put(class_1972.field_9473.method_29177(), new ColormapProperties.ColumnBounds(0, 1));
        map.put(class_1972.field_9451.method_29177(), new ColormapProperties.ColumnBounds(1, 1));
        map.put(class_1972.field_9455.method_29177(), new ColormapProperties.ColumnBounds(2, 1));
        map.put(class_1972.field_35117.method_29177(), new ColormapProperties.ColumnBounds(3, 1));
        map.put(class_1972.field_9453.method_29177(), new ColormapProperties.ColumnBounds(4, 1));
        map.put(class_1972.field_9424.method_29177(), new ColormapProperties.ColumnBounds(5, 1));
        map.put(class_1972.field_9471.method_29177(), new ColormapProperties.ColumnBounds(6, 1));
        map.put(class_1972.field_9409.method_29177(), new ColormapProperties.ColumnBounds(7, 1));
        map.put(class_1972.field_9414.method_29177(), new ColormapProperties.ColumnBounds(8, 1));
        map.put(class_1972.field_9412.method_29177(), new ColormapProperties.ColumnBounds(9, 1));
        map.put(class_1972.field_9475.method_29177(), new ColormapProperties.ColumnBounds(10, 1));
        map.put(class_1972.field_35112.method_29177(), new ColormapProperties.ColumnBounds(11, 1));
        map.put(class_1972.field_35119.method_29177(), new ColormapProperties.ColumnBounds(12, 1));
        map.put(class_1972.field_35113.method_29177(), new ColormapProperties.ColumnBounds(13, 1));
        map.put(class_1972.field_9420.method_29177(), new ColormapProperties.ColumnBounds(14, 1));
        map.put(class_1972.field_9454.method_29177(), new ColormapProperties.ColumnBounds(15, 1));
        map.put(class_1972.field_9449.method_29177(), new ColormapProperties.ColumnBounds(16, 1));
        map.put(class_1972.field_9430.method_29177(), new ColormapProperties.ColumnBounds(17, 1));
        map.put(class_1972.field_35116.method_29177(), new ColormapProperties.ColumnBounds(18, 1));
        map.put(class_1972.field_35111.method_29177(), new ColormapProperties.ColumnBounds(19, 1));
        map.put(class_1972.field_35120.method_29177(), new ColormapProperties.ColumnBounds(20, 1));
        map.put(class_1972.field_35114.method_29177(), new ColormapProperties.ColumnBounds(21, 1));
        map.put(class_1972.field_9417.method_29177(), new ColormapProperties.ColumnBounds(22, 1));
        map.put(class_1972.field_35118.method_29177(), new ColormapProperties.ColumnBounds(23, 1));
        map.put(class_1972.field_9440.method_29177(), new ColormapProperties.ColumnBounds(24, 1));
        map.put(class_1972.field_9415.method_29177(), new ColormapProperties.ColumnBounds(25, 1));
        map.put(class_1972.field_9443.method_29177(), new ColormapProperties.ColumnBounds(26, 1));
        map.put(class_1972.field_35110.method_29177(), new ColormapProperties.ColumnBounds(27, 1));
        map.put(class_1972.field_34470.method_29177(), new ColormapProperties.ColumnBounds(28, 1));
        map.put(class_1972.field_34471.method_29177(), new ColormapProperties.ColumnBounds(29, 1));
        map.put(class_1972.field_34472.method_29177(), new ColormapProperties.ColumnBounds(30, 1));
        map.put(class_1972.field_35115.method_29177(), new ColormapProperties.ColumnBounds(31, 1));
        map.put(class_1972.field_34474.method_29177(), new ColormapProperties.ColumnBounds(32, 1));
        map.put(class_1972.field_34475.method_29177(), new ColormapProperties.ColumnBounds(33, 1));
        map.put(class_1972.field_9438.method_29177(), new ColormapProperties.ColumnBounds(34, 1));
        map.put(class_1972.field_9463.method_29177(), new ColormapProperties.ColumnBounds(35, 1));
        map.put(class_1972.field_9434.method_29177(), new ColormapProperties.ColumnBounds(36, 1));
        map.put(class_1972.field_9478.method_29177(), new ColormapProperties.ColumnBounds(37, 1));
        map.put(class_1972.field_9419.method_29177(), new ColormapProperties.ColumnBounds(38, 1));
        map.put(class_1972.field_9408.method_29177(), new ColormapProperties.ColumnBounds(39, 1));
        map.put(class_1972.field_9441.method_29177(), new ColormapProperties.ColumnBounds(40, 1));
        map.put(class_1972.field_9439.method_29177(), new ColormapProperties.ColumnBounds(41, 1));
        map.put(class_1972.field_9423.method_29177(), new ColormapProperties.ColumnBounds(42, 1));
        map.put(class_1972.field_9446.method_29177(), new ColormapProperties.ColumnBounds(43, 1));
        map.put(class_1972.field_9467.method_29177(), new ColormapProperties.ColumnBounds(44, 1));
        map.put(class_1972.field_9470.method_29177(), new ColormapProperties.ColumnBounds(45, 1));
        map.put(class_1972.field_9435.method_29177(), new ColormapProperties.ColumnBounds(46, 1));
        map.put(class_1972.field_9418.method_29177(), new ColormapProperties.ColumnBounds(47, 1));
        map.put(class_1972.field_9462.method_29177(), new ColormapProperties.ColumnBounds(48, 1));
        map.put(class_1972.field_28107.method_29177(), new ColormapProperties.ColumnBounds(49, 1));
        map.put(class_1972.field_29218.method_29177(), new ColormapProperties.ColumnBounds(50, 1));
        map.put(class_1972.field_9461.method_29177(), new ColormapProperties.ColumnBounds(51, 1));
        map.put(class_1972.field_22075.method_29177(), new ColormapProperties.ColumnBounds(52, 1));
        map.put(class_1972.field_22077.method_29177(), new ColormapProperties.ColumnBounds(53, 1));
        map.put(class_1972.field_22076.method_29177(), new ColormapProperties.ColumnBounds(54, 1));
        map.put(class_1972.field_23859.method_29177(), new ColormapProperties.ColumnBounds(55, 1));
        map.put(class_1972.field_9411.method_29177(), new ColormapProperties.ColumnBounds(56, 1));
        map.put(class_1972.field_9442.method_29177(), new ColormapProperties.ColumnBounds(57, 1));
        map.put(class_1972.field_9447.method_29177(), new ColormapProperties.ColumnBounds(58, 1));
        map.put(class_1972.field_9457.method_29177(), new ColormapProperties.ColumnBounds(59, 1));
        map.put(class_1972.field_9465.method_29177(), new ColormapProperties.ColumnBounds(60, 1));
        map.put(class_1972.field_38748.method_29177(), new ColormapProperties.ColumnBounds(61, 1));
        map.put(class_1972.field_37543.method_29177(), new ColormapProperties.ColumnBounds(62, 1));
        return map;
    }

    static {
        legacyColumns = DefaultColumns.createLegacyColumnBounds();
        stableColumns = DefaultColumns.createStableColumnBounds();
        biomes = new Object2IntArrayMap();
        biomes.put((Object)"the_void", 0);
        biomes.put((Object)"plains", 1);
        biomes.put((Object)"sunflower_plains", 2);
        biomes.put((Object)"snowy_plains", 3);
        biomes.put((Object)"ice_spikes", 4);
        biomes.put((Object)"desert", 5);
        biomes.put((Object)"swamp", 6);
        biomes.put((Object)"mangrove_swamp", 7);
        biomes.put((Object)"forest", 8);
        biomes.put((Object)"flower_forest", 9);
        biomes.put((Object)"birch_forest", 10);
        biomes.put((Object)"dark_forest", 11);
        biomes.put((Object)"old_growth_birch_forest", 12);
        biomes.put((Object)"old_growth_pine_taiga", 13);
        biomes.put((Object)"old_growth_spruce_taiga", 14);
        biomes.put((Object)"taiga", 15);
        biomes.put((Object)"snowy_taiga", 16);
        biomes.put((Object)"savanna", 17);
        biomes.put((Object)"savanna_plateau", 18);
        biomes.put((Object)"windswept_hills", 19);
        biomes.put((Object)"windswept_gravelly_hills", 20);
        biomes.put((Object)"windswept_forest", 21);
        biomes.put((Object)"windswept_savanna", 22);
        biomes.put((Object)"jungle", 23);
        biomes.put((Object)"sparse_jungle", 24);
        biomes.put((Object)"bamboo_jungle", 25);
        biomes.put((Object)"badlands", 26);
        biomes.put((Object)"eroded_badlands", 27);
        biomes.put((Object)"wooded_badlands", 28);
        biomes.put((Object)"meadow", 29);
        biomes.put((Object)"grove", 30);
        biomes.put((Object)"snowy_slopes", 31);
        biomes.put((Object)"frozen_peaks", 32);
        biomes.put((Object)"jagged_peaks", 33);
        biomes.put((Object)"stony_peaks", 34);
        biomes.put((Object)"river", 35);
        biomes.put((Object)"frozen_river", 36);
        biomes.put((Object)"beach", 37);
        biomes.put((Object)"snowy_beach", 38);
        biomes.put((Object)"stony_shore", 39);
        biomes.put((Object)"warm_ocean", 40);
        biomes.put((Object)"lukewarm_ocean", 41);
        biomes.put((Object)"deep_lukewarm_ocean", 42);
        biomes.put((Object)"ocean", 43);
        biomes.put((Object)"deep_ocean", 44);
        biomes.put((Object)"cold_ocean", 45);
        biomes.put((Object)"deep_cold_ocean", 46);
        biomes.put((Object)"frozen_ocean", 47);
        biomes.put((Object)"deep_frozen_ocean", 48);
        biomes.put((Object)"mushroom_fields", 49);
        biomes.put((Object)"dripstone_caves", 50);
        biomes.put((Object)"lush_caves", 51);
        biomes.put((Object)"deep_dark", 52);
        biomes.put((Object)"nether_wastes", 53);
        biomes.put((Object)"warped_forest", 54);
        biomes.put((Object)"crimson_forest", 55);
        biomes.put((Object)"soul_sand_valley", 56);
        biomes.put((Object)"basalt_deltas", 57);
        biomes.put((Object)"the_end", 58);
        biomes.put((Object)"end_highlands", 59);
        biomes.put((Object)"end_midlands", 60);
        biomes.put((Object)"small_end_islands", 61);
        biomes.put((Object)"end_barrens", 62);
    }
}

