/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.properties;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import io.github.kvverti.colormatic.properties.ApplicableBlockStates;
import io.github.kvverti.colormatic.properties.ColormapProperties;
import io.github.kvverti.colormatic.properties.GridEntry;
import io.github.kvverti.colormatic.properties.HexColor;
import io.github.kvverti.colormatic.properties.InvalidColormapException;
import io.github.kvverti.colormatic.properties.PropertyImage;
import io.github.kvverti.colormatic.properties.adapter.ApplicableBlockStatesAdapter;
import io.github.kvverti.colormatic.properties.adapter.ChatFormatAdapter;
import io.github.kvverti.colormatic.properties.adapter.GridEntryAdapter;
import io.github.kvverti.colormatic.properties.adapter.HexColorAdapter;
import io.github.kvverti.colormatic.properties.adapter.IdentifierAdapter;
import io.github.kvverti.colormatic.properties.adapter.MaterialColorAdapter;
import io.github.kvverti.colormatic.properties.adapter.StringIdentifiableTypeAdapterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3620;

public class PropertyUtil {
    public static final Gson PROPERTY_GSON = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new StringIdentifiableTypeAdapterFactory()).registerTypeAdapter(class_2960.class, (Object)new IdentifierAdapter()).registerTypeAdapter(ApplicableBlockStates.class, (Object)new ApplicableBlockStatesAdapter()).registerTypeAdapter(HexColor.class, (Object)new HexColorAdapter()).registerTypeAdapter(class_3620.class, (Object)new MaterialColorAdapter()).registerTypeAdapter(class_124.class, (Object)new ChatFormatAdapter()).registerTypeAdapter(GridEntry.class, (Object)new GridEntryAdapter()).create();

    public static String resolve(String path, class_2960 id) {
        if (((String)path).startsWith("./")) {
            String thisPath = id.toString();
            path = thisPath.substring(0, thisPath.lastIndexOf(47)) + ((String)path).substring(1);
        } else if (((String)path).startsWith("~/")) {
            path = "optifine" + ((String)path).substring(1);
        } else if (!((String)path).contains("/") && !((String)path).contains(":")) {
            String thisPath = id.toString();
            path = thisPath.substring(0, thisPath.lastIndexOf(47) + 1) + (String)path;
        }
        return path;
    }

    public static Reader getJsonReader(InputStream in, class_2960 id, Function<String, String> keyMapper, Predicate<String> arrayValue) throws IOException {
        Reader jsonInput;
        if (id.method_12832().endsWith(".properties")) {
            Properties data = new Properties();
            data.load(in);
            jsonInput = new StringReader(PropertyUtil.toJson(data, keyMapper, arrayValue));
        } else {
            jsonInput = new InputStreamReader(in);
        }
        return jsonInput;
    }

    private static String toJson(Properties properties, Function<String, String> keyMapper, Predicate<String> arrayValue) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String prop : properties.stringPropertyNames()) {
            String key;
            int i;
            String[] keys = prop.split("\\.");
            Map<String, HashMap<String, Object>> nest = props;
            for (i = 0; i < keys.length - 1; ++i) {
                key = keyMapper.apply(keys[i]);
                Object tmp = nest.computeIfAbsent(key, k -> new HashMap());
                if (tmp instanceof Map) {
                    nest = (Map)tmp;
                    continue;
                }
                HashMap<String, Object> newNest = new HashMap<String, Object>();
                newNest.put("", tmp);
                nest.put(key, newNest);
                nest = newNest;
            }
            key = keyMapper.apply(keys[i]);
            String[] propVal = properties.getProperty(prop);
            String[] val = arrayValue.test(key) ? propVal.split("\\s+") : propVal;
            nest.merge(key, (HashMap<String, Object>)val, (BiFunction<HashMap<String, Object>, HashMap<String, Object>, HashMap<String, Object>>)((BiFunction<Object, Object, Object>)PropertyUtil::mergeCompound));
        }
        return PROPERTY_GSON.toJson(props);
    }

    private static Object mergeCompound(Object existingValue, Object newValue) {
        if (existingValue instanceof Map) {
            Map map = (Map)existingValue;
            map.put("", newValue);
            return existingValue;
        }
        return newValue;
    }

    public static PropertyImage loadColormap(class_3300 manager, class_2960 id, boolean custom) {
        PropertyImage propertyImage;
        block13: {
            ColormapProperties props = ColormapProperties.load(manager, id, custom);
            if (props.getFormat() == ColormapProperties.Format.FIXED) {
                return new PropertyImage(props, null);
            }
            InputStream in = manager.getResourceOrThrow(props.getSource()).method_14482();
            try {
                class_1011 image = class_1011.method_4309((InputStream)in);
                if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                    for (int x = 0; x < image.method_4307(); ++x) {
                        for (int y = 0; y < image.method_4323(); ++y) {
                            int pix = image.method_4315(x, y);
                            int tmp = (pix & 0xFF0000) >> 16;
                            tmp |= (pix & 0xFF) << 16;
                            pix &= 0xFF00FF00;
                            image.method_4305(x, y, pix |= tmp);
                        }
                    }
                }
                if (props.getFormat() == ColormapProperties.Format.VANILLA && (image.method_4307() != 256 || image.method_4323() != 256)) {
                    throw new InvalidColormapException("Vanilla colormap dimensions must be 256x256");
                }
                propertyImage = new PropertyImage(props, image);
                if (in == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InvalidColormapException(e);
                }
            }
            in.close();
        }
        return propertyImage;
    }
}

