/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.properties.adapter;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.github.kvverti.colormatic.properties.HexColor;
import java.io.IOException;

public class HexColorAdapter
extends TypeAdapter<HexColor> {
    public HexColor read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            throw new JsonSyntaxException((Throwable)new NullPointerException("Required nonnull"));
        }
        String s = in.nextString().trim();
        try {
            return new HexColor(Integer.parseInt(s, 16));
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    public void write(JsonWriter out, HexColor value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            out.value(Integer.toHexString(value.rgb()));
        }
    }
}

