/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.resource;

import io.github.kvverti.colormatic.colormap.BiomeColormap;
import io.github.kvverti.colormatic.colormap.BiomeColormaps;
import io.github.kvverti.colormatic.properties.InvalidColormapException;
import io.github.kvverti.colormatic.properties.PropertyImage;
import io.github.kvverti.colormatic.properties.PropertyUtil;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomBiomeColormapsResource
implements SimpleSynchronousResourceReloadListener {
    private static final Logger log = LogManager.getLogger((String)"colormatic");
    private static final Pattern ID_PATTERN = Pattern.compile("[a-z0-9_/.-]+");
    private final class_2960 id = new class_2960("colormatic", "colormap/custom");
    private final class_2960 optifineId = new class_2960("minecraft", "optifine/colormap/custom");
    private final class_2960 otherOptifineId = new class_2960("minecraft", "optifine/colormap/blocks");

    public class_2960 getFabricId() {
        return this.id;
    }

    public void method_14491(class_3300 manager) {
        BiomeColormaps.reset();
        CustomBiomeColormapsResource.addColormaps(manager, this.otherOptifineId, false);
        CustomBiomeColormapsResource.addColormaps(manager, this.optifineId, false);
        CustomBiomeColormapsResource.addColormaps(manager, this.id, true);
    }

    private static void addColormaps(class_3300 manager, class_2960 dir, boolean json) {
        String ext = json ? ".json" : ".properties";
        Collection files = manager.method_14488(dir.method_12832(), id -> id.method_12836().equals(dir.method_12836()) && (id.method_12832().endsWith(ext) || id.method_12832().endsWith(".png"))).keySet().stream().map(id -> {
            String path = id.method_12832();
            if (path.endsWith(".png")) {
                String newPath = path.substring(0, path.length() - 4) + ext;
                return new class_2960(id.method_12836(), newPath);
            }
            return id;
        }).distinct().collect(Collectors.toList());
        for (class_2960 id2 : files) {
            if (!ID_PATTERN.matcher(id2.method_12832()).matches()) {
                log.error("Colormap definition file '{}' does not name a valid resource location. Please contact resource pack author to fix.", (Object)id2);
            }
            try {
                PropertyImage pi = PropertyUtil.loadColormap(manager, id2, true);
                BiomeColormap colormap = new BiomeColormap(pi.properties(), pi.image());
                BiomeColormaps.add(colormap);
            }
            catch (InvalidColormapException e) {
                log.error("Error parsing {}: {}", (Object)id2, (Object)e.getMessage());
            }
        }
    }
}

