/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.resource;

import io.github.kvverti.colormatic.Lightmaps;
import io.github.kvverti.colormatic.colormap.Lightmap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LightmapsResource
implements SimpleResourceReloadListener<Map<class_2960, class_1011>> {
    private static final Logger logger = LogManager.getLogger();
    private final class_2960 id;
    private final class_2960 optifineId;

    public LightmapsResource(class_2960 id) {
        this.id = id;
        this.optifineId = new class_2960("minecraft", "optifine/" + id.method_12832());
    }

    public class_2960 getFabricId() {
        return this.id;
    }

    public CompletableFuture<Map<class_2960, class_1011>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            Map<class_2960, class_1011> lightmaps = LightmapsResource.getLightmaps(manager, this.optifineId);
            lightmaps.putAll(LightmapsResource.getLightmaps(manager, this.id));
            return lightmaps;
        }, executor);
    }

    private static Map<class_2960, class_1011> getLightmaps(class_3300 manager, class_2960 dir) {
        Map files = manager.method_14488(dir.method_12832(), s -> s.method_12832().endsWith(".png") && s.method_12836().equals(dir.method_12836()));
        HashMap<class_2960, class_1011> res = new HashMap<class_2960, class_1011>(files.size());
        for (Map.Entry entry : files.entrySet()) {
            class_2960 id = (class_2960)entry.getKey();
            try {
                InputStream in = ((class_3298)entry.getValue()).method_14482();
                try {
                    int dirStrLen = dir.toString().length();
                    String thisStr = id.toString();
                    String dimIdStr = thisStr.substring(dirStrLen + 1, thisStr.length() - 4).replaceFirst("/", ":");
                    class_2960 dimId = class_2960.method_12829((String)LightmapsResource.fixOptifineDimId(dimIdStr));
                    if (dimId != null) {
                        res.put(dimId, class_1011.method_4309((InputStream)in));
                        continue;
                    }
                    logger.error("Invalid lightmap dimension ID: " + thisStr);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error("Could not read lightmap file " + id, (Throwable)e);
            }
        }
        return res;
    }

    private static String fixOptifineDimId(String dimIdStr) {
        return switch (dimIdStr) {
            case "world0" -> "minecraft:overworld";
            case "world1" -> "minecraft:the_end";
            case "world-1" -> "minecraft:the_nether";
            default -> dimIdStr;
        };
    }

    public CompletableFuture<Void> apply(Map<class_2960, class_1011> lightmapData, class_3300 resourceManager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            Lightmaps.clearLightmaps();
            for (Map.Entry entry : lightmapData.entrySet()) {
                class_1011 img = (class_1011)entry.getValue();
                if (img.method_4307() < 2 || img.method_4323() != 32 && img.method_4323() != 64) {
                    logger.warn("Lightmap image dimensions must be nX32 or nX64: " + this.id);
                    continue;
                }
                Lightmaps.addLightmap((class_2960)entry.getKey(), new Lightmap(img));
            }
        }, executor);
    }
}

