/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.config;

import chrono.mods.compassribbon.config.value.AbstractValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager<T> {
    private final Class<T> configClass;
    private final File file;
    private final Gson gson;
    private final Logger logger;
    private T config;

    public ConfigManager(String modId, Class<T> configClass, Logger logger) {
        this.configClass = configClass;
        this.file = FabricLoader.getInstance().getConfigDir().resolve(modId + ".json").toFile();
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.logger = logger;
    }

    public ConfigManager(String modId, Class<T> configClass, String loggerName) {
        this(modId, configClass, LoggerFactory.getLogger((String)loggerName));
    }

    public ConfigManager(String modId, Class<T> configClass) {
        this(modId, configClass, "CrConfig");
    }

    private T getDefaultConfig() {
        try {
            return this.configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to create default config", e);
        }
    }

    private Stream<Field> getFields() {
        return Stream.of(this.configClass.getDeclaredFields()).filter(field -> AbstractValue.class.isAssignableFrom(field.getType()));
    }

    @Nullable
    private AbstractValue<?, ?> getFieldValue(Field field, T config) {
        field.setAccessible(true);
        try {
            return (AbstractValue)field.get(config);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.logger.error("Unable to get configuration field '{}'", (Object)field.getName());
            return null;
        }
    }

    private boolean migrateConfig(T config, boolean isDefault) {
        try {
            Method method = config.getClass().getDeclaredMethod("migrate", Boolean.TYPE);
            try {
                return (Boolean)method.invoke(config, isDefault);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.logger.warn("Unable to migrate config", (Throwable)e);
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return false;
    }

    private void setFieldValueFromJson(Field field, JsonElement json, T config) {
        field.setAccessible(true);
        try {
            ((AbstractValue)field.get(config)).fromJson(json);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.logger.error("Unable to set configuration field '{}'", (Object)field.getName());
        }
    }

    private String toJson() {
        JsonObject root = new JsonObject();
        this.getFields().forEach(field -> {
            AbstractValue<?, ?> value = this.getFieldValue((Field)field, this.config);
            if (value != null && (value.getSaveDefaultValue() || !value.isDefaultValue())) {
                JsonElement element = value.toJson();
                root.add(field.getName(), element);
            }
        });
        return this.gson.toJson((JsonElement)root);
    }

    private T fromJson(JsonElement json) {
        T config = this.getDefaultConfig();
        if (json != null && json.isJsonObject()) {
            JsonObject root = json.getAsJsonObject();
            this.getFields().forEach(field -> {
                JsonElement element = root.get(field.getName());
                if (element != null) {
                    this.setFieldValueFromJson((Field)field, element, config);
                }
            });
        }
        return config;
    }

    private void load() {
        JsonElement json = null;
        try {
            json = JsonParser.parseReader((Reader)new BufferedReader(new FileReader(this.file)));
        }
        catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
            this.logger.warn("Couldn't load configuration file");
        }
        this.config = this.fromJson(json);
        if (this.migrateConfig(this.config, json == null) || json == null) {
            this.save();
        }
    }

    public void save() {
        try (FileWriter fileWriter = new FileWriter(this.file);){
            fileWriter.write(this.toJson());
        }
        catch (IOException e) {
            this.logger.error("Couldn't save configuration file", (Throwable)e);
        }
    }

    public T getConfig() {
        if (this.config == null) {
            this.load();
        }
        return this.config;
    }

    public boolean isDefault() {
        return this.getFields().map(field -> this.getFieldValue((Field)field, this.config)).filter(Objects::nonNull).allMatch(value -> value.isDefaultValue());
    }
}

