/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.config.gui.widget;

import chrono.mods.compassribbon.config.gui.widget.ResetableWidget;
import chrono.mods.compassribbon.config.gui.widget.WidgetBuilder;
import chrono.mods.compassribbon.config.value.NumericValue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_8015;

public class NumericWidgetBuilder
extends WidgetBuilder<NumericWidgetBuilder> {
    public static final int DEFAULT_HEIGHT = 20;
    private final double min;
    private final double max;
    private final double step;
    private final Supplier<Double> getter;
    private final Consumer<Double> setter;
    private Runnable resetAction;

    protected NumericWidgetBuilder(String key, double min, double max, double step, Supplier<Double> getter, Consumer<Double> setter, Supplier<class_2561> messageProvider) {
        super(key, messageProvider);
        this.max = max;
        this.min = min;
        this.step = step;
        this.getter = getter;
        this.setter = setter;
    }

    public static NumericWidgetBuilder of(String key, double min, double max, double step, Supplier<Double> getter, Consumer<Double> setter, Supplier<class_2561> messageProvider) {
        return new NumericWidgetBuilder(key, min, max, step, getter, setter, messageProvider);
    }

    public static NumericWidgetBuilder of(String key, NumericValue<?, ?> value) {
        return NumericWidgetBuilder.of(key, ((Number)value.getMinValue()).doubleValue(), ((Number)value.getMaxValue()).doubleValue(), ((Number)value.getStep()).doubleValue(), () -> ((Number)value.getValue()).doubleValue(), val -> value.fromDouble((double)val), () -> NumericWidgetBuilder.translateValue(key, value)).resetAction(() -> value.resetValue());
    }

    public NumericWidgetBuilder resetAction(Runnable resetAction) {
        this.resetAction = resetAction;
        return this.getThis();
    }

    private double adjustValue(double value) {
        if (this.step > 0.0) {
            value = this.step * (double)Math.round(value / this.step);
        }
        return class_3532.method_15350((double)value, (double)this.min, (double)this.max);
    }

    private double getRatio(double value) {
        return class_3532.method_15350((double)((this.adjustValue(value) - this.min) / (this.max - this.min)), (double)0.0, (double)1.0);
    }

    private double getValue(double ratio) {
        return this.adjustValue(class_3532.method_16436((double)class_3532.method_15350((double)ratio, (double)0.0, (double)1.0), (double)this.min, (double)this.max));
    }

    private static class_2561 translateValue(String key, NumericValue<?, ?> value) {
        String limitKey;
        String string = value.isMinValue() ? ".min" : (limitKey = value.isMaxValue() ? ".max" : null);
        if (limitKey != null && class_2477.method_10517().method_4678((String)key + limitKey)) {
            key = (String)key + limitKey;
        }
        return class_2561.method_43469((String)key, (Object[])new Object[]{value.getValue()});
    }

    @Override
    public class_339 build(int x, int y, int width, int height) {
        return new Widget(x, y, width, height);
    }

    @Override
    NumericWidgetBuilder getThis() {
        return this;
    }

    private final class Widget
    extends class_357
    implements ResetableWidget {
        private boolean canChangeValue;

        private Widget(int x, int y, int width, int height) {
            super(x, y, width, height, (class_2561)NumericWidgetBuilder.this.messageProvider.get(), 0.0);
            this.method_47400(NumericWidgetBuilder.this.tooltip);
            this.method_47402(NumericWidgetBuilder.this.tooltipDelay);
            this.field_22763 = NumericWidgetBuilder.this.active;
            this.field_22753 = NumericWidgetBuilder.this.getRatio(NumericWidgetBuilder.this.getter.get());
        }

        protected void method_25344() {
            NumericWidgetBuilder.this.setter.accept(NumericWidgetBuilder.this.getValue(this.field_22753));
        }

        public boolean method_25404(int key, int scanCode, int modifiers) {
            double newValue;
            if (key == 32 || key == 257 || key == 335) {
                boolean bl = this.canChangeValue = !this.canChangeValue;
            }
            if (!this.canChangeValue || NumericWidgetBuilder.this.step <= 0.0 || key != 263 && key != 262) {
                return super.method_25404(key, scanCode, modifiers);
            }
            double amount = NumericWidgetBuilder.this.step;
            if (key == 263) {
                amount = -amount;
            }
            if ((newValue = NumericWidgetBuilder.this.getRatio(NumericWidgetBuilder.this.getValue(this.field_22753) + amount)) != this.field_22753) {
                this.field_22753 = newValue;
                this.method_25344();
                this.method_25346();
            }
            return true;
        }

        @Override
        public void onReset() {
            if (NumericWidgetBuilder.this.resetAction != null) {
                NumericWidgetBuilder.this.resetAction.run();
                this.field_22753 = NumericWidgetBuilder.this.getRatio(NumericWidgetBuilder.this.getter.get());
                this.method_25346();
            }
        }

        public void method_25365(boolean focused) {
            super.method_25365(focused);
            if (!focused) {
                this.canChangeValue = false;
            } else {
                class_8015 inputType = class_310.method_1551().method_48186();
                if (inputType == class_8015.field_41778 || inputType == class_8015.field_41780) {
                    this.canChangeValue = true;
                }
            }
        }

        protected void method_25346() {
            this.method_25355((class_2561)NumericWidgetBuilder.this.messageProvider.get());
        }
    }
}

