/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.gui;

import chrono.mods.compassribbon.compat.Charm;
import chrono.mods.compassribbon.config.CompassRibbonConfig;
import chrono.mods.compassribbon.helpers.GameRendererAccessor;
import chrono.mods.compassribbon.helpers.InventoryUtils;
import chrono.mods.compassribbon.helpers.MapInfo;
import chrono.mods.compassribbon.helpers.MapMarker;
import chrono.mods.compassribbon.helpers.RibbonMapMarker;
import chrono.mods.compassribbon.network.ClientNetworkHandler;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1800;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5272;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class CompassRibbonOverlay {
    private static final class_2960 MAP_ICONS_TEXTURE = new class_2960("minecraft", "textures/map/map_icons.png");
    private static final int RIBBON_HEIGHT = 10;
    private static final int FOV_HIGHLIGHT_LINE2_GAP = 3;
    private static final double FOV_HIGHLIGHT_WIDTH_FOR_DYNAMIC_RANGE = 0.5;
    private static final int MAP_MARKER_DISTANCE_MAX_DISTANCE_FROM_CENTER = 4;
    private static final long MAP_MARKER_DISTANCE_FADE_TIME = 250L;
    private final class_310 minecraft;
    private final CompassRibbonConfig config;
    private final List<class_2561> directions;
    private class_327 font;
    private class_746 player;
    private int windowWidth;
    private int windowHeight;
    private int windowCenterX;
    private double guiScale;
    private double ribbonRange;
    private int ribbonWidth;
    private int ribbonYOffset;
    private int fovHighlightWidth;
    private static RibbonMapMarker visibleMarker;
    private static double visibleMarkerDx;
    private static long visibleMarkerTime;

    public CompassRibbonOverlay(class_310 minecraft, CompassRibbonConfig config) {
        this.minecraft = minecraft;
        this.config = config;
        this.directions = Arrays.asList("S", "SW", "W", "NW", "N", "NE", "E", "SE").stream().map(direction -> class_2561.method_43471((String)("text.cr-compass-ribbon.direction." + direction))).collect(Collectors.toList());
    }

    public void render(class_4587 pose, float partialTick) {
        boolean showDirections;
        if (this.minecraft.field_1690.field_1866) {
            return;
        }
        if (!InventoryUtils.containsItem(this.minecraft.field_1724.method_31548(), ((CompassRibbonConfig.CompassSlot)((Object)this.config.directionsCompassSlot.getValue())).getSlot(), class_1802.field_8251)) {
            return;
        }
        this.font = this.minecraft.field_1705.method_1756();
        this.player = this.minecraft.field_1724;
        boolean showMapMarkers = !this.config.mapMarkersOpacity.isTransparent();
        boolean bl = showDirections = !this.config.directionsOpacity.isTransparent();
        if (showDirections && this.player.field_6002.method_27983() == class_1937.field_25180) {
            if (this.config.directionsInNether.getValue() == CompassRibbonConfig.DirectionsVisibility.HIDDEN) {
                showDirections = false;
            }
        } else if (showDirections && this.player.field_6002.method_27983() == class_1937.field_25181 && this.config.directionsInEnd.getValue() == CompassRibbonConfig.DirectionsVisibility.HIDDEN) {
            showDirections = false;
        }
        if (!showDirections && !showMapMarkers) {
            return;
        }
        this.windowWidth = this.minecraft.method_22683().method_4486();
        this.windowHeight = this.minecraft.method_22683().method_4502();
        this.windowCenterX = this.windowWidth / 2;
        this.guiScale = this.minecraft.method_22683().method_4495();
        this.ribbonYOffset = (Integer)this.config.ribbonYOffset.getValue() + 2;
        this.ribbonWidth = this.windowWidth * (Integer)this.config.ribbonWidth.getValue() / 100;
        double windowAspectRatio = (double)this.windowWidth / (double)this.windowHeight;
        double verticalFov = ((GameRendererAccessor)this.minecraft.field_1773).cr$getFov(partialTick);
        double horizontalFov = Math.atan(Math.tan(verticalFov / 360.0 * Math.PI) * windowAspectRatio) / Math.PI * 360.0;
        this.ribbonRange = this.config.ribbonRange.isMinValue() ? horizontalFov / 0.5 : (double)((Integer)this.config.ribbonRange.getValue()).intValue();
        this.fovHighlightWidth = (int)(Math.min(1.0, horizontalFov / this.ribbonRange) * (double)this.ribbonWidth);
        this.renderCenterMark(pose);
        if (!this.config.fovHighlightOpacity.isTransparent()) {
            this.renderFovHighlight(pose);
        }
        if (showDirections) {
            this.renderDirections(pose);
        }
        if (showMapMarkers) {
            this.renderMarkers(pose);
            this.renderMarkerDescription(pose);
        }
    }

    private List<Integer> getMapIds(class_1799 stack) {
        if (stack.method_7909() == class_1802.field_8204) {
            return List.of(class_1806.method_8003((class_1799)stack));
        }
        if (stack.method_7909() == Charm.getItem()) {
            return Charm.getMapIds(stack, (CompassRibbonConfig.MapMarkerCharmAtlasCompat)((Object)this.config.mapMarkerCharmAtlasCompat.getValue()));
        }
        return List.of();
    }

    private List<RibbonMapMarker> getMarkersInRange() {
        if (this.config.mapMarkersOpacity.isTransparent()) {
            return Lists.newArrayList();
        }
        class_5321 playerDimension = this.player.field_6002.method_27983();
        HashSet<RibbonMapMarker> ribbonMarkers = new HashSet<RibbonMapMarker>();
        HashSet<class_1792> items = new HashSet<class_1792>();
        items.add(class_1802.field_8204);
        if (this.config.mapMarkerCharmAtlasCompat.getValue() != CompassRibbonConfig.MapMarkerCharmAtlasCompat.OFF && Charm.isPresent()) {
            items.add(Charm.getItem());
        }
        List<class_1799> stacks = InventoryUtils.findItems(this.minecraft.field_1724.method_31548(), ((CompassRibbonConfig.MapSlot)((Object)this.config.mapMarkersMapSlot.getValue())).getSlot(), items);
        for (class_1799 stack : stacks) {
            for (int mapId : this.getMapIds(stack)) {
                MapInfo mapInfo = ClientNetworkHandler.getMapInfo(mapId);
                if (mapInfo == null || !mapInfo.getDimension().equals((Object)playerDimension.method_29177())) continue;
                double maxDistance = mapInfo.getMaxDistance();
                for (MapMarker marker : mapInfo.getMarkers(this.player.method_19538())) {
                    if (!((Boolean)this.config.mapMarkersShowFrame.getValue()).booleanValue() && marker.getType() == class_20.class_21.field_95) continue;
                    ribbonMarkers.add(new RibbonMapMarker((class_1657)this.player, marker, maxDistance));
                }
            }
        }
        double minimalDistance = ClientNetworkHandler.recentChange() ? 0.0 : (double)((Integer)this.config.mapMarkersMinimalDistance.getValue()).intValue();
        double maxYawDifference = this.ribbonRange / 2.0;
        return ribbonMarkers.stream().filter(ribbonMarker -> Math.abs(ribbonMarker.getYaw()) <= maxYawDifference && ribbonMarker.getDistance() >= minimalDistance).sorted(Comparator.comparingDouble(RibbonMapMarker::getDistance).reversed()).collect(Collectors.toList());
    }

    private double getRibbonAngle() {
        if (this.player.field_6002.method_27983() == class_1937.field_25180 && this.config.directionsInNether.getValue() == CompassRibbonConfig.DirectionsVisibility.RANDOM || this.player.field_6002.method_27983() == class_1937.field_25181 && this.config.directionsInEnd.getValue() == CompassRibbonConfig.DirectionsVisibility.RANDOM) {
            class_1800 compass_angle = class_5272.method_27878((class_1792)class_1802.field_8251, (class_2960)new class_2960("angle"));
            return (double)compass_angle.call(class_1799.field_8037, null, (class_1309)this.player, 0) * 360.0 - 90.0;
        }
        return this.player.method_36454();
    }

    private void renderCenterMark(class_4587 pose) {
        int color;
        switch ((CompassRibbonConfig.FovHighlightShape)((Object)this.config.fovHighlightShape.getValue())) {
            case RECTANGLE: {
                int n = 0xFFFFFF + this.opacityToAlpha((Integer)this.config.directionsOpacity.getValue());
                break;
            }
            default: {
                int n = color = ((CompassRibbonConfig.FovHighlightColor)((Object)this.config.fovHighlightColor.getValue())).getColor() + this.opacityToAlpha((Integer)this.config.fovHighlightOpacity.getValue());
            }
        }
        if (this.config.fovHighlightShape.getValue() == CompassRibbonConfig.FovHighlightShape.RECTANGLE) {
            class_332.method_25294((class_4587)pose, (int)this.windowCenterX, (int)(this.ribbonYOffset - 2), (int)(this.windowCenterX + 1), (int)this.ribbonYOffset, (int)color);
        }
        if (this.config.fovHighlightShape.getValue() == CompassRibbonConfig.FovHighlightShape.LINE2) {
            class_332.method_25294((class_4587)pose, (int)this.windowCenterX, (int)(this.ribbonYOffset + 10 - 1), (int)(this.windowCenterX + 1), (int)(this.ribbonYOffset + 10 + 1), (int)color);
        } else {
            class_332.method_25294((class_4587)pose, (int)this.windowCenterX, (int)(this.ribbonYOffset + 10), (int)(this.windowCenterX + 1), (int)(this.ribbonYOffset + 10 + 2), (int)color);
        }
    }

    private void renderDirections(class_4587 pose) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        double ribbonAngle = this.getRibbonAngle();
        double ribbonStartAngle = ribbonAngle - this.ribbonRange / 2.0;
        double ribbonEndAngle = ribbonStartAngle + this.ribbonRange;
        for (double angle = (double)class_3532.method_15384((double)(ribbonStartAngle / 45.0)) * 45.0; angle <= ribbonEndAngle; angle += 45.0) {
            int direction = class_3532.method_15384((double)((angle - 22.5) / 45.0)) & 7;
            double position = class_3532.method_15338((double)(angle - ribbonAngle)) / this.ribbonRange;
            int color = direction % 2 == 0 ? ((CompassRibbonConfig.DirectionsColor)((Object)this.config.directionsColor.getValue())).getColor1() : ((CompassRibbonConfig.DirectionsColor)((Object)this.config.directionsColor.getValue())).getColor2();
            int opacity = (int)((float)((Integer)this.config.directionsOpacity.getValue()).intValue() * this.positionToAlpha((float)position));
            if (opacity <= 3) continue;
            class_2561 label = this.directions.get(direction);
            double x = (double)this.windowCenterX + position * (double)this.ribbonWidth - (double)this.font.method_27525((class_5348)label) / 2.0;
            int y = this.ribbonYOffset + 10 - 8;
            this.font.method_30883(pose, label, (float)this.alignToGuiScale(x), (float)y, color + this.opacityToAlpha(opacity));
        }
        RenderSystem.disableBlend();
    }

    private void renderFovHighlight(class_4587 pose) {
        int halfWidth = this.fovHighlightWidth / 2;
        int color = ((CompassRibbonConfig.FovHighlightColor)((Object)this.config.fovHighlightColor.getValue())).getColor() + this.opacityToAlpha((Integer)this.config.fovHighlightOpacity.getValue());
        if (this.config.fovHighlightShape.getValue() == CompassRibbonConfig.FovHighlightShape.RECTANGLE) {
            class_332.method_25294((class_4587)pose, (int)(this.windowCenterX - halfWidth), (int)this.ribbonYOffset, (int)(this.windowCenterX + halfWidth + 1), (int)(this.ribbonYOffset + 10), (int)color);
        } else if (this.config.fovHighlightShape.getValue() == CompassRibbonConfig.FovHighlightShape.LINE1) {
            class_332.method_25294((class_4587)pose, (int)(this.windowCenterX - halfWidth), (int)(this.ribbonYOffset + 10 - 1), (int)(this.windowCenterX + halfWidth + 1), (int)(this.ribbonYOffset + 10), (int)color);
        } else if (this.config.fovHighlightShape.getValue() == CompassRibbonConfig.FovHighlightShape.LINE2 && halfWidth > 3) {
            class_332.method_25294((class_4587)pose, (int)(this.windowCenterX - halfWidth), (int)(this.ribbonYOffset + 10 - 1), (int)(this.windowCenterX - 3), (int)(this.ribbonYOffset + 10), (int)color);
            class_332.method_25294((class_4587)pose, (int)(this.windowCenterX + 3 + 1), (int)(this.ribbonYOffset + 10 - 1), (int)(this.windowCenterX + halfWidth + 1), (int)(this.ribbonYOffset + 10), (int)color);
        }
    }

    private void renderMarkers(class_4587 pose) {
        List<RibbonMapMarker> markers = this.getMarkersInRange();
        if (markers.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        RenderSystem.enableScissor((int)0, (int)(this.minecraft.method_22683().method_4507() - (int)((double)(this.ribbonYOffset + 10) * this.guiScale)), (int)this.minecraft.method_22683().method_4480(), (int)((int)(10.0 * this.guiScale)));
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)MAP_ICONS_TEXTURE);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        boolean showMarkerDescription = !this.config.mapMarkerDescriptionOpacity.isTransparent();
        long now = class_156.method_658();
        int z = 1;
        for (RibbonMapMarker marker : markers) {
            double markerPosition = marker.getYaw() / this.ribbonRange;
            double dx = markerPosition * (double)this.ribbonWidth;
            double x = (double)this.windowCenterX + dx;
            double y = (double)this.ribbonYOffset + Math.max(marker.getPitch() / 15.0, -3.0);
            int opacity = (int)((float)((Integer)this.config.mapMarkersOpacity.getValue()).intValue() * this.positionToAlpha((float)markerPosition) * this.distanceToAlpha((float)marker.getDistance()) * 255.0f / 100.0f);
            this.renderMarker(pose, bufferBuilder, x, y, z++, marker, opacity);
            if (!showMarkerDescription) continue;
            if (Math.abs(dx) <= 4.0) {
                if (visibleMarker != null && !marker.equals(visibleMarker) && !(Math.abs(dx) <= Math.abs(visibleMarkerDx))) continue;
                visibleMarker = marker;
                visibleMarkerDx = dx;
                visibleMarkerTime = now;
                continue;
            }
            if (!marker.equals(visibleMarker)) continue;
            visibleMarkerDx = dx;
        }
        tessellator.method_1350();
        RenderSystem.disableScissor();
        RenderSystem.disableBlend();
    }

    private void renderMarker(class_4587 pose, class_287 bufferBuilder, double x, double y, int z, RibbonMapMarker marker, int opacity) {
        if (opacity == 0) {
            return;
        }
        int texturePos = marker.getTexturePos();
        float u1 = (float)(texturePos % 16 + 0) / 16.0f;
        float u2 = (float)(texturePos % 16 + 1) / 16.0f;
        float v1 = (float)(texturePos / 16 + 0) / 16.0f;
        float v2 = (float)(texturePos / 16 + 1) / 16.0f;
        pose.method_22903();
        pose.method_22904(this.alignToGuiScale(x + 0.5), this.alignToGuiScale(y + 4.5), -0.02 - 0.001 * (double)z);
        pose.method_22905(4.0f, 4.0f, 3.0f);
        Matrix4f matrix = pose.method_23760().method_23761();
        pose.method_22909();
        bufferBuilder.method_22918(matrix, -1.0f, 1.0f, 0.0f).method_22913(u1, v2).method_1336(255, 255, 255, opacity).method_1344();
        bufferBuilder.method_22918(matrix, 1.0f, 1.0f, 0.0f).method_22913(u2, v2).method_1336(255, 255, 255, opacity).method_1344();
        bufferBuilder.method_22918(matrix, 1.0f, -1.0f, 0.0f).method_22913(u2, v1).method_1336(255, 255, 255, opacity).method_1344();
        bufferBuilder.method_22918(matrix, -1.0f, -1.0f, 0.0f).method_22913(u1, v1).method_1336(255, 255, 255, opacity).method_1344();
    }

    private void renderMarkerDescription(class_4587 pose) {
        if (visibleMarker == null) {
            return;
        }
        long now = class_156.method_658();
        if (visibleMarkerTime + 250L < now) {
            visibleMarker = null;
            return;
        }
        int opacity = (int)Math.round(class_3532.method_16436((double)((double)(now - visibleMarkerTime) / 250.0), (double)1.0, (double)0.0) * (double)((Integer)this.config.mapMarkerDescriptionOpacity.getValue()).intValue());
        if (opacity <= 3) {
            return;
        }
        String name = visibleMarker.getName();
        CompassRibbonConfig.MapMarkerDescriptionStyle style = (CompassRibbonConfig.MapMarkerDescriptionStyle)((Object)this.config.mapMarkerDescriptionStyle.getValue());
        if (!style.showDistance() && name.isEmpty()) {
            return;
        }
        if (name.isEmpty() && style.showName()) {
            style = CompassRibbonConfig.MapMarkerDescriptionStyle.DISTANCE;
        }
        class_5250 label = class_2561.method_43469((String)("text.cr-compass-ribbon.mapMarkerDescription." + this.config.mapMarkerDescriptionStyle.getName(style)), (Object[])new Object[]{name, (int)Math.round(visibleMarker.getDistance())});
        double labelWidth = this.font.method_27525((class_5348)label);
        double x = Math.max(0.0, Math.min((double)this.windowWidth - labelWidth, (double)this.windowCenterX + visibleMarkerDx - labelWidth / 2.0));
        int y = this.ribbonYOffset + 10 + 2;
        this.font.method_30883(pose, (class_2561)label, (float)this.alignToGuiScale(x), (float)y, ((CompassRibbonConfig.FovHighlightColor)((Object)this.config.mapMarkerDescriptionColor.getValue())).getColor() + this.opacityToAlpha(opacity));
    }

    private double alignToGuiScale(double value) {
        if (this.guiScale == 1.0) {
            return Math.round(value);
        }
        return (double)Math.round(value * this.guiScale) / this.guiScale;
    }

    private float distanceToAlpha(float distance) {
        return (1.0f - Math.min(1.0f, distance / 256.0f)) * 0.5f + 0.5f;
    }

    private int opacityToAlpha(int opacity) {
        return opacity * 255 / 100 << 24;
    }

    private float positionToAlpha(float position) {
        return Math.min(1.0f, 3.0f - class_3532.method_15379((float)position) * 6.0f);
    }
}

