/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.helpers;

import chrono.mods.compassribbon.helpers.MapMarker;
import chrono.mods.compassribbon.mixin.server.MapItemSavedDataAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_17;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_19;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class MapInfo {
    private final int mapId;
    private final class_2960 dimension;
    private final int x;
    private final int z;
    private final byte scale;
    private final boolean trackingPosition;
    private final boolean unlimitedTracking;
    private final List<MapMarker> markers;
    private static final boolean SORT_MARKERS = true;

    public MapInfo(int mapId, class_2960 dimension, int x, int z, byte scale, boolean trackingPosition, boolean unlimitedTracking, List<MapMarker> markers) {
        this.mapId = mapId;
        this.dimension = dimension;
        this.x = x;
        this.z = z;
        this.scale = scale;
        this.trackingPosition = trackingPosition;
        this.unlimitedTracking = unlimitedTracking;
        this.markers = markers;
    }

    @Nullable
    public static MapInfo fromItemStack(class_1799 stack, class_1937 world) {
        Integer mapId = class_1806.method_8003((class_1799)stack);
        class_22 mapData = class_1806.method_7997((Integer)mapId, (class_1937)world);
        if (mapData == null) {
            return null;
        }
        ArrayList<MapMarker> markers = new ArrayList<MapMarker>();
        for (class_17 bannerMarker : ((MapItemSavedDataAccessor)mapData).cr$getBannerMarkers().values()) {
            class_2561 name = bannerMarker.method_68();
            markers.add(new MapMarker(bannerMarker.method_70(), bannerMarker.method_72(), name != null ? name.getString() : ""));
        }
        for (class_19 frameMarker : ((MapItemSavedDataAccessor)mapData).cr$getFrameMarkers().values()) {
            markers.add(new MapMarker(frameMarker.method_86(), class_20.class_21.field_95));
        }
        class_2487 stackTag = stack.method_7969();
        if (stackTag != null && stackTag.method_10573("Decorations", 9)) {
            class_2499 decorationsTag = stackTag.method_10554("Decorations", 10);
            for (int i = 0; i < decorationsTag.size(); ++i) {
                class_2487 decorationTag = decorationsTag.method_10602(i);
                markers.add(new MapMarker((int)decorationTag.method_10574("x"), 64, (int)decorationTag.method_10574("z"), class_20.class_21.method_99((byte)decorationTag.method_10571("type"))));
            }
        }
        Collections.sort(markers);
        return new MapInfo(class_1806.method_8003((class_1799)stack), mapData.field_118.method_29177(), mapData.field_116, mapData.field_115, mapData.field_119, ((MapItemSavedDataAccessor)mapData).cr$getTrackingPosition(), ((MapItemSavedDataAccessor)mapData).cr$getUnlimitedTracking(), markers);
    }

    public class_2960 getDimension() {
        return this.dimension;
    }

    public int getMapId() {
        return this.mapId;
    }

    public List<MapMarker> getMarkers(class_243 pos) {
        ArrayList<MapMarker> markers = new ArrayList<MapMarker>();
        if (this.markers.size() > 0 && this.trackingPosition) {
            double maxDistance = this.getMaxDistance();
            double mapCenterDistance = Math.max(Math.abs(pos.method_10216() - (double)this.x), Math.abs(pos.method_10215() - (double)this.z));
            if (maxDistance == 0.0 || maxDistance >= mapCenterDistance) {
                for (MapMarker marker : this.markers) {
                    markers.add(marker);
                }
            }
        }
        return markers;
    }

    public double getMaxDistance() {
        return this.unlimitedTracking ? 0.0 : (double)(320 << this.scale);
    }

    public static MapInfo load(class_2487 tag) {
        ArrayList<MapMarker> markers = new ArrayList<MapMarker>();
        class_2499 markersTag = tag.method_10554("markers", 10);
        for (int i = 0; i < markersTag.size(); ++i) {
            markers.add(MapMarker.load(markersTag.method_10602(i)));
        }
        int x = tag.method_10573("xCenter", 99) ? tag.method_10550("xCenter") : tag.method_10550("x");
        int z = tag.method_10573("zCenter", 99) ? tag.method_10550("zCenter") : tag.method_10550("z");
        return new MapInfo(tag.method_10550("mapId"), new class_2960(tag.method_10558("dimension")), x, z, tag.method_10571("scale"), tag.method_10577("trackingPosition"), tag.method_10577("unlimitedTracking"), markers);
    }

    public class_2487 save(class_2487 tag) {
        tag.method_10569("mapId", this.mapId);
        tag.method_10582("dimension", this.dimension.toString());
        tag.method_10569("xCenter", this.x);
        tag.method_10569("zCenter", this.z);
        tag.method_10567("scale", this.scale);
        tag.method_10556("trackingPosition", this.trackingPosition);
        tag.method_10556("unlimitedTracking", this.unlimitedTracking);
        class_2499 markersTag = new class_2499();
        for (MapMarker marker : this.markers) {
            markersTag.add((Object)marker.save());
        }
        tag.method_10566("markers", (class_2520)markersTag);
        return tag;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MapInfo other = (MapInfo)object;
        return this.mapId == other.mapId && this.dimension == other.dimension && this.x == other.x && this.z == other.z && this.scale == other.scale && this.trackingPosition == other.trackingPosition && this.unlimitedTracking == other.unlimitedTracking && this.markers.equals(other.markers);
    }

    public int hashCode() {
        return Objects.hash(this.mapId, this.dimension, this.x, this.z, this.scale, this.trackingPosition, this.unlimitedTracking, this.markers);
    }

    public String toString() {
        return "mapId: " + this.mapId + ", center: " + this.x + "/" + this.z + ", scale: 1/" + (1 << this.scale) + ", " + this.markers.size() + " marker(s): " + this.markers;
    }
}

