/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.helpers;

import chrono.mods.compassribbon.helpers.MapMarker;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_20;
import net.minecraft.class_3532;

public class RibbonMapMarker {
    private static final double RAD_TO_DEG = 57.29577951308232;
    private final int x;
    private final int y;
    private final int z;
    private final class_20.class_21 type;
    private final String name;
    private final double distance;
    private final double pitch;
    private final double yaw;
    private final double maxDistance;

    public RibbonMapMarker(class_1657 player, int x, int y, int z, class_20.class_21 type, String name, double maxDistance) {
        double rx = (double)x + 0.5 - player.method_23317();
        double ry = (double)y + 0.5 - player.method_23320();
        double rz = (double)z + 0.5 - player.method_23321();
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
        this.name = name;
        this.distance = Math.sqrt(rx * rx + rz * rz);
        this.pitch = -class_3532.method_15349((double)ry, (double)Math.max(this.distance, 8.0)) * 57.29577951308232;
        this.yaw = class_3532.method_15338((double)(-(class_3532.method_15349((double)rx, (double)rz) * 57.29577951308232 + (double)player.method_36454())));
        this.maxDistance = maxDistance;
    }

    public RibbonMapMarker(class_1657 player, MapMarker mapMarker, double maxDistance) {
        this(player, mapMarker.getX(), mapMarker.getY(), mapMarker.getZ(), mapMarker.getType(), mapMarker.getName(), maxDistance);
    }

    public int getTexturePos() {
        return this.type.method_98();
    }

    public String getName() {
        return this.name;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getYaw() {
        return this.yaw;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RibbonMapMarker)) {
            return false;
        }
        RibbonMapMarker other = (RibbonMapMarker)object;
        return this.x == other.x && this.y == other.y && this.z == other.z && this.getTexturePos() == other.getTexturePos() && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.getTexturePos(), this.name);
    }

    public String toString() {
        return "RibbonMarker: " + this.distance + "/" + this.maxDistance + ", " + this.pitch + ", " + this.yaw + ", " + this.type + ", " + this.name;
    }
}

