/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import java.awt.geom.Point2D;
import java.util.List;
import java.util.Objects;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.RenderWrapper;
import journeymap.client.texture.Texture;
import journeymap.client.ui.GuiHooks;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.theme.Theme;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class DrawUtil {
    public static double zLevel = 0.0;

    public static void drawCenteredLabel(class_4587 poseStack, String text, double x, double y, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale) {
        DrawUtil.drawLabel(poseStack, text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, true, 0.0);
    }

    public static void drawCenteredLabel(class_4587 poseStack, String text, double x, double y, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawLabel(poseStack, text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    public static void drawCenteredLabel(class_4587 poseStack, String text, double x, double y, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, double rotation) {
        DrawUtil.drawLabel(poseStack, text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, false, rotation);
    }

    public static void drawLabel(class_4587 poseStack, String text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawLabel(poseStack, text, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    public static void drawLabels(class_4587 poseStack, class_4597 buffers, String[] lines, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        if (lines.length == 0) {
            return;
        }
        if (lines.length == 1) {
            DrawUtil.drawBatchLabel(poseStack, (class_2561)class_2561.method_43470((String)lines[0]), buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, rotation);
            return;
        }
        class_327 fontRenderer = class_310.method_1551().field_1772;
        double vpad = fontRenderer.method_1726() ? 0.0 : (fontShadow ? 6.0 : 4.0);
        Objects.requireNonNull(fontRenderer);
        double lineHeight = 9.0 * fontScale;
        double bgHeight = lineHeight * (double)lines.length + vpad;
        double bgWidth = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            for (String line : lines) {
                bgWidth = Math.max(bgWidth, (double)fontRenderer.method_1727(line) * fontScale);
            }
            if (bgWidth % 2.0 == 0.0) {
                bgWidth += 1.0;
            }
        }
        if (lines.length > 1) {
            switch (vAlign) {
                case Above: {
                    y -= lineHeight * (double)lines.length;
                    bgHeight += vpad / 2.0;
                    break;
                }
                case Middle: {
                    y -= bgHeight / 2.0;
                    break;
                }
            }
        }
        for (String line : lines) {
            DrawUtil.drawBatchLabel(poseStack, (class_2561)class_2561.method_43470((String)line), buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, rotation);
            bgColor = null;
            y += lineHeight;
        }
    }

    public static void drawLabel(class_4587 poseStack, String text, Theme.LabelSpec labelSpec, double x, double y, HAlign hAlign, VAlign vAlign, double fontScale, double rotation) {
        DrawUtil.drawLabel(poseStack, text, x, y, hAlign, vAlign, labelSpec.background.getColor(), labelSpec.background.alpha, labelSpec.foreground.getColor(), labelSpec.foreground.alpha, fontScale, labelSpec.shadow, rotation);
    }

    public static void drawLabel(class_4587 poseStack, String text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double bgWidth = 0.0;
        double bgHeight = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            class_327 fontRenderer = class_310.method_1551().field_1772;
            bgWidth = fontRenderer.method_1727(text);
            bgHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        }
        DrawUtil.drawLabel(poseStack, text, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, rotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLabel(class_4587 poseStack, String text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, double bgWidth, double bgHeight, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        int height;
        if (text == null || text.length() == 0) {
            return;
        }
        class_327 fontRenderer = class_310.method_1551().field_1772;
        boolean drawRect = bgColor != null && bgAlpha > 0.0f;
        double width = fontRenderer.method_1727(text);
        if (drawRect) {
            v0 = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        } else {
            Objects.requireNonNull(fontRenderer);
            v0 = height = 9;
        }
        if (!drawRect && fontRenderer.method_1726()) {
            --height;
        }
        poseStack.method_22903();
        try {
            double d;
            if (fontScale != 1.0) {
                x /= fontScale;
                y /= fontScale;
                poseStack.method_22905((float)fontScale, (float)fontScale, 1.0f);
            }
            float textX = (float)x;
            float textY = (float)y;
            double rectX = x;
            double rectY = y;
            switch (hAlign) {
                case Left: {
                    textX = (float)(x - width);
                    rectX = textX;
                    break;
                }
                case Center: {
                    textX = (float)(x - width / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                    rectX = (float)(x - Math.max(1.0, bgWidth) / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                    break;
                }
                case Right: {
                    textX = (float)x;
                    rectX = (float)x;
                }
            }
            if (drawRect) {
                Objects.requireNonNull(fontRenderer);
                d = (double)(height - 9) / 2.0;
            } else {
                d = 0.0;
            }
            double vpad = d;
            switch (vAlign) {
                case Above: {
                    rectY = y - (double)height;
                    textY = (float)(rectY + vpad + (double)(!fontRenderer.method_1726() ? 1 : 0));
                    break;
                }
                case Middle: {
                    rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                    textY = (float)(rectY + vpad);
                    break;
                }
                case Below: {
                    rectY = y;
                    textY = (float)(rectY + vpad);
                }
            }
            if (rotation != 0.0) {
                poseStack.method_22904(x, y, 0.0);
                poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)(-rotation)));
                poseStack.method_22904(-x, -y, 0.0);
            }
            if (drawRect) {
                int hpad = 2;
                DrawUtil.drawRectangle(poseStack, rectX - 2.0 - 0.5, rectY, bgWidth + 4.0, bgHeight, bgColor, bgAlpha);
            }
            if (alpha < 1.0f) {
                color = RGB.toArbg(color, alpha);
            }
            poseStack.method_22904((double)textX - Math.floor(textX), (double)textY - Math.floor(textY), 0.0);
            if (fontShadow) {
                fontRenderer.method_1720(poseStack, text, textX, textY, color.intValue());
            } else {
                fontRenderer.method_1729(poseStack, text, textX, textY, color.intValue());
            }
        }
        finally {
            poseStack.method_22909();
        }
    }

    public static void drawBatchLabel(class_4587 poseStack, class_2561 text, class_4597 buffers, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawBatchLabel(poseStack, text, buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    public static void drawBatchLabel(class_4587 poseStack, class_2561 text, class_4597 buffers, Theme.LabelSpec labelSpec, double x, double y, HAlign hAlign, VAlign vAlign, double fontScale, double rotation) {
        DrawUtil.drawBatchLabel(poseStack, text, buffers, x, y, hAlign, vAlign, labelSpec.background.getColor(), labelSpec.background.alpha, labelSpec.foreground.getColor(), labelSpec.foreground.alpha, fontScale, labelSpec.shadow, rotation);
    }

    public static void drawBatchLabel(class_4587 poseStack, class_2561 text, class_4597 buffers, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double bgWidth = 0.0;
        double bgHeight = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            class_327 fontRenderer = class_310.method_1551().field_1772;
            bgWidth = fontRenderer.method_27525((class_5348)text);
            bgHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        }
        DrawUtil.drawBatchLabel(poseStack, text, buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, rotation);
    }

    private static void drawBatchLabel(class_4587 poseStack, class_2561 text, class_4597 buffers, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, double bgWidth, double bgHeight, int color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double d;
        int height;
        if (text == null || text.getString().length() == 0) {
            return;
        }
        class_327 fontRenderer = class_310.method_1551().field_1772;
        boolean drawRect = bgColor != null && bgAlpha > 0.0f;
        double width = fontRenderer.method_27525((class_5348)text);
        if (drawRect) {
            v0 = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        } else {
            Objects.requireNonNull(fontRenderer);
            v0 = height = 9;
        }
        if (!drawRect && fontRenderer.method_1726()) {
            --height;
        }
        poseStack.method_22903();
        if (fontScale != 1.0) {
            x /= fontScale;
            y /= fontScale;
            poseStack.method_22905((float)fontScale, (float)fontScale, 0.0f);
        }
        float textX = (float)x;
        float textY = (float)y;
        double rectX = x;
        double rectY = y;
        switch (hAlign) {
            case Left: {
                textX = (float)(x - width);
                rectX = textX;
                break;
            }
            case Center: {
                textX = (float)(x - width / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                rectX = (float)(x - Math.max(1.0, bgWidth) / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                break;
            }
            case Right: {
                textX = (float)x;
                rectX = (float)x;
            }
        }
        if (drawRect) {
            Objects.requireNonNull(fontRenderer);
            d = (double)(height - 9) / 2.0;
        } else {
            d = 0.0;
        }
        double vpad = d;
        switch (vAlign) {
            case Above: {
                rectY = y - (double)height;
                textY = (float)(rectY + vpad + (double)(!fontRenderer.method_1726() ? 1 : 0));
                break;
            }
            case Middle: {
                rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                textY = (float)(rectY + vpad);
                break;
            }
            case Below: {
                rectY = y;
                textY = (float)(rectY + vpad);
            }
        }
        if (rotation != 0.0) {
            poseStack.method_22904(x, y, 0.0);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)(-rotation)));
            poseStack.method_22904(-x, -y, 0.0);
        }
        Matrix4f matrixPos = poseStack.method_23760().method_23761();
        if (drawRect) {
            int backgroundColor = class_310.method_1551().field_1690.method_19345(bgAlpha);
            RenderWrapper.disableDepthTest();
            int hpad = 2;
            DrawUtil.drawRectangle(poseStack, rectX - 2.0 - 0.5, rectY, bgWidth + 4.0, bgHeight, bgColor, bgAlpha);
        }
        if (alpha < 0.0f) {
            color = RGB.toArbg(color, alpha);
        }
        poseStack.method_22904((double)textX - Math.floor(textX), (double)textY - Math.floor(textY), 0.0);
        fontRenderer.method_30882(text, textX, textY, color, fontShadow, matrixPos, buffers, class_327.class_6415.field_33994, 0, 0xF000F0);
        RenderWrapper.disableDepthTest();
        RenderWrapper.depthMask(false);
        poseStack.method_22909();
    }

    public static int getLabelHeight(class_327 fr, boolean fontShadow) {
        int vpad = fr.method_1726() ? 0 : (fontShadow ? 6 : 4);
        Objects.requireNonNull(fr);
        return 9 + vpad;
    }

    public static void drawImage(class_4587 poseStack, Texture texture, double x, double y, boolean flip, float scale, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, flip, rotation);
    }

    public static void drawImage(class_4587 poseStack, Texture texture, float alpha, double x, double y, boolean flip, float scale, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, 0xFFFFFF, alpha, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, false, rotation);
    }

    public static void drawClampedImage(class_4587 poseStack, Texture texture, double x, double y, float scale, double rotation) {
        DrawUtil.drawClampedImage(poseStack, texture, 0xFFFFFF, 1.0f, x, y, scale, rotation);
    }

    public static void drawClampedImage(class_4587 poseStack, Texture texture, int color, float alpha, double x, double y, float scale, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, color, alpha, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, false, rotation);
    }

    public static void drawColoredImage(class_4587 poseStack, Texture texture, int color, float alpha, double x, double y, float scale, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, color, alpha, x, y, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, false, rotation);
    }

    public static void drawColoredSprite(class_4587 poseStack, Texture texture, double displayWidth, double displayHeight, double spriteX, double spriteY, double spriteWidth, double spriteHeight, Integer color, float alpha, double x, double y, float scale, double rotation) {
        double texWidth = texture.getWidth();
        double texHeight = texture.getHeight();
        double minU = Math.max(0.0, spriteX / texWidth);
        double minV = Math.max(0.0, spriteY / texHeight);
        double maxU = Math.min(1.0, (spriteX + spriteWidth) / texWidth);
        double maxV = Math.min(1.0, (spriteY + spriteHeight) / texHeight);
        DrawUtil.drawQuad(poseStack, texture, color, alpha, x, y, displayWidth * (double)scale, displayHeight * (double)scale, minU, minV, maxU, maxV, rotation, false, true, 770, 771, false);
    }

    public static void drawColoredImage(class_4587 poseStack, Texture texture, int color, float alpha, double x, double y, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, color, alpha, x, y, texture.getWidth(), texture.getHeight(), false, rotation);
    }

    public static void drawWaypointIcon(class_4587 poseStack, Texture texture, float scale, int color, float alpha, double x, double y, double rotation) {
        if (scale > 1.0f) {
            texture = texture.getScaledImage(scale);
            scale = 1.0f;
        }
        double width = (float)texture.getWidth() * scale;
        double height = (float)texture.getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        DrawUtil.drawQuad(poseStack, texture, color, alpha, drawX, drawY, (float)texture.getWidth() * scale, (float)texture.getHeight() * scale, false, rotation);
    }

    public static void drawColoredImage(class_4587 poseStack, Texture texture, int color, float alpha, double x, double y, int width, int height, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, color, alpha, x, y, width, height, false, rotation);
    }

    public static void drawQuad(class_4587 poseStack, Texture texture, double x, double y, double width, double height, boolean flip, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, 0xFFFFFF, 1.0f, x, y, width, height, 0.0, 0.0, 1.0, 1.0, rotation, flip, true, 770, 771, false);
    }

    public static void drawQuad(class_4587 poseStack, Texture texture, int color, float alpha, double x, double y, double width, double height, boolean flip, double rotation) {
        DrawUtil.drawQuad(poseStack, texture, color, alpha, x, y, width, height, 0.0, 0.0, 1.0, 1.0, rotation, flip, true, 770, 771, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawQuad(class_4587 poseStack, Texture texture, int color, float alpha, double x, double y, double width, double height, double minU, double minV, double maxU, double maxV, double rotation, boolean flip, boolean blend, int glBlendSfactor, int glBlendDFactor, boolean clampTexture) {
        poseStack.method_22903();
        try {
            RenderWrapper.setShader(class_757::method_34542);
            RenderWrapper.activeTexture(33984);
            RenderWrapper.bindTexture(texture.getTextureId());
            RenderWrapper.setShaderTexture(0, texture.getTextureId());
            if (blend) {
                RenderWrapper.enableBlend();
                RenderWrapper.blendFuncSeparate(glBlendSfactor, glBlendDFactor, 1, 0);
            }
            RenderWrapper.enableTexture();
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            if (blend) {
                float[] c = RGB.floats(color);
                RenderWrapper.setColor4f(c[0], c[1], c[2], alpha);
            } else {
                RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, alpha);
            }
            RenderWrapper.texParameter(3553, 10241, 9729);
            RenderWrapper.texParameter(3553, 10240, 9729);
            int texEdgeBehavior = clampTexture ? 33071 : 10497;
            RenderWrapper.texParameter(3553, 10242, texEdgeBehavior);
            RenderWrapper.texParameter(3553, 10243, texEdgeBehavior);
            if (rotation != 0.0) {
                double transX = x + width / 2.0;
                double transY = y + height / 2.0;
                poseStack.method_22904(transX, transY, 0.0);
                poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)rotation));
                poseStack.method_22904(-transX, -transY, 0.0);
            }
            double direction = flip ? -maxU : maxU;
            RenderWrapper.disableTexture();
            RenderWrapper.enableBlend();
            RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            DrawUtil.addVertexWithUV(poseStack, buffer, x, height + y, zLevel, minU, maxV);
            DrawUtil.addVertexWithUV(poseStack, buffer, x + width, height + y, zLevel, direction, maxV);
            DrawUtil.addVertexWithUV(poseStack, buffer, x + width, y, zLevel, direction, minV);
            DrawUtil.addVertexWithUV(poseStack, buffer, x, y, zLevel, minU, minV);
            tessellator.method_1350();
            RenderWrapper.enableTexture();
            RenderWrapper.enableBlend();
            if (blend) {
                RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                if (glBlendSfactor != 770 || glBlendDFactor != 771) {
                    RenderWrapper.enableBlend();
                    RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
                }
            }
        }
        finally {
            poseStack.method_22909();
        }
    }

    public static void drawRectangle(class_4587 poseStack, double x, double y, double width, double height, int color, float alpha) {
        int[] rgba = RGB.ints(color, alpha);
        RenderWrapper.enableBlend();
        RenderWrapper.disableTexture();
        RenderWrapper.defaultBlendFunc();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderWrapper.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        DrawUtil.addVertex(poseStack.method_23760().method_23761(), bufferBuilder, x, height + y, zLevel, rgba);
        DrawUtil.addVertex(poseStack.method_23760().method_23761(), bufferBuilder, x + width, height + y, zLevel, rgba);
        DrawUtil.addVertex(poseStack.method_23760().method_23761(), bufferBuilder, x + width, y, zLevel, rgba);
        DrawUtil.addVertex(poseStack.method_23760().method_23761(), bufferBuilder, x, y, zLevel, rgba);
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderWrapper.disableBlend();
        RenderWrapper.enableTexture();
    }

    public static void drawPolygon(class_4587 poseStack, double xOffset, double yOffset, List<Point2D.Double> fillPoints, List<List<Point2D.Double>> strokePoints, ShapeProperties shapeProperties, int zoom) {
        float[] rgba;
        RenderWrapper.enableBlend();
        RenderWrapper.disableTexture();
        RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
        if (shapeProperties.getFillOpacity() >= 0.01f) {
            rgba = RGB.floats(shapeProperties.getFillColor(), shapeProperties.getFillOpacity() + 0.4f);
            RenderWrapper.setColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            int lastIndex = fillPoints.size() - 1;
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            RenderWrapper.disableTexture();
            RenderWrapper.disableCull();
            RenderWrapper.setShader(class_757::method_34540);
            buffer.method_1328(class_293.class_5596.field_27379, class_290.field_1576);
            for (int i = 0; i <= lastIndex; ++i) {
                Point2D.Double point = fillPoints.get(i);
                DrawUtil.addVertex(poseStack.method_23760().method_23761(), buffer, point.getX() + xOffset, point.getY() + yOffset, zLevel, rgba);
            }
            tessellator.method_1350();
            RenderWrapper.enableCull();
            RenderWrapper.enableTexture();
        }
        if (shapeProperties.getStrokeOpacity() >= 0.01f && shapeProperties.getStrokeWidth() > 0.0f) {
            rgba = RGB.floats(shapeProperties.getStrokeColor(), shapeProperties.getStrokeOpacity() + 0.4f);
            RenderWrapper.setColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            float halfWidth = shapeProperties.getStrokeWidth() / 2.0f;
            for (List<Point2D.Double> screenPoints : strokePoints) {
                if (screenPoints.size() < 3) continue;
                int lastIndex = screenPoints.size() - 1;
                RenderWrapper.disableTexture();
                RenderWrapper.disableCull();
                RenderWrapper.setShader(class_757::method_34540);
                class_289 tesselator = class_289.method_1348();
                class_287 buffer = tesselator.method_1349();
                buffer.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
                for (int i = 0; i <= lastIndex + 1; ++i) {
                    int iPoint = i <= lastIndex ? i : 0;
                    int iPrev = iPoint > 0 ? iPoint - 1 : lastIndex;
                    int iNext = iPoint < lastIndex ? iPoint + 1 : 0;
                    Point2D.Double point = screenPoints.get(iPoint);
                    Point2D.Double prev = screenPoints.get(iPrev);
                    Point2D.Double next = screenPoints.get(iNext);
                    Point2D.Double normal = DrawUtil.calculateNormal(prev, point, next);
                    DrawUtil.addVertex(poseStack.method_23760().method_23761(), buffer, point.getX() + normal.getX() * (double)halfWidth + xOffset, point.getY() + normal.getY() * (double)halfWidth + yOffset, zLevel, rgba);
                    DrawUtil.addVertex(poseStack.method_23760().method_23761(), buffer, point.getX() - normal.getX() * (double)halfWidth + xOffset, point.getY() - normal.getY() * (double)halfWidth + yOffset, zLevel, rgba);
                }
                tesselator.method_1350();
            }
            RenderWrapper.enableCull();
            RenderWrapper.enableTexture();
        }
        RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderWrapper.enableTexture();
        RenderWrapper.disableBlend();
    }

    private static Point2D.Double calculateNormal(Point2D.Double prev, Point2D.Double point, Point2D.Double next) {
        class_241 edgeNormal2;
        class_241 edge1 = new class_241((float)(point.x - prev.x), (float)(point.y - prev.y));
        class_241 edge2 = new class_241((float)(next.x - point.x), (float)(next.y - point.y));
        class_241 edgeNormal1 = new class_241(-edge1.field_1342, edge1.field_1343).method_35581();
        class_241 vertexNormal = edgeNormal1.method_35586(edgeNormal2 = new class_241(-edge2.field_1342, edge2.field_1343).method_35581()).method_35581();
        double angle = Math.acos(vertexNormal.method_35583(edgeNormal1));
        double factor = Math.cos(angle);
        if (factor < 0.1) {
            factor = 0.1;
        }
        factor = 1.0 / factor;
        return new Point2D.Double((double)vertexNormal.field_1343 * factor, (double)vertexNormal.field_1342 * factor);
    }

    private static Point2D.Double calculateLineVector(Point2D.Double value, double xOffset, double yOffset) {
        double locX = value.x + xOffset;
        double locY = value.y + yOffset;
        boolean minimapDrawing = UIManager.INSTANCE.getMiniMap().isDrawing() && UIManager.INSTANCE.isMiniMapEnabled();
        double screenVecX = minimapDrawing ? UIManager.INSTANCE.getMiniMap().getDisplayVars().centerPoint.x : locX;
        double screenVecY = minimapDrawing ? UIManager.INSTANCE.getMiniMap().getDisplayVars().centerPoint.y : locY;
        return new Point2D.Double(screenVecX * 1.004, screenVecY * 1.004);
    }

    public static void drawGradientRect(class_4587 poseStack, double x, double y, double width, double height, int startColor, float startAlpha, int endColor, float endAlpha) {
        if (startAlpha > 1.0f) {
            startAlpha /= 255.0f;
        }
        if (endAlpha > 1.0f) {
            endAlpha /= 255.0f;
        }
        int[] rgbaStart = RGB.ints(startColor, startAlpha);
        int[] rgbaEnd = RGB.ints(endColor, endAlpha);
        RenderWrapper.disableTexture();
        RenderWrapper.enableBlend();
        RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
        RenderWrapper.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        DrawUtil.addVertexUV(poseStack, buffer, x, height + y, zLevel, 0.0, 1.0, rgbaEnd);
        DrawUtil.addVertexUV(poseStack, buffer, x + width, height + y, zLevel, 1.0, 1.0, rgbaEnd);
        DrawUtil.addVertexUV(poseStack, buffer, x + width, y, zLevel, 1.0, 0.0, rgbaStart);
        DrawUtil.addVertexUV(poseStack, buffer, x, y, zLevel, 0.0, 0.0, rgbaStart);
        tessellator.method_1350();
        RenderWrapper.enableTexture();
        RenderWrapper.enableBlend();
    }

    public static void drawBoundTexture(class_4587 poseStack, double startU, double startV, double startX, double startY, double z, double endU, double endV, double endX, double endY) {
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        DrawUtil.addVertexWithUV(poseStack, bufferBuilder, startX, endY, z, startU, endV);
        DrawUtil.addVertexWithUV(poseStack, bufferBuilder, endX, endY, z, endU, endV);
        DrawUtil.addVertexWithUV(poseStack, bufferBuilder, endX, startY, z, endU, startV);
        DrawUtil.addVertexWithUV(poseStack, bufferBuilder, startX, startY, z, startU, startV);
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public static void drawEntity(class_4587 poseStack, double x, double y, double heading, Texture texture, float scale, double rotation) {
        DrawUtil.drawEntity(poseStack, x, y, heading, texture, 1.0f, scale, rotation);
    }

    public static void drawEntity(class_4587 poseStack, double x, double y, double heading, Texture texture, float alpha, float scale, double rotation) {
        double width = (float)texture.getWidth() * scale;
        double height = (float)texture.getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        DrawUtil.drawImage(poseStack, texture, alpha, drawX, drawY, false, scale, heading);
    }

    public static void drawColoredEntity(class_4587 poseStack, double x, double y, Texture texture, int color, float alpha, float scale, double rotation) {
        double width = (float)texture.getWidth() * scale;
        double height = (float)texture.getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        DrawUtil.drawColoredImage(poseStack, texture, color, alpha, drawX, drawY, scale, rotation);
    }

    public static void sizeDisplay(class_4587 poseStack, double width, double height) {
        if (width > 0.0 && height > 0.0) {
            RenderWrapper.clear(256);
            Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)width, (float)height, 0.0f, 100.0f, GuiHooks.getGuiFarPlane());
            RenderWrapper.setProjectionMatrix(matrix4f);
            class_4587 posestack = RenderWrapper.getModelViewStack();
            posestack.method_34426();
            posestack.method_22904(0.0, 0.0, (double)(1000.0f - GuiHooks.getGuiFarPlane()));
        }
    }

    public static void addVertexWithUV(class_4587 poseStack, class_287 buff, float x, float y, float z, float u, float v) {
        class_4587.class_4665 entry = poseStack.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        buff.method_22918(matrix4f, x, y, z).method_22913(u, v).method_1344();
    }

    public static void addVertexWithUV(class_4587 poseStack, class_287 buff, double x, double y, double z, double u, double v) {
        DrawUtil.addVertexWithUV(poseStack, buff, (float)x, (float)y, (float)z, (float)u, (float)v);
    }

    public static void addVertexUV(class_4587 poseStack, class_287 buff, double x, double y, double z, double u, double v, int[] rgba) {
        class_4587.class_4665 entry = poseStack.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        buff.method_22918(matrix4f, (float)x, (float)y, (float)z).method_1336(rgba[0], rgba[1], rgba[2], rgba[3]).method_22913((float)u, (float)v).method_1344();
    }

    private static void addVertex(Matrix4f mat, class_287 buff, double x, double y, double z, int[] rgba) {
        buff.method_22918(mat, (float)x, (float)y, (float)z).method_1336(rgba[0], rgba[1], rgba[2], rgba[3]).method_1344();
    }

    private static void addVertex(Matrix4f mat, class_287 buff, double x, double y, double z, float[] rgba) {
        buff.method_22918(mat, (float)x, (float)y, (float)z).method_22915(rgba[0], rgba[1], rgba[2], rgba[3]).method_1344();
    }

    private static void addVertexNormal(Matrix4f mat, class_287 buff, double x, double y, double z, float pX, float pY, float pZ, float[] rgba) {
        buff.method_22918(mat, (float)x, (float)y, (float)z).method_22915(rgba[0], rgba[1], rgba[2], rgba[3]).method_22914(pX, pY, pZ).method_1344();
    }

    private static void addVertexNormal3f(Matrix4f mat, Matrix3f normal, class_287 buff, double x, double y, double z, float pX, float pY, float pZ, float[] rgba) {
        buff.method_22918(mat, (float)x, (float)y, (float)z).method_22915(rgba[0], rgba[1], rgba[2], rgba[3]).method_23763(normal, pX, pY, pZ).method_1344();
    }

    public static enum HAlign {
        Left,
        Center,
        Right;

    }

    public static enum VAlign {
        Above,
        Middle,
        Below;

    }
}

