/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.data.WorldData;
import journeymap.client.log.JMLogger;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.SimpleTextureImpl;
import journeymap.client.texture.Texture;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.OnOffButton;
import journeymap.client.ui.component.ScrollPane;
import journeymap.client.ui.component.TextBox;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.waypoint.WaypointManager;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1297;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.logging.log4j.util.Strings;

public class WaypointEditor
extends JmUI {
    private final Texture wpTexture;
    private final Texture colorPickTexture;
    private final Waypoint originalWaypoint;
    private final boolean isNew;
    String labelName = Constants.getString("jm.waypoint.name");
    String locationTitle = Constants.getString("jm.waypoint.location");
    String colorTitle = Constants.getString("jm.waypoint.color");
    String dimensionsTitle = Constants.getString("jm.waypoint.dimensions");
    String labelX = Constants.getString("jm.waypoint.x");
    String labelY = Constants.getString("jm.waypoint.y");
    String labelZ = Constants.getString("jm.waypoint.z");
    String labelR = Constants.getString("jm.waypoint.red_abbreviated");
    String labelG = Constants.getString("jm.waypoint.green_abbreviated");
    String labelB = Constants.getString("jm.waypoint.blue_abbreviated");
    String currentLocation = "";
    LocationFormat.LocationFormatKeys locationFormatKeys;
    private Button buttonRandomize;
    private OnOffButton buttonEnable;
    private Button buttonRemove;
    private Button buttonReset;
    private Button buttonSave;
    private Button buttonClose;
    private TextBox fieldName;
    private TextBox fieldR;
    private TextBox fieldG;
    private TextBox fieldB;
    private TextBox fieldX;
    private TextBox fieldY;
    private TextBox fieldZ;
    private ArrayList<TextBox> fieldList = new ArrayList();
    private ArrayList<DimensionButton> dimButtonList = new ArrayList();
    private ScrollPane dimScrollPane;
    private Integer currentColor;
    private Rectangle2D.Double colorPickRect;
    private String colorPickTooltip;
    private Waypoint editedWaypoint;
    private ButtonList bottomButtons;
    private float partialTicks;
    private boolean openedWithHotKey = true;
    private final int bottomY = -100;

    public WaypointEditor(Waypoint waypoint, boolean isNew, JmUI returnDisplay) {
        super(Constants.getString(isNew ? "jm.waypoint.new_title" : "jm.waypoint.edit_title"), returnDisplay);
        String tooltip;
        this.originalWaypoint = waypoint;
        this.editedWaypoint = new Waypoint(this.originalWaypoint);
        this.isNew = isNew;
        this.wpTexture = waypoint.getTexture();
        this.colorPickTooltip = tooltip = Constants.birthdayMessage();
        this.colorPickTexture = tooltip == null ? TextureCache.getTexture(TextureCache.ColorPicker) : TextureCache.getTexture(TextureCache.ColorPicker2);
        try {
            this.colorPickRect = new Rectangle2D.Double(0.0, 0.0, this.colorPickTexture.getWidth(), this.colorPickTexture.getHeight());
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during WaypointEditor ctor: " + LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
        if (returnDisplay != null && !(returnDisplay instanceof Fullscreen)) {
            this.openedWithHotKey = false;
        }
    }

    @Override
    public void method_25426() {
        try {
            this.setRenderBottomBar(true);
            FullMapProperties fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
            LocationFormat locationFormat = new LocationFormat();
            this.locationFormatKeys = locationFormat.getFormatKeys(fullMapProperties.locationFormat.get());
            String pos = this.locationFormatKeys.format(fullMapProperties.locationFormatVerbose.get(), class_3532.method_15357((double)this.field_22787.field_1724.method_23317()), class_3532.method_15357((double)this.field_22787.field_1724.method_23321()), class_3532.method_15357((double)this.field_22787.field_1724.method_5829().field_1322), class_3532.method_15375((float)(this.field_22787.field_1724.method_31478() >> 4)));
            this.currentLocation = Constants.getString("jm.waypoint.current_location", " " + pos);
            if (this.fieldList.isEmpty()) {
                class_327 fr = this.getFontRenderer();
                this.fieldName = new TextBox(this.originalWaypoint.getName(), fr, 160, 20);
                if (this.isNew) {
                    this.fieldName.method_25365(true);
                    this.fieldName.method_1872();
                    this.fieldName.method_1884(0);
                }
                this.fieldList.add(this.fieldName);
                int width9chars = this.getFontRenderer().method_1727("-30000000") + 10;
                int width3chars = this.getFontRenderer().method_1727("255") + 10;
                int width4chars = this.getFontRenderer().method_1727("-255") + 10;
                int h = 20;
                this.fieldX = new TextBox(this.originalWaypoint.getX(), fr, width9chars, h, true, true);
                this.fieldX.setClamp(-30000000, 30000000);
                this.fieldList.add(this.fieldX);
                this.fieldZ = new TextBox(this.originalWaypoint.getZ(), fr, width9chars, h, true, true);
                this.fieldZ.setClamp(-30000000, 30000000);
                this.fieldList.add(this.fieldZ);
                int y = this.originalWaypoint.getY();
                this.fieldY = new TextBox(y, fr, width4chars, h, true, true);
                this.fieldY.setClamp(-99, this.field_22787.field_1687.method_31600() - 1);
                this.fieldY.setMinLength(1);
                this.fieldList.add(this.fieldY);
                this.fieldR = new TextBox("", fr, width3chars, h, true, false);
                this.fieldR.setClamp(0, 255);
                this.fieldR.method_1880(3);
                this.fieldList.add(this.fieldR);
                this.fieldG = new TextBox("", fr, width3chars, h, true, false);
                this.fieldG.setClamp(0, 255);
                this.fieldG.method_1880(3);
                this.fieldList.add(this.fieldG);
                this.fieldB = new TextBox("", fr, width3chars, h, true, false);
                this.fieldB.setClamp(0, 255);
                this.fieldB.method_1880(3);
                this.fieldList.add(this.fieldB);
                Collection<String> wpDims = this.originalWaypoint.getDimensions();
                for (WorldData.DimensionProvider provider : WorldData.getDimensionProviders(WaypointStore.INSTANCE.getLoadedDimensions())) {
                    String dimName = WorldData.getSafeDimensionName(provider);
                    String dimId = provider.getDimensionId();
                    try {
                        dimName = provider.getName();
                    }
                    catch (Exception e) {
                        JMLogger.throwLogOnce("Can't get dimension name from provider: ", e);
                    }
                    DimensionButton button2 = new DimensionButton(dimId, dimName, wpDims.contains(dimId));
                    button2.setDefaultStyle(false);
                    this.dimButtonList.add(button2);
                }
                this.dimScrollPane = new ScrollPane(this, this.field_22787, 0, 0, this.dimButtonList, this.dimButtonList.get(0).method_25364(), 4);
                this.dimScrollPane.method_29344(false);
            }
            if (this.getRenderables().isEmpty()) {
                String on = Constants.getString("jm.common.on");
                String off = Constants.getString("jm.common.off");
                String enableOn = Constants.getString("jm.waypoint.enable", on);
                String enableOff = Constants.getString("jm.waypoint.enable", off);
                this.buttonRandomize = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.waypoint.randomize"), button -> this.setRandomColor()));
                this.buttonEnable = (OnOffButton)this.method_37063((class_364)new OnOffButton(enableOn, enableOff, true, button -> this.buttonEnable.toggle()));
                this.buttonEnable.setToggled(this.originalWaypoint.isEnable());
                this.buttonRemove = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.waypoint.remove"), button -> this.remove()));
                this.buttonRemove.setEnabled(!this.isNew);
                this.buttonReset = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.waypoint.reset"), button -> this.resetForm()));
                this.buttonSave = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.waypoint.save"), button -> this.save()));
                String closeLabel = this.isNew ? "jm.waypoint.cancel" : "jm.common.close";
                this.buttonClose = (Button)this.method_37063((class_364)new Button(Constants.getString(closeLabel), button -> this.refreshAndClose(this.originalWaypoint)));
                this.getRenderables().add((class_4068)this.buttonEnable);
                this.getRenderables().add((class_4068)this.buttonRandomize);
                this.getRenderables().add((class_4068)this.buttonRemove);
                this.getRenderables().add((class_4068)this.buttonReset);
                this.getRenderables().add((class_4068)this.buttonSave);
                this.getRenderables().add((class_4068)this.buttonClose);
                this.buttonEnable.setDefaultStyle(false);
                this.buttonRandomize.setDefaultStyle(false);
                this.buttonRemove.setDefaultStyle(false);
                this.buttonReset.setDefaultStyle(false);
                this.buttonSave.setDefaultStyle(false);
                this.buttonClose.setDefaultStyle(false);
                this.bottomButtons = new ButtonList(this.buttonRemove, this.buttonSave, this.buttonClose);
                this.bottomButtons.equalizeWidths(this.getFontRenderer());
                this.setFormColor(this.originalWaypoint.getIconColor());
                this.validate();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    @Override
    protected void layoutButtons(class_4587 poseStack) {
        try {
            this.method_25426();
            class_327 fr = this.getFontRenderer();
            int vpad = 5;
            int hgap = fr.method_1727("X") * 3;
            int vgap = this.fieldX.method_25364() + 5;
            int startY = Math.max(30, (this.field_22790 - 200) / 2);
            int dcw = fr.method_1727(this.dimensionsTitle);
            dcw = 8 + Math.max(dcw, this.dimScrollPane.getFitWidth(fr));
            int leftWidth = hgap * 2 + this.fieldX.method_25368() + this.fieldY.method_25368() + this.fieldZ.method_25368();
            int rightWidth = dcw;
            int totalWidth = leftWidth + 10 + rightWidth;
            int leftX = (this.field_22789 - totalWidth) / 2;
            int leftXEnd = leftX + leftWidth;
            int rightX = leftXEnd + 10;
            int rightXEnd = rightX + rightWidth;
            int leftRowY = startY;
            this.drawLabel(poseStack, this.labelName, leftX, leftRowY);
            this.fieldName.method_25358(leftWidth);
            this.fieldName.method_46421(leftX);
            this.fieldName.method_46419(leftRowY += 12);
            this.fieldName.method_25394(poseStack, leftX, leftRowY, this.partialTicks);
            this.drawLabel(poseStack, this.locationTitle, leftX, leftRowY += vgap + 5);
            this.drawLabelAndField(poseStack, this.labelX, this.fieldX, leftX, leftRowY += 12);
            this.drawLabelAndField(poseStack, this.labelZ, this.fieldZ, this.fieldX.method_46426() + this.fieldX.method_25368() + hgap, leftRowY);
            this.drawLabelAndField(poseStack, this.labelY, this.fieldY, this.fieldZ.method_46426() + this.fieldZ.method_25368() + hgap, leftRowY);
            this.drawLabel(poseStack, this.colorTitle, leftX, leftRowY += vgap + 5);
            this.drawLabelAndField(poseStack, this.labelR, this.fieldR, leftX, leftRowY += 12);
            this.drawLabelAndField(poseStack, this.labelG, this.fieldG, this.fieldR.method_46426() + this.fieldR.method_25368() + hgap, leftRowY);
            this.drawLabelAndField(poseStack, this.labelB, this.fieldB, this.fieldG.method_46426() + this.fieldG.method_25368() + hgap, leftRowY);
            this.buttonRandomize.method_25358(4 + Math.max(this.fieldB.method_46426() + this.fieldB.method_25368() - this.fieldR.method_46426(), 10 + fr.method_1727(this.buttonRandomize.method_25369().getString())));
            this.buttonRandomize.setScrollablePosition(this.fieldR.method_46426() - 2, leftRowY += vgap);
            int cpY = this.fieldB.method_46427();
            int cpSize = this.buttonRandomize.method_46427() + this.buttonRandomize.method_25364() - cpY - 2;
            int cpHAreaX = this.fieldB.method_46426() + this.fieldB.method_25368();
            int cpHArea = this.fieldName.method_46426() + this.fieldName.method_25368() - cpHAreaX;
            int cpX = cpHAreaX + (cpHArea - cpSize);
            this.drawColorPicker(poseStack, cpX, cpY, cpSize);
            int iconX = cpHAreaX + (cpX - cpHAreaX) / 2 - this.wpTexture.getWidth() / 2 + 1;
            int iconY = this.buttonRandomize.method_46427() - 2;
            this.drawWaypoint(poseStack, iconX, iconY);
            this.buttonEnable.fitWidth(fr);
            this.buttonEnable.method_25358(Math.max(leftWidth / 2, this.buttonEnable.method_25368()));
            this.buttonEnable.setScrollablePosition(leftX - 2, leftRowY += vgap);
            this.buttonReset.method_25358(leftWidth - this.buttonEnable.method_25368() - 2);
            this.buttonReset.setScrollablePosition(leftXEnd - this.buttonReset.method_25368() + 2, leftRowY);
            int rightRow = startY;
            this.drawLabel(poseStack, this.dimensionsTitle, rightX, rightRow);
            int scrollHeight = this.buttonReset.method_46427() + this.buttonReset.method_25364() - 2 - (rightRow += 12);
            this.dimScrollPane.setDimensions(dcw, scrollHeight, 0, 0, rightX, rightRow);
            int totalRow = Math.max(leftRowY + vgap, rightRow + vgap);
            this.bottomButtons.layoutFilledHorizontal(fr, leftX - 2, totalRow, rightXEnd + 2, 4, true);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during WaypointEditor layout: " + LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    @Override
    public void method_25394(class_4587 poseStack, int x, int y, float partialTicks) {
        try {
            this.partialTicks = partialTicks;
            super.method_25420(poseStack);
            super.renderBottomBar(poseStack);
            this.validate();
            this.layoutButtons(poseStack);
            this.dimScrollPane.method_25394(poseStack, x, y, partialTicks);
            DrawUtil.drawLabel(poseStack, this.currentLocation, this.field_22789 / 2, this.field_22790, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, 0, 1.0f, 0xC0C0C0, 1.0f, 1.0, true);
            for (int k = 0; k < this.getRenderables().size(); ++k) {
                class_4185 guibutton = (class_4185)this.getRenderables().get(k);
                guibutton.method_25394(poseStack, x, y, 0.0f);
            }
            if (this.colorPickTooltip != null && this.colorPickRect.contains(x, y)) {
                class_5250 tooltip = Constants.getStringTextComponent(this.colorPickTooltip);
                this.renderWrappedToolTip(poseStack, this.getFontRenderer().method_1728((class_5348)tooltip, 200), x, y, this.getFontRenderer());
            }
            this.drawTitle(poseStack);
            this.drawLogo(poseStack);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during WaypointEditor layout: " + LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    protected void drawWaypoint(class_4587 poseStack, int x, int y) {
        DrawUtil.drawColoredImage(poseStack, this.wpTexture, this.currentColor, 1.0f, x, y - this.wpTexture.getHeight() / 2, 0.0);
    }

    protected void drawColorPicker(class_4587 poseStack, int x, int y, float size) {
        int sizeI = (int)size;
        WaypointEditor.method_25294((class_4587)poseStack, (int)(x - 1), (int)(y - 1), (int)(x + sizeI + 1), (int)(y + sizeI + 1), (int)-6250336);
        float scale = size / (float)this.colorPickTexture.getWidth();
        if (this.colorPickRect.width != (double)size) {
            ((SimpleTextureImpl)this.colorPickTexture).resize(scale);
        }
        this.colorPickRect.setRect(x, y, size, size);
        DrawUtil.drawImage(poseStack, this.colorPickTexture, x, y, false, 1.0f, 0.0);
    }

    protected void drawLabelAndField(class_4587 poseStack, String label, TextBox field, int x, int y) {
        field.method_46421(x);
        field.method_46419(y);
        class_327 fr = this.getFontRenderer();
        int width = fr.method_1727(label) + 4;
        WaypointEditor.method_25303((class_4587)poseStack, (class_327)this.getFontRenderer(), (String)label, (int)(x - width), (int)(y + (field.method_25364() - 8) / 2), (int)Color.cyan.getRGB());
        field.method_25394(poseStack, x, y, this.partialTicks);
    }

    protected void drawLabel(class_4587 poseStack, String label, int x, int y) {
        WaypointEditor.method_25303((class_4587)poseStack, (class_327)this.getFontRenderer(), (String)label, (int)x, (int)y, (int)Color.cyan.getRGB());
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 256: {
                this.closeAndReturn();
                return true;
            }
            case 257: {
                this.save();
                return true;
            }
            case 258: {
                this.validate();
                this.onTab();
                return true;
            }
        }
        for (class_342 class_3422 : this.fieldList) {
            class_3422.method_25404(keyCode, scanCode, modifiers);
        }
        this.updateWaypointFromForm();
        this.validate();
        return true;
    }

    @Override
    public boolean method_25400(char typedChar, int keyCode) {
        if (this.openedWithHotKey && this.isNew) {
            this.openedWithHotKey = false;
            return true;
        }
        for (class_342 class_3422 : this.fieldList) {
            class_3422.method_25400(typedChar, keyCode);
        }
        this.updateWaypointFromForm();
        this.validate();
        return true;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        this.dimScrollPane.method_25406(mouseX, mouseY, mouseButton);
        for (class_342 class_3422 : this.fieldList) {
            class_3422.method_25406(mouseX, mouseY, mouseButton);
        }
        return super.method_25406(mouseX, mouseY, mouseButton);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        for (class_342 class_3422 : this.fieldList) {
            class_3422.method_25403(mouseX, mouseY, button, mouseDX, mouseDY);
        }
        this.checkColorPicker(mouseX, mouseY);
        this.dimScrollPane.method_25403(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.method_25403(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean method_25401(double x, double y, double scroll) {
        this.dimScrollPane.method_25401(x, y, scroll);
        return super.method_25401(x, y, scroll);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (class_342 class_3422 : this.fieldList) {
                class_3422.method_25402(mouseX, mouseY, mouseButton);
            }
            this.checkColorPicker(mouseX, mouseY);
            this.dimScrollPane.method_25402(mouseX, mouseY, mouseButton);
            Button button = this.dimScrollPane.mouseClicked((int)mouseX, (int)mouseY, mouseButton);
            if (button != null) {
                this.actionPerformed(button);
            }
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    protected void checkColorPicker(double mouseX, double mouseY) {
        if (this.colorPickRect.contains(mouseX, mouseY)) {
            int x = (int)(mouseX - (double)((int)this.colorPickRect.x));
            int y = (int)(mouseY - (double)((int)this.colorPickRect.y));
            this.setFormColor(this.colorPickTexture.getRGB(x, y));
        }
    }

    protected void setFormColor(Integer color) {
        this.currentColor = color;
        int[] c = RGB.ints(color);
        this.fieldR.method_1852(Integer.toString(c[0]));
        this.fieldG.method_1852(Integer.toString(c[1]));
        this.fieldB.method_1852(Integer.toString(c[2]));
        this.updateWaypointFromForm();
    }

    protected void actionPerformed(class_4185 guibutton) {
        if (this.dimButtonList.contains(guibutton)) {
            DimensionButton dimButton = (DimensionButton)guibutton;
            dimButton.toggle();
            this.updateWaypointFromForm();
        }
    }

    protected void setRandomColor() {
        this.editedWaypoint.setRandomColor();
        this.setFormColor(this.editedWaypoint.getIconColor());
    }

    protected void onTab() {
        boolean focusNext = false;
        boolean foundFocus = false;
        for (TextBox field : this.fieldList) {
            if (focusNext) {
                field.method_25365(true);
                foundFocus = true;
                break;
            }
            if (!field.method_25370()) continue;
            field.method_25365(false);
            field.clamp();
            focusNext = true;
        }
        if (!foundFocus) {
            this.fieldList.get(0).method_25365(true);
        }
    }

    protected boolean validate() {
        boolean valid = true;
        if (this.fieldName != null) {
            boolean bl = valid = this.fieldName.hasMinLength() && Strings.isNotEmpty((CharSequence)this.fieldName.method_1882());
        }
        if (valid && this.fieldY != null) {
            valid = this.fieldY.hasMinLength();
        }
        if (this.buttonSave != null) {
            this.buttonSave.setEnabled(valid && (this.isNew || !this.originalWaypoint.equals(this.editedWaypoint)));
        }
        return valid;
    }

    protected void remove() {
        WaypointStore.INSTANCE.remove(this.originalWaypoint, true);
        this.refreshAndClose(null);
    }

    protected void save() {
        if (!this.validate()) {
            return;
        }
        this.updateWaypointFromForm();
        WaypointStore.INSTANCE.remove(this.originalWaypoint, false);
        WaypointStore.INSTANCE.save(this.editedWaypoint, this.isNew);
        this.refreshAndClose(this.editedWaypoint);
    }

    protected void resetForm() {
        this.editedWaypoint = new Waypoint(this.originalWaypoint);
        this.dimButtonList.clear();
        this.fieldList.clear();
        this.getRenderables().clear();
        this.method_25426();
        this.validate();
    }

    protected void updateWaypointFromForm() {
        this.currentColor = RGB.toInteger(this.getSafeColorInt(this.fieldR), this.getSafeColorInt(this.fieldG), this.getSafeColorInt(this.fieldB));
        this.editedWaypoint.setColor(this.currentColor);
        this.fieldName.method_1868(this.editedWaypoint.getSafeColor());
        ArrayList<String> dims = new ArrayList<String>();
        for (DimensionButton db : this.dimButtonList) {
            if (!db.getToggled().booleanValue()) continue;
            dims.add(db.dimension);
        }
        this.editedWaypoint.setDimensions(dims);
        this.editedWaypoint.setEnable(this.buttonEnable.getToggled());
        this.editedWaypoint.setName(this.fieldName.method_1882());
        this.editedWaypoint.setLocation(this.getSafeCoordInt(this.fieldX), this.getSafeCoordInt(this.fieldY), this.getSafeCoordInt(this.fieldZ), DimensionHelper.getDimKeyName((class_1297)this.field_22787.field_1724));
    }

    protected int getSafeColorInt(TextBox field) {
        field.clamp();
        String text = field.method_1882();
        if (text == null || text.isEmpty()) {
            return 0;
        }
        int val = 0;
        try {
            val = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Math.max(0, Math.min(255, val));
    }

    protected int getSafeCoordInt(TextBox field) {
        String text = field.method_1882();
        if (text == null || text.isEmpty() || text.equals("-")) {
            return 0;
        }
        int val = 0;
        try {
            val = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    protected void refreshAndClose(Waypoint focusWaypoint) {
        if (returnDisplayStack != null && returnDisplayStack.peek() != null && returnDisplayStack.peek() instanceof WaypointManager) {
            ((WaypointManager)returnDisplayStack.peek()).setFocusWaypoint(focusWaypoint);
        }
        Fullscreen.state().requireRefresh();
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open((class_437)returnDisplayStack.pop());
        }
    }

    class DimensionButton
    extends OnOffButton {
        public final String dimension;

        DimensionButton(String dimension, String dimensionName, boolean toggled) {
            super(String.format("%s: %s", dimensionName, Constants.getString("jm.common.on")), String.format("%s: %s", dimensionName, Constants.getString("jm.common.off")), toggled, Button.emptyPressable());
            this.dimension = dimension;
            this.setToggled(toggled);
        }
    }
}

