/*
 * Decompiled with CFR 0.152.
 */
package com.nebspacefarer.stendhal.mixin;

import com.nebspacefarer.stendhal.screens.ExportBookGUI;
import com.nebspacefarer.stendhal.screens.ExportBookScreen;
import com.nebspacefarer.stendhal.screens.ImportBookGUI;
import com.nebspacefarer.stendhal.screens.ImportBookScreen;
import com.nebspacefarer.stendhal.screens.SymbolsGUI;
import com.nebspacefarer.stendhal.screens.SymbolsScreen;
import com.nebspacefarer.stendhal.utils.Book;
import com.nebspacefarer.stendhal.utils.StendhalBook;
import com.nebspacefarer.stendhal.utils.StendhalClipboard;
import com.nebspacefarer.stendhal.utils.StendhalUtils;
import io.github.cottonmc.cotton.gui.GuiDescription;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_3728;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_473;
import net.minecraft.class_5244;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_473.class})
public abstract class BookEditScreenMixin
extends class_437 {
    @Shadow
    private class_4185 field_2831;
    @Shadow
    private class_4185 field_2848;
    @Shadow
    @Final
    private class_3728 field_24269;
    @Shadow
    @Final
    private List<String> field_17116;
    @Shadow
    private int field_2840;
    @Shadow
    private boolean field_2828;
    class_4185 importBookButton;
    class_4185 exportBookButton;
    class_4185 clearBookButton;
    class_4185 copyBookButton;
    class_4185 pasteBookButton;
    class_4185 clearPageButton;
    class_4185 copyPageButton;
    class_4185 pastePageButton;
    class_4185 addPageButton;
    class_4185 removePageButton;
    class_4185 pasteClipButton;
    class_4185 charBoldButton;
    class_4185 charItalicButton;
    class_4185 charUnderlineButton;
    class_4185 charStrikeButton;
    class_4185 charObfuscatedButton;
    class_4185 charResetButton;
    class_4185 charCleanAllButton;
    class_4185 switchButton;
    class_4185 characterCount;
    class_4185 symbolsMenuButton;
    List<class_4185> stendhalButtons = new ArrayList<class_4185>();
    List<class_4185> stendhalColorButtons = new ArrayList<class_4185>();
    List<class_4185> stendhalSymbolButtons = new ArrayList<class_4185>();
    boolean symbols = false;
    int id = 1;
    int offset = 0;
    List<String> savedPages = new ArrayList<String>();

    @Shadow
    protected abstract int method_17046();

    @Shadow
    protected abstract void method_2437();

    @Shadow
    protected abstract void method_2444();

    @Shadow
    protected abstract String method_2427();

    @Shadow
    protected abstract void method_27584(String var1);

    @Shadow
    protected abstract void method_2439(String var1);

    @Shadow
    protected abstract void method_2413();

    @Shadow
    protected abstract void method_2407(boolean var1);

    @Shadow
    protected abstract void method_17047();

    @Shadow
    protected abstract String method_27595();

    protected BookEditScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"init()V"}, at={@At(value="RETURN")})
    public void init(CallbackInfo ci) {
        for (class_4185 button2 : this.stendhalButtons) {
            this.method_37066((class_364)button2);
        }
        this.stendhalButtons.clear();
        for (class_4185 button2 : this.stendhalColorButtons) {
            this.method_37066((class_364)button2);
        }
        this.stendhalColorButtons.clear();
        for (class_4185 button2 : this.stendhalSymbolButtons) {
            this.method_37066((class_364)button2);
        }
        this.stendhalSymbolButtons.clear();
        if (!Objects.equals(StendhalClipboard.symbol, "")) {
            this.field_24269.method_16197(StendhalClipboard.symbol);
            StendhalClipboard.symbol = "";
        }
        this.importBookButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_43471((String)"stendhal.bookImport"), button -> {
            StendhalClipboard.previousScreen = this.field_22787.field_1755;
            class_310.method_1551().method_1507((class_437)new ImportBookScreen((GuiDescription)new ImportBookGUI()));
        }).method_46434(4, 16, 146, 20).method_46431());
        if (StendhalBook.getBooks().isEmpty()) {
            this.importBookButton.field_22763 = false;
        }
        this.exportBookButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_43471((String)"stendhal.bookExport"), button -> {
            StendhalClipboard.previousScreen = this.field_22787.field_1755;
            StendhalBook.tempBook = new Book(class_2561.method_30163((String)""), class_2561.method_30163((String)""), this.field_17116);
            class_310.method_1551().method_1507((class_437)new ExportBookScreen((GuiDescription)new ExportBookGUI()));
        }).method_46434(4, 40, 146, 20).method_46431());
        if (StendhalBook.importBook != null) {
            int id;
            for (id = this.field_17116.size(); id > 0; --id) {
                this.method_2437();
            }
            this.field_17116.clear();
            this.method_2444();
            for (id = 0; id < StendhalBook.importBook.getPages().size(); ++id) {
                if (id > 0) {
                    this.method_2444();
                }
                String page = StendhalBook.importBook.getPages().get(id);
                this.method_2439("");
                this.field_24269.method_16197(page);
            }
            StendhalBook.importBook = null;
        }
        this.clearBookButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_30163((String)("\u00a74" + class_2561.method_43471((String)"stendhal.bookClear").getString())), button -> {
            for (int id = this.field_17116.size(); id > 0; --id) {
                this.method_2437();
            }
            this.field_17116.clear();
            this.method_2444();
        }).method_46434(4, 64, 146, 20).method_46431());
        this.copyBookButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_43471((String)"stendhal.bookCopy"), button -> {
            StendhalBook.copyBook = new Book(class_2561.method_30163((String)""), class_2561.method_30163((String)""), this.field_17116);
            this.field_22787.method_1507((class_437)null);
            this.method_2407(false);
        }).method_46434(4, 88, 146, 20).method_46431());
        this.pasteBookButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_43471((String)"stendhal.bookPaste"), button -> {
            if (StendhalBook.copyBook != null) {
                int id;
                for (id = 0; id < this.field_17116.size(); ++id) {
                    this.method_2444();
                }
                for (id = this.field_17116.size(); id > 0; --id) {
                    this.field_17116.remove(this.field_2840);
                    this.method_2437();
                }
                this.method_17047();
                this.method_2437();
                this.method_2444();
                this.method_2439("");
                for (int copyid = 0; copyid < StendhalBook.copyBook.getPages().size(); ++copyid) {
                    if (copyid > 0) {
                        this.method_2444();
                    }
                    String bookPage = StendhalBook.copyBook.getPages().get(copyid);
                    this.field_24269.method_16197(bookPage);
                }
                StendhalBook.copyBook = null;
            }
        }).method_46434(4, 112, 146, 20).method_46431());
        if (StendhalBook.copyBook == null) {
            this.pasteBookButton.field_22763 = false;
        }
        this.characterCount = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_43471((String)"stendhal.bookPaste"), button -> {}).method_46434(this.field_22789 / 2 - 30, 160, 50, 20).method_46431());
        this.characterCount.field_22763 = false;
        this.clearPageButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_43471((String)"stendhal.pageClear"), button -> this.method_2439("")).method_46434(this.field_22789 - 150, 16, 146, 20).method_46431());
        this.copyPageButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_43471((String)"stendhal.pageCopy"), button -> {
            StendhalClipboard.content = this.field_17116.get(this.field_2840);
            this.method_27584(StendhalClipboard.content);
        }).method_46434(this.field_22789 - 150, 40, 146, 20).method_46431());
        this.pastePageButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_43471((String)"stendhal.pagePaste"), button -> this.field_24269.method_16197(StendhalClipboard.content)).method_46434(this.field_22789 - 150, 64, 146, 20).method_46431());
        this.addPageButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_43471((String)"stendhal.pageAdd"), button -> {
            this.field_17116.add(this.field_2840 + 1, "");
            this.method_2444();
        }).method_46434(this.field_22789 - 150, 88, 146, 20).method_46431());
        this.removePageButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_43471((String)"stendhal.pageRemove"), button -> {
            if (this.field_2840 == 0 && this.method_17046() == 1) {
                this.method_2439("");
            }
            if (this.field_2840 > 0 && this.field_2840 == this.method_17046() - 1) {
                this.field_17116.remove(this.field_2840);
                this.method_2437();
            }
            if (this.field_2840 < this.method_17046() - 1) {
                this.field_17116.remove(this.field_2840);
                this.method_2437();
                this.method_2444();
            }
        }).method_46434(this.field_22789 - 150, 112, 146, 20).method_46431());
        this.pasteClipButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_43471((String)"stendhal.pasteClipboard"), button -> this.field_24269.method_16197(this.method_27595())).method_46434(this.field_22789 - 150, 136, 146, 20).method_46431());
        this.field_2831.method_25358(71);
        this.field_2831.method_46421(this.field_22789 - 73);
        this.field_2831.method_46419(160);
        this.field_2831.method_25355(class_2561.method_30163((String)("\u2709 \u00a7l" + class_2561.method_43471((String)"book.signButton").getString())));
        this.field_2848.method_25358(71);
        this.field_2848.method_46421(this.field_22789 - 150);
        this.field_2848.method_46419(160);
        this.field_2848.method_25355(class_2561.method_30163((String)("\u2718 \u00a7l" + class_5244.field_24334.getString())));
        this.switchButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u2764\ud83d\udd25\u2605 \u00a7l\u279c"), button -> {
            boolean bl = this.symbols = !this.symbols;
            if (!this.symbols) {
                this.switchButton.method_25355(class_2561.method_30163((String)"\u2764\ud83d\udd25\u2605 \u00a7l\u279c"));
            } else {
                this.switchButton.method_25355(class_2561.method_30163((String)"\u00a76\u2b1b\u00a7c\u2b1b\u00a74\u2b1b \u00a7f\u00a7l\u279c"));
            }
            this.method_2413();
        }).method_46434(this.field_22789 / 2 - 202, 190, 44, 20).method_46431());
        if (this.symbols) {
            this.switchButton.method_25355(class_2561.method_30163((String)"\u00a76\u2b1b\u00a7c\u2b1b\u00a74\u2b1b \u00a7f\u00a7l\u279c"));
        }
        this.id = 1;
        this.initSymbolsButtons();
        this.id = 1;
        for (String color : StendhalUtils.colorsList) {
            int posX = this.field_22789 / 2 - (176 - 22 * this.id);
            this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_30163((String)(color + "\u2b1b")), button -> this.insertChar(color)).method_46434(posX, 190, 20, 20).method_46431(), "color");
            ++this.id;
        }
        this.charBoldButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u00a7lB"), button -> this.insertChar("\u00a7l")).method_46434(this.field_22789 / 2 - 154, 212, 20, 20).method_46431());
        this.charItalicButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u00a7oI"), button -> this.insertChar("\u00a7o")).method_46434(this.field_22789 / 2 - 132, 212, 20, 20).method_46431());
        this.charUnderlineButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u00a7nU"), button -> this.insertChar("\u00a7n")).method_46434(this.field_22789 / 2 - 110, 212, 20, 20).method_46431());
        this.charStrikeButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u00a7mS"), button -> this.insertChar("\u00a7m")).method_46434(this.field_22789 / 2 - 88, 212, 20, 20).method_46431());
        this.charObfuscatedButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u00a7kO"), button -> this.insertChar("\u00a7k")).method_46434(this.field_22789 / 2 - 66, 212, 20, 20).method_46431());
        this.charResetButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_43471((String)"stendhal.charReset"), button -> this.insertChar("\u00a7r")).method_46434(this.field_22789 / 2 - 44, 212, 108, 20).method_46431());
        this.charCleanAllButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_43471((String)"stendhal.charCleanAll"), button -> {
            StendhalClipboard.page = this.method_2427().replaceAll("\u00a7[A-Za-z0-9]", "");
            this.field_17116.set(this.field_2840, StendhalClipboard.page);
            if (this.field_2840 < this.method_17046() - 1) {
                this.method_2444();
                this.method_2437();
            }
            if (this.field_2840 == this.method_17046() - 1) {
                this.method_2444();
                this.field_17116.remove(this.field_2840);
                this.method_2437();
            }
        }).method_46434(this.field_22789 / 2 + 66, 212, 108, 20).method_46431());
        this.symbolsMenuButton = this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u00a7c\u2191\u00a7r"), button -> {
            StendhalClipboard.previousScreen = this.field_22787.field_1755;
            class_310.method_1551().method_1507((class_437)new SymbolsScreen((GuiDescription)new SymbolsGUI()));
        }).method_46434(this.field_22789 / 2 - (176 - 22 * this.id + 1) + 5, 190, 20, 20).method_46431());
        this.method_2413();
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        this.field_22793.method_30883(matrices, class_2561.method_30163((String)("\u00a7c\u2764 \u00a7f\u00a7lStendhal \u00a7r\u00a7fBook Editor \u00a78" + StendhalUtils.version)), 7.0f, 4.0f, 0);
        int charCount = this.method_2427().length();
        String countColor = "\u00a72";
        if (charCount > 256) {
            countColor = "\u00a7c";
        }
        this.characterCount.method_25355(class_2561.method_30163((String)(countColor + this.method_2427().length() + "\u00a7r/256")));
        this.checkButtonTooltips(matrices);
    }

    @Inject(method={"updateButtons"}, at={@At(value="RETURN")})
    public void updateButtons(CallbackInfo ci) {
        for (class_4185 button : this.stendhalButtons) {
            button.field_22764 = !this.field_2828;
        }
        if (!this.field_2828) {
            for (class_4185 button : this.stendhalColorButtons) {
                button.field_22764 = !this.symbols;
            }
            for (class_4185 button : this.stendhalSymbolButtons) {
                button.field_22764 = this.symbols;
            }
        }
    }

    @Inject(method={"charTyped"}, at={@At(value="RETURN")})
    public void charTyped(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
    }

    public void insertChar(String s) {
        int start = Math.min(this.field_24269.method_16201(), this.field_24269.method_16203());
        int end = Math.max(this.field_24269.method_16201(), this.field_24269.method_16203());
        String selectedText = this.field_17116.get(this.field_2840).substring(start, end);
        if (start != end) {
            this.field_24269.method_16197(s + selectedText + "\u00a7r");
            return;
        }
        if (s != "\u00a7r") {
            this.field_24269.method_16197(s);
        }
        if (s == "\u00a7r") {
            this.field_24269.method_16197(s);
        }
    }

    public class_4185 stendhalAddButtons(class_4185 button) {
        class_4185 stendhalButton = (class_4185)this.method_37063((class_364)button);
        this.stendhalButtons.add(stendhalButton);
        return stendhalButton;
    }

    public class_4185 stendhalAddButtons(class_4185 button, String group) {
        class_4185 stendhalButton = (class_4185)this.method_37063((class_364)button);
        this.stendhalButtons.add(stendhalButton);
        if (group.equals("color")) {
            this.stendhalColorButtons.add(stendhalButton);
        }
        if (group.equals("symbol")) {
            this.stendhalSymbolButtons.add(stendhalButton);
        }
        return stendhalButton;
    }

    public void initSymbolsButtons() {
        if (!this.stendhalSymbolButtons.isEmpty()) {
            for (class_4185 button2 : this.stendhalSymbolButtons) {
                this.method_37066((class_364)button2);
            }
            this.stendhalSymbolButtons.clear();
        }
        int symbolsAmount = 14;
        if (this.offset > 0) {
            this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u00a7c\u25c0\u00a7r"), button -> {
                this.offset -= 14;
                this.id = 1;
                this.initSymbolsButtons();
            }).method_46434(this.field_22789 / 2 - (176 - 22 * this.id), 190, 20, 20).method_46431(), "symbol");
        }
        int offsetCount = this.offset;
        ++this.id;
        for (String symbol : StendhalUtils.symbolsList) {
            if (offsetCount > 0) {
                --offsetCount;
                continue;
            }
            if (symbolsAmount <= 0) continue;
            int posX = this.field_22789 / 2 - (176 - 22 * this.id);
            this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_30163((String)symbol), button -> this.field_24269.method_16197(symbol)).method_46434(posX, 190, 20, 20).method_46431(), "symbol");
            ++this.id;
            --symbolsAmount;
        }
        if (this.offset + 14 < StendhalUtils.symbolsList.length) {
            this.stendhalAddButtons(class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u00a7c\u25b6\u00a7r"), button -> {
                this.offset += 14;
                this.id = 1;
                this.initSymbolsButtons();
            }).method_46434(this.field_22789 / 2 - (176 - 22 * this.id), 190, 20, 20).method_46431(), "symbol");
        }
    }

    public void checkButtonTooltips(class_4587 matrices) {
        if (this.importBookButton.method_49606()) {
            this.field_22787.field_1755.method_25424(matrices, (class_2561)class_2561.method_43471((String)"stendhal.bookImport.tooltip"), this.importBookButton.method_46426(), this.importBookButton.method_46427());
        }
        if (this.exportBookButton.method_49606()) {
            this.field_22787.field_1755.method_25424(matrices, (class_2561)class_2561.method_43471((String)"stendhal.bookExport.tooltip"), this.exportBookButton.method_46426(), this.exportBookButton.method_46427());
        }
        if (this.clearBookButton.method_49606()) {
            this.field_22787.field_1755.method_25424(matrices, (class_2561)class_2561.method_43471((String)"stendhal.bookClear.tooltip"), this.clearBookButton.method_46426(), this.clearBookButton.method_46427());
        }
        if (this.copyBookButton.method_49606()) {
            this.field_22787.field_1755.method_25424(matrices, (class_2561)class_2561.method_43471((String)"stendhal.bookCopy.tooltip"), this.copyBookButton.method_46426(), this.copyBookButton.method_46427());
        }
        if (this.pasteBookButton.method_49606()) {
            this.field_22787.field_1755.method_25424(matrices, (class_2561)class_2561.method_43471((String)"stendhal.bookPaste.tooltip"), this.pasteBookButton.method_46426(), this.pasteBookButton.method_46427());
        }
        if (this.clearPageButton.method_49606()) {
            this.field_22787.field_1755.method_25424(matrices, (class_2561)class_2561.method_43471((String)"stendhal.pageClear.tooltip"), this.clearPageButton.method_46426(), this.clearPageButton.method_46427());
        }
        if (this.copyPageButton.method_49606()) {
            this.field_22787.field_1755.method_25424(matrices, (class_2561)class_2561.method_43471((String)"stendhal.pageCopy.tooltip"), this.copyPageButton.method_46426(), this.copyPageButton.method_46427());
        }
        if (this.pastePageButton.method_49606()) {
            this.field_22787.field_1755.method_25424(matrices, (class_2561)class_2561.method_43471((String)"stendhal.pagePaste.tooltip"), this.pastePageButton.method_46426(), this.pastePageButton.method_46427());
        }
        if (this.addPageButton.method_49606()) {
            this.field_22787.field_1755.method_25424(matrices, (class_2561)class_2561.method_43471((String)"stendhal.pageAdd.tooltip"), this.addPageButton.method_46426(), this.addPageButton.method_46427());
        }
        if (this.removePageButton.method_49606()) {
            this.field_22787.field_1755.method_25424(matrices, (class_2561)class_2561.method_43471((String)"stendhal.pageRemove.tooltip"), this.removePageButton.method_46426(), this.removePageButton.method_46427());
        }
        if (this.pasteClipButton.method_49606()) {
            this.field_22787.field_1755.method_25424(matrices, (class_2561)class_2561.method_43471((String)"stendhal.pasteClipboard.tooltip"), this.pasteClipButton.method_46426(), this.pasteClipButton.method_46427());
        }
        if (this.charResetButton.method_49606()) {
            this.field_22787.field_1755.method_25424(matrices, (class_2561)class_2561.method_43471((String)"stendhal.charReset.tooltip"), this.charResetButton.method_46426(), this.charResetButton.method_46427());
        }
        if (this.charCleanAllButton.method_49606()) {
            this.field_22787.field_1755.method_25424(matrices, (class_2561)class_2561.method_43471((String)"stendhal.charCleanAll.tooltip"), this.charCleanAllButton.method_46426(), this.charCleanAllButton.method_46427());
        }
        if (this.switchButton.method_49606()) {
            this.field_22787.field_1755.method_25424(matrices, (class_2561)class_2561.method_43471((String)"stendhal.switchButton.tooltip"), this.switchButton.method_46426(), this.switchButton.method_46427());
        }
        if (this.symbolsMenuButton.method_49606()) {
            this.field_22787.field_1755.method_25424(matrices, class_2561.method_30163((String)"Browse Unicodes..."), this.symbolsMenuButton.method_46426(), this.symbolsMenuButton.method_46427());
        }
    }
}

