#version 120


/*
		@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
		@##############################################################@	
		@#															  #@
		@#		[][][][][] [][][][][] [][][][][] [][][][][] []   	  #@
		@#		[]	  	       []     []      [] []	     [] []        #@
		@#		[]	 	       []     []      [] []	     [] []  	  #@
		@#		[]		       []     []      [] []	     [] []     	  #@
		@#		[][][][][]     []     []      [] [][][][][] []   	  #@
		@#				[]     []     []      [] []	        []        #@
		@#				[]     []     []      [] []	        []        #@
		@#				[]     []     []      [] []	           		  #@
		@#		[][][][][]     []     [][][][][] []	        []        #@
		@#															  #@
		@##############################################################@
		@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
		
		
		BEFORE DO ANYTHING, READ THIS AGREEMENT FIRST :
		
		
		YOU ARE ALLOWED TO :
		
		- Make videos or pictures with my shaderpack
		- Modify it only for yourself
		- Earn money with it from your YouTube Videos
		- Share my shaderpack link
		
		YOU ARE NOT ALLOWED TO :
		
		- Rename it and claim my shaderpack as your own
		- Publish your modifications
*/

/*
Werrus HFPS shaders, derived from Chocapic13 V4
*/

//disabling is done by adding "//" to the beginning of a line.

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES

#define WAVING_WATER

//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec3 binormal;
varying vec3 normal;
varying vec3 tangent;
varying vec3 viewVector;
varying vec3 wpos;
varying float iswater;

attribute vec4 mc_Entity;

uniform vec3 cameraPosition;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform int worldTime;
uniform float frameTimeCounter;
uniform int isEyeInWater;
uniform float rainStrength;
uniform sampler2D noisetex;

const float PI = 3.1415927;

float waterH(vec2 worldpos) {

vec2 movement = vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
vec2 movement2 = vec2(-abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
vec2 movement3 = vec2(-abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5));
vec2 movement4 = vec2(abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5));

vec2 coord = (worldpos/600)+(movement/3);
vec2 coord1 = (worldpos/599.9)+(movement2/3);
vec2 coord2 = (worldpos/599.8)+(movement3/3);
vec2 coord3 = (worldpos/599.7)+(movement4/3);
vec2 coord4 = (worldpos/1600)+(movement/5);
vec2 coord5 = (worldpos/1599)+(movement2/5);
vec2 coord6 = (worldpos/1598)+(movement3/5);
vec2 coord7 = (worldpos/1597)+(movement4/5);
float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;
float noise2 = texture2D(noisetex,fract(coord.xy/2.0)).x;
noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;
noise += texture2D(noisetex,fract(coord.xy*4.0)).x/8.0;
noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord1.xy*2.0)).x/4.0;
noise += texture2D(noisetex,fract(coord1.xy*4.0)).x/8.0;
noise += texture2D(noisetex,fract(coord2.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord2.xy*2.0)).x/4.0;
noise += texture2D(noisetex,fract(coord2.xy*4.0)).x/8.0;
noise += texture2D(noisetex,fract(coord3.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord3.xy*2.0)).x/4.0;
noise += texture2D(noisetex,fract(coord3.xy*4.0)).x/8.0;
noise2 += texture2D(noisetex,fract(coord4.xy)).x/2.0;
noise2 += texture2D(noisetex,fract(coord4.xy*2.0)).x/4.0;
noise2 += texture2D(noisetex,fract(coord4.xy*4.0)).x/8.0;
noise2 += texture2D(noisetex,fract(coord5.xy)).x/2.0;
noise2 += texture2D(noisetex,fract(coord5.xy*2.0)).x/4.0;
noise2 += texture2D(noisetex,fract(coord5.xy*4.0)).x/8.0;
noise2 += texture2D(noisetex,fract(coord6.xy)).x/2.0;
noise2 += texture2D(noisetex,fract(coord6.xy*2.0)).x/4.0;
noise2 += texture2D(noisetex,fract(coord6.xy*4.0)).x/8.0;
noise2 += texture2D(noisetex,fract(coord7.xy)).x/2.0;
noise2 += texture2D(noisetex,fract(coord7.xy*2.0)).x/4.0;
noise2 += texture2D(noisetex,fract(coord7.xy*4.0)).x/8.0;

return 	0.05 * sin(2 * PI * (noise*2.0))
+ 0.05 * sin(2 * PI * (noise2*2.0));
}

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
	
	//vec4 viewpos = gl_ModelViewMatrix * gl_Vertex;
	vec4 position = gl_ModelViewMatrix * gl_Vertex;
	iswater = 0.0f;
	float displacement = 0.0;
	
	/* un-rotate */
	vec4 viewpos = gbufferModelViewInverse * position;

	vec3 worldpos = viewpos.xyz + cameraPosition;
	wpos = worldpos;
	



	if(mc_Entity.x == 8.0 || mc_Entity.x == 9.0 || mc_Entity.x == 111.0) {
		iswater = 1.0;
		float fy = fract(worldpos.y + 0.001);

#ifdef WAVING_WATER

	float deltaPos = 0.1;
	float h0 = waterH(worldpos.xz);
	float h1 = waterH(worldpos.xz + vec2(deltaPos,0.0));
	float h2 = waterH(worldpos.xz + vec2(-deltaPos,0.0));
	float h3 = waterH(worldpos.xz + vec2(0.0,deltaPos));
	float h4 = waterH(worldpos.xz + vec2(0.0,-deltaPos));

	displacement = clamp(h0+h1+h2+h3+h4, -fy, 1.0-fy);
	viewpos.y += displacement*0.25;
#endif
	}
	
	/* re-rotate */
	viewpos = gbufferModelView * viewpos;

	/* projectify */
	gl_Position = gl_ProjectionMatrix * viewpos;
	
	color = gl_Color;
	
	texcoord = gl_TextureMatrix[0] * gl_MultiTexCoord0;

	lmcoord = gl_TextureMatrix[1] * gl_MultiTexCoord1;
	
	gl_FogFragCoord = gl_Position.z;
	
	tangent = vec3(0.0);
	binormal = vec3(0.0);
	normal = normalize(gl_NormalMatrix * normalize(gl_Normal));

	if (gl_Normal.x > 0.5) {
		//  1.0,  0.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0, -1.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	}
	
	else if (gl_Normal.x < -0.5) {
		// -1.0,  0.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	}
	
	else if (gl_Normal.y > 0.5) {
		//  0.0,  1.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
	}
	
	else if (gl_Normal.y < -0.5) {
		//  0.0, -1.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
	}
	
	else if (gl_Normal.z > 0.5) {
		//  0.0,  0.0,  1.0
		tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	}
	
	else if (gl_Normal.z < -0.5) {
		//  0.0,  0.0, -1.0
		tangent  = normalize(gl_NormalMatrix * vec3(-1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	}
	
	mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
							tangent.y, binormal.y, normal.y,
							tangent.z, binormal.z, normal.z);
	/*
	vec3 newnormal = vec3(sin(displacement*PI),1.0-cos(displacement*PI),displacement);
	
	vec3 bump = newnormal;
		bump = bump;
	
	float bumpmult = 0.05;
	
	bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);
		
		normal = bump * tbnMatrix;
	*/
	viewVector = (gl_ModelViewMatrix * gl_Vertex).xyz;
	viewVector = normalize(tbnMatrix * viewVector);
}