/*
====================================================================================================

    Copyright (C) 2022 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.com/copyright-license

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

#include "/lib/util/colorspace.glsl"

flat out mat2x3 lightColor;

#ifdef skypass
flat out vec3 sky_color;
#endif

#ifdef fogpass
flat out vec3 fogCol;
flat out vec3 fogCol2;
flat out vec3 fogEmissionColor;
#endif

uniform vec3 fogColor;

void getColorPalette() {
    lightColor[0]  = netherSkylightColor * pi;
    lightColor[0]  = mix(lightColor[0], linearToAP1(normalize(toLinear(fogColor))), 0.9) * 0.45 * pi;

    lightColor[1]  = blackbody(float(blocklightBaseTemp)) * blocklightIllum * blocklightBaseMult;


    #ifdef skypass
        sky_color    = vec3(1.0, 0.15, 0.1)*0.004;
        sky_color   = mix(sky_color, linearToAP1(toLinear(fogColor)) * 0.004, 0.7);
    #endif

    #ifdef fogpass
        fogCol      = linearToAP1(normalize(toLinear(fogColor)));
        fogCol2     = linearToAP1(toLinear(fogColor)) * 0.8;
        fogEmissionColor = blackbody(2500.0) * blocklightIllum * blocklightBaseMult;
    #endif
}