/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.itemborders;

import com.anthonyhilyard.iceberg.util.Selectors;
import com.anthonyhilyard.prism.item.ItemColors;
import com.anthonyhilyard.prism.util.ConfigHelper;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mojang.datafixers.util.Pair;
import fuzs.forgeconfigapiport.api.config.v2.ModConfigEvents;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_5251;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ItemBordersConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ItemBordersConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue hotBar;
    public final ForgeConfigSpec.BooleanValue showForCommon;
    public final ForgeConfigSpec.BooleanValue squareCorners;
    public final ForgeConfigSpec.BooleanValue fullBorder;
    public final ForgeConfigSpec.BooleanValue overItems;
    public final ForgeConfigSpec.BooleanValue extraGlow;
    public final ForgeConfigSpec.BooleanValue automaticBorders;
    public final ForgeConfigSpec.BooleanValue legendaryTooltipsSync;
    private final ForgeConfigSpec.ConfigValue<UnmodifiableConfig> manualBorders;
    private Map<ItemKey, Pair<Supplier<Integer>, Supplier<Integer>>> cachedCustomBorders = new HashMap<ItemKey, Pair<Supplier<Integer>, Supplier<Integer>>>();
    private boolean emptyCache = true;

    public ItemBordersConfig(ForgeConfigSpec.Builder build) {
        int i;
        ModConfigEvents.reloading((String)"itemborders").register(ItemBordersConfig::onReload);
        build.comment(" If you would like to specify manual borders, add a new manual_borders section at the bottom of the file.\n The format for each color of border is 'color = [\"modid:item1\", \"modid:item2\"]\"]'. Replace the color with either a color name (like red or blue), or a RGB / ARGB hex color code like 0xFFFFFF or 0xFF00FFFF.\n Here is a sample you can copy / paste and edit as needed:\n[client.options.manual_borders]\n\tred = [\"minecraft:torch\", \"minecraft:stick\"]").push("client").push("options");
        this.hotBar = build.comment(" If the hotbar should display item borders.").define("hotbar", true);
        this.showForCommon = build.comment(" If item borders should show for common items.").define("show_for_common", false);
        this.squareCorners = build.comment(" If the borders should have square corners.").define("square_corners", true);
        this.fullBorder = build.comment(" If the borders should fully envelop item slots (otherwise they will only show on the bottom portion of the slot).").define("full_border", false);
        this.overItems = build.comment(" If the borders draw over items instead of under.").define("over_items", false);
        this.extraGlow = build.comment(" If the borders should have a more prominent glow.").define("extra_glow", false);
        this.automaticBorders = build.comment(" If automatic borders (based on item rarity) should be enabled.").define("auto_borders", true);
        this.legendaryTooltipsSync = build.comment(" If enabled and Legendary Tooltips is installed, borders will sync with tooltip border colors.").define("legendary_tooltips_sync", false);
        StringBuilder entriesComment = new StringBuilder(" Custom border colors for specific items. Format: { <color> = [\"list of selectors\"] }.\n Color formats supported:\n");
        for (ConfigHelper.ColorFormatDocumentation doc : ConfigHelper.colorFormatDocumentation((boolean)true)) {
            entriesComment.append("   ").append(doc.name()).append(" - ").append(doc.description().replace("\n\n", "\n").replace("\n", "\n     "));
            if (!doc.examples().isEmpty()) {
                entriesComment.append("  Examples: ");
                for (i = 0; i < doc.examples().size(); ++i) {
                    if (((String)doc.examples().get(0)).startsWith("Using")) {
                        if (i == 0) {
                            entriesComment.setLength(entriesComment.length() - 18);
                            entriesComment.append("  ");
                        }
                        if (i > 1) {
                            entriesComment.append(", ");
                        }
                        entriesComment.append((String)doc.examples().get(i));
                        if (i != 0) continue;
                        entriesComment.append("     Examples: ");
                        continue;
                    }
                    if (i > 0) {
                        entriesComment.append(", ");
                    }
                    entriesComment.append((String)doc.examples().get(i));
                }
            }
            entriesComment.append("\n");
        }
        entriesComment.append(" Selectors supported:\n");
        for (ConfigHelper.ColorFormatDocumentation doc : Selectors.selectorDocumentation()) {
            entriesComment.append("   ").append(doc.name()).append(" - ").append(doc.description());
            if (!doc.examples().isEmpty()) {
                entriesComment.append("  Examples: ");
                for (i = 0; i < doc.examples().size(); ++i) {
                    if (i > 0) {
                        entriesComment.append(", ");
                    }
                    entriesComment.append("\"").append((String)doc.examples().get(i)).append("\"");
                }
            }
            entriesComment.append("\n");
        }
        entriesComment.setLength(entriesComment.length() - 1);
        this.manualBorders = build.comment(entriesComment.toString()).define("manual_borders", (Object)Config.of((ConfigFormat)TomlFormat.instance()), v -> true);
        build.pop().pop();
    }

    public static void onReload(ModConfig config) {
        if (config.getModId().equals("itemborders")) {
            ItemBordersConfig.INSTANCE.emptyCache = true;
        }
    }

    public static class_5251 getColor(Object value) {
        return (class_5251)ConfigHelper.parseColor((Object)value);
    }

    private static boolean validateColor(Object value) {
        return ItemBordersConfig.getColor(value) != null;
    }

    public Pair<Supplier<Integer>, Supplier<Integer>> getBorderColorForItem(class_1799 item) {
        ItemKey itemKey = new ItemKey(item.method_7909(), item.method_7969());
        if (this.emptyCache) {
            this.emptyCache = false;
            this.cachedCustomBorders.clear();
        }
        if (this.cachedCustomBorders.containsKey(itemKey)) {
            return this.cachedCustomBorders.get(itemKey);
        }
        Map manualBorderMap = ((UnmodifiableConfig)this.manualBorders.get()).valueMap();
        for (String key : manualBorderMap.keySet()) {
            class_5251 color = ItemBordersConfig.getColor(key);
            Pair colors = new Pair(() -> color.method_27716(), () -> color.method_27716());
            if (color == null) continue;
            Object value = manualBorderMap.get(key);
            if (value instanceof String) {
                if (!Selectors.itemMatches((class_1799)item, (String)((String)value))) continue;
                this.cachedCustomBorders.put(itemKey, (Pair<Supplier<Integer>, Supplier<Integer>>)colors);
                return colors;
            }
            if (!(value instanceof List)) continue;
            List valueList = (List)value;
            for (Object stringVal : valueList) {
                if (!(stringVal instanceof String) || !Selectors.itemMatches((class_1799)item, (String)((String)stringVal))) continue;
                this.cachedCustomBorders.put(itemKey, (Pair<Supplier<Integer>, Supplier<Integer>>)colors);
                return colors;
            }
        }
        Pair colors = null;
        if (((Boolean)ItemBordersConfig.INSTANCE.automaticBorders.get()).booleanValue()) {
            class_5251 color = ItemColors.getColorForItem((class_1799)item, null);
            colors = new Pair(() -> color.method_27716(), () -> color.method_27716());
        }
        if (FabricLoader.getInstance().isModLoaded("legendarytooltips") && ((Boolean)ItemBordersConfig.INSTANCE.legendaryTooltipsSync.get()).booleanValue()) {
            Pair borderColors = null;
            try {
                borderColors = (Pair)Class.forName("com.anthonyhilyard.itemborders.compat.LegendaryTooltipsHandler").getMethod("getBorderColors", class_1799.class).invoke(null, item);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (borderColors != null) {
                colors = borderColors;
            }
        }
        this.cachedCustomBorders.put(itemKey, colors);
        return colors;
    }

    static {
        Config.setInsertionOrderPreserved((boolean)true);
        org.apache.commons.lang3.tuple.Pair specPair = new ForgeConfigSpec.Builder().configure(ItemBordersConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (ItemBordersConfig)specPair.getLeft();
    }

    private record ItemKey(class_1792 item, class_2487 tag) {
    }
}

