/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.kanos_config.api;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import virtuoel.kanos_config.api.ConfigHandler;
import virtuoel.kanos_config.api.InvalidatableLazySupplier;
import virtuoel.kanos_config.api.MutableConfigEntry;

public abstract class ConfigBuilder<R, E, H extends ConfigHandler<R>> {
    protected final String namespace;
    protected final Path path;
    private final Collection<Consumer<Supplier<R>>> defaultValues;
    public final H config;

    public ConfigBuilder(String namespace, Path path) {
        this.namespace = namespace;
        this.path = path;
        this.defaultValues = new ArrayList<Consumer<Supplier<R>>>();
        this.config = this.createConfig();
    }

    public final Supplier<Double> doubleConfig(String name, double defaultValue) {
        return this.numberConfig(name, Number::doubleValue, defaultValue);
    }

    public final Supplier<Float> floatConfig(String name, float defaultValue) {
        return this.numberConfig(name, Number::floatValue, Float.valueOf(defaultValue));
    }

    public final Supplier<Long> longConfig(String name, long defaultValue) {
        return this.numberConfig(name, Number::longValue, defaultValue);
    }

    public final Supplier<Byte> byteConfig(String name, byte defaultValue) {
        return this.numberConfig(name, Number::byteValue, defaultValue);
    }

    public final Supplier<Short> shortConfig(String name, short defaultValue) {
        return this.numberConfig(name, Number::shortValue, defaultValue);
    }

    public final Supplier<Integer> intConfig(String name, int defaultValue) {
        return this.numberConfig(name, Number::intValue, defaultValue);
    }

    public abstract <T extends Number> Supplier<T> numberConfig(String var1, Function<Number, T> var2, T var3);

    public abstract Supplier<Boolean> booleanConfig(String var1, boolean var2);

    public abstract Supplier<String> stringConfig(String var1, String var2);

    public abstract Supplier<List<String>> stringListConfig(String var1);

    public abstract <T> Supplier<List<T>> listConfig(String var1, Function<E, T> var2);

    public final <T> MutableConfigEntry<T> customConfig(String name, Function<Supplier<R>, Consumer<T>> entrySetterFunction, T defaultValue, Function<Supplier<R>, Supplier<T>> entryGetterFunction) {
        this.defaultValues.add(r -> ((Consumer)entrySetterFunction.apply((Supplier)r)).accept(defaultValue));
        InvalidatableLazySupplier entry = InvalidatableLazySupplier.of(entryGetterFunction.apply((Supplier<R>)this.config));
        ((ConfigHandler)this.config).addInvalidationListener(entry::invalidate);
        return this.createConfigEntry(name, defaultValue, entry, v -> {
            ((Consumer)entrySetterFunction.apply((Supplier<R>)this.config)).accept(v);
            entry.invalidate();
        });
    }

    protected final Supplier<R> populateDefaults(Supplier<R> defaultConfigFactory) {
        return ConfigBuilder.populateDefaults(defaultConfigFactory, this.defaultValues);
    }

    protected static <R> Supplier<R> populateDefaults(Supplier<R> defaultConfigFactory, Collection<Consumer<Supplier<R>>> defaultValues) {
        return () -> {
            InvalidatableLazySupplier defaultConfigGetter = InvalidatableLazySupplier.of(defaultConfigFactory);
            for (Consumer value : defaultValues) {
                value.accept(defaultConfigGetter);
            }
            return defaultConfigGetter.get();
        };
    }

    protected abstract H createConfig();

    public <T> MutableConfigEntry<T> createConfigEntry(String name, T defaultValue, final Supplier<T> supplier, final Consumer<T> consumer) {
        return new MutableConfigEntry<T>(){

            @Override
            public T get() {
                return supplier.get();
            }

            @Override
            public void accept(T t) {
                consumer.accept(t);
            }

            public T getValue() {
                return supplier.get();
            }

            public void setValue(T value) {
                consumer.accept(value);
            }
        };
    }
}

