/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ksyxis;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;

public final class Ksyxis {
    private static final Logger LOGGER = LogManager.getLogger((String)"Ksyxis");
    private static final String MIXIN_ABSENT = "Ksyxis: No Mixin found. If you're using old (1.15.2 or older) Forge, please install a Mixin loader, for example MixinBootstrap, MixinBooter, UniMixins, or any other at your choice. If you're using new (1.16 or newer) Forge, any Fabric, any Quilt, any Ornithe, any LegacyFabric, or any NeoForge, then something went wrong and you should report it on GitHub. Ensure to include as much information (game version, loader type, loader version, mod version, other mods, logs, etc.) in the bug report as possible, this error screen is not enough. If you don't want any hassles and just want to load the game without solving anything, delete the Ksyxis mod. (platform: %s; manual: %s)";
    private static final String MIXIN_INJECT = "Ksyxis: Unable to inject the Ksyxis configuration. It's probably a bug or something, you should report it on GitHub. Ensure to include as much information (game version, loader type, loader version, mod version, other mods, logs, etc.) in the bug report as possible, this error screen is not enough. If you don't want any hassles and just want to load the game without solving anything, delete the Ksyxis mod. (platform: %s; manual: %s, mixin: %s)";
    private static int loadedChunks = 0;

    private Ksyxis() {
        throw new AssertionError((Object)"No instances.");
    }

    public static void init(String platform, boolean manual) {
        String mixinVersion = "UNKNOWN";
        try {
            LOGGER.info("Ksyxis: Booting... (platform: {}, manual: {})", new Object[]{platform, manual});
            try {
                Class<?> clazz = Class.forName("org.spongepowered.asm.launch.MixinBootstrap");
                Field field = clazz.getField("VERSION");
                mixinVersion = String.valueOf(field.get(null));
            }
            catch (Throwable t) {
                String message = String.format(MIXIN_ABSENT, platform, manual);
                LOGGER.error(message, t);
                try {
                    Class<?> tinyFd = Class.forName("org.lwjgl.util.tinyfd.TinyFileDialogs");
                    Method tinyFdMessageBox = tinyFd.getMethod("tinyfd_messageBox", CharSequence.class, CharSequence.class, CharSequence.class, CharSequence.class, Boolean.TYPE);
                    tinyFdMessageBox.invoke(null, "Minecraft | Ksyxis Mod", message, "ok", "error", false);
                }
                catch (Throwable th) {
                    t.addSuppressed(th);
                }
                try {
                    Class<?> sys = Class.forName("org.lwjgl.Sys");
                    Method sysAlert = sys.getMethod("alert", String.class, String.class);
                    sysAlert.invoke(null, "Minecraft | Ksyxis Mod", message);
                }
                catch (Throwable th) {
                    t.addSuppressed(th);
                }
                LOGGER.error(message, t);
                throw new RuntimeException(message, t);
            }
            LOGGER.info("Ksyxis: Found Mixin library. (version: {})", new Object[]{mixinVersion});
            if (manual) {
                MixinBootstrap.init();
                LOGGER.debug("Ksyxis: Mixin Bootstrap success.");
                Mixins.addConfiguration((String)"ksyxis.mixins.json");
                LOGGER.debug("Ksyxis: Mixin config added.");
            }
            try {
                Class<?> modernFixPluginClass = Class.forName("org.embeddedt.modernfix.core.ModernFixMixinPlugin");
                Field modernFixPluginField = modernFixPluginClass.getDeclaredField("instance");
                Method modernFixIsOptionEnabled = modernFixPluginClass.getMethod("isOptionEnabled", String.class);
                Object modernFix = modernFixPluginField.get(null);
                boolean removeSpawnChunks = (Boolean)modernFixIsOptionEnabled.invoke(modernFix, "perf.remove_spawn_chunks.MinecraftServer");
                if (removeSpawnChunks) {
                    loadedChunks = 441;
                    LOGGER.debug("Ksyxis: Will report 441 loaded chunks to prevent deadlocks with ModernFix.");
                } else {
                    LOGGER.debug("Ksyxis: Not providing compat with ModernFix, removeSpawnChunks is disabled.");
                }
            }
            catch (Throwable t) {
                LOGGER.debug("Ksyxis: Not providing compat with ModernFix, not found.", t);
            }
            LOGGER.info("Ksyxis: Ready. As always, this mod will speed up your world loading and might or might not break it.");
        }
        catch (Throwable t) {
            String message = String.format(MIXIN_INJECT, platform, manual, mixinVersion);
            LOGGER.error(message, t);
            try {
                Class<?> tinyFd = Class.forName("org.lwjgl.util.tinyfd.TinyFileDialogs");
                Method tinyFdMessageBox = tinyFd.getMethod("tinyfd_messageBox", CharSequence.class, CharSequence.class, CharSequence.class, CharSequence.class, Boolean.TYPE);
                tinyFdMessageBox.invoke(null, "Minecraft | Ksyxis Mod", message, "ok", "error", false);
            }
            catch (Throwable th) {
                t.addSuppressed(th);
            }
            try {
                Class<?> sys = Class.forName("org.lwjgl.Sys");
                Method sysAlert = sys.getMethod("alert", String.class, String.class);
                sysAlert.invoke(null, "Minecraft | Ksyxis Mod", message);
            }
            catch (Throwable th) {
                t.addSuppressed(th);
            }
            LOGGER.error(message, t);
            throw new RuntimeException(message, t);
        }
    }

    public static int loadedChunks() {
        return loadedChunks;
    }
}

