/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.ksyxis;

import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public final class KsyxisPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogManager.getLogger((String)"Ksyxis");

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!mixinClassName.startsWith("ru.vidtu.ksyxis.mixins.")) {
            return true;
        }
        try {
            ClassNode node = MixinService.getService().getBytecodeProvider().getClassNode(targetClassName);
            if (node != null) {
                LOGGER.debug("Ksyxis: Applying {} to {}, class node does exist.", new Object[]{mixinClassName, targetClassName});
                return true;
            }
            LOGGER.debug("Ksyxis: Not applying {} to {}, class node is null.", new Object[]{mixinClassName, targetClassName});
            return false;
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("Ksyxis: Not applying {} to {}, class node was not found.", new Object[]{mixinClassName, targetClassName, e});
            return false;
        }
        catch (Throwable t) {
            LOGGER.debug("Ksyxis: Unexpected error while trying to guess whether to apply {} to {}, will apply anyway.", new Object[]{mixinClassName, targetClassName, t});
            return true;
        }
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

