/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.pekhuisyn.common;

import com.google.common.collect.BiMap;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import lombok.NonNull;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.util.PehkuiEntityExtensions;

public final class PekhuiSyn
implements ModInitializer {
    @NotNull
    public static final Logger LOGGER = LogManager.getLogger((String)"PekhuiSyn");
    @NotNull
    public static final class_2960 CHANNEL = PekhuiSyn.createChannel("channel");
    @NotNull
    public static final class_2960 CHAT = PekhuiSyn.createChannel("chat");
    @NotNull
    private static final ThreadLocal<Collection<ScaleData>> SYNCED_SCALE_DATA = ThreadLocal.withInitial(ArrayList::new);

    public void onInitialize() {
    }

    @NotNull
    public static class_2960 createChannel(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new class_2960("pekhuisyn", path);
    }

    @Nullable
    public static class_2658 getPehkuiPacket(@NonNull class_1297 entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        @NonNull Collection<ScaleData> syncedScales = SYNCED_SCALE_DATA.get();
        for (Map.Entry entry : ((PehkuiEntityExtensions)entity).pehkui_getScales().entrySet()) {
            syncedScales.add((ScaleData)entry.getValue());
        }
        if (!syncedScales.isEmpty()) {
            @NonNull class_2540 buffer = new class_2540(Unpooled.buffer());
            buffer.method_10804(entity.method_5628());
            buffer.writeInt(syncedScales.size());
            for (ScaleData scale : syncedScales) {
                buffer.method_10812(ScaleRegistries.getId((BiMap)ScaleRegistries.SCALE_TYPES, (Object)scale.getScaleType()));
                scale.toPacket(buffer);
            }
            syncedScales.clear();
            return new class_2658(Pehkui.SCALE_PACKET, buffer);
        }
        return null;
    }
}

