/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.pekhuisyn.common.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import com.zeydie.pekhuisyn.api.ChatPacket;
import com.zeydie.pekhuisyn.api.ScaleDataPacket;
import com.zeydie.pekhuisyn.api.ScaleTypes;
import com.zeydie.pekhuisyn.common.PekhuiSyn;
import com.zeydie.sgson.SGsonBase;
import dev.tr7zw.firstperson.api.FirstPersonAPI;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import journeymap.client.JourneymapClient;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.properties.MiniMapProperties;
import lombok.Generated;
import lombok.NonNull;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.util.ModLoaderUtils;
import virtuoel.pehkui.util.ScaleUtils;

@Environment(value=EnvType.CLIENT)
public final class PekhuiSynClient
implements ClientModInitializer {
    private boolean chatOpened;
    private static final Map<UUID, Boolean> chatsOpened = Maps.newHashMap();

    private void handle(@NonNull ChatPacket packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        UUID uuid = UUID.fromString(packet.getUuid());
        boolean chat = packet.isChatOpened();
        if (!chat) {
            chatsOpened.remove(uuid);
        }
        if (chatsOpened.containsKey(uuid)) {
            chatsOpened.replace(uuid, chat);
        } else {
            chatsOpened.put(uuid, chat);
        }
    }

    public void onInitializeClient() {
        this.firstperson();
        this.journeymap();
        this.startNetwork();
    }

    private void firstperson() {
        if (ModLoaderUtils.isModLoaded((String)"firstperson")) {
            FirstPersonAPI.registerPlayerHandler((abstractClientPlayerEntity, v, vec3d, vec3d1) -> {
                float scaleHeight = ScaleUtils.getBoundingBoxHeightScale((class_1297)abstractClientPlayerEntity, (float)v);
                float scaleWidth = ScaleUtils.getBoundingBoxWidthScale((class_1297)abstractClientPlayerEntity, (float)v);
                return vec3d1.method_18805((double)scaleHeight, (double)scaleHeight, (double)scaleHeight);
            });
        }
    }

    private void journeymap() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            JourneymapClient journeymapClient;
            if (ModLoaderUtils.isModLoaded((String)"journeymap") && (journeymapClient = JourneymapClient.getInstance()).isInitialized().booleanValue()) {
                FullMapProperties fullMapProperties = journeymapClient.getFullMapProperties();
                fullMapProperties.showPlayers.set(Boolean.valueOf(false));
                fullMapProperties.showPlayerHeading.set(Boolean.valueOf(false));
                fullMapProperties.showPlayerLoc.set(Boolean.valueOf(false));
                MiniMapProperties miniMapProperties = journeymapClient.getActiveMiniMapProperties();
                miniMapProperties.showPlayers.set(Boolean.valueOf(false));
                miniMapProperties.showPlayerHeading.set(Boolean.valueOf(false));
            }
        });
    }

    private void startNetwork() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_746 player = client.field_1724;
            if (player != null) {
                try {
                    UUID uuid = player.method_5667();
                    if (class_310.method_1551().field_1755 instanceof class_408) {
                        if (this.chatOpened) {
                            return;
                        }
                        this.chatOpened = true;
                    } else {
                        if (!this.chatOpened) {
                            return;
                        }
                        this.chatOpened = false;
                    }
                    class_2540 packet = PacketByteBufs.create();
                    packet.method_10814(SGsonBase.create().fromObjectToJson(new ChatPacket(uuid.toString(), this.chatOpened)));
                    ClientPlayNetworking.send((class_2960)PekhuiSyn.CHAT, (class_2540)packet);
                }
                catch (Exception var5) {
                    var5.printStackTrace();
                }
            }
        });
        if (ModLoaderUtils.isModLoaded((String)"fabric-networking-api-v1")) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)PekhuiSyn.CHAT, (client, handler, buf, responseSender) -> {
                String json = new String(buf.method_36132());
                ChatPacket chatPacket = SGsonBase.create().fromJsonToObject(json, new ChatPacket());
                this.handle(chatPacket);
            });
            ClientPlayNetworking.registerGlobalReceiver((class_2960)PekhuiSyn.CHANNEL, (client, handler, buf, responseSender) -> {
                String json = new String(buf.method_36132());
                ScaleDataPacket scaleDataPacket = SGsonBase.create().fromJsonToObject(json, new ScaleDataPacket());
                final String playerName = scaleDataPacket.getPlayerName();
                final Map<ScaleTypes, Float> typesScales = scaleDataPacket.getTypesScales();
                client.execute(new Runnable(){

                    @Override
                    public void run() {
                        class_638 world = client.field_1687;
                        if (world != null) {
                            Optional playerEntityOptional = world.method_18456().stream().filter(input -> input.method_5820().equals(playerName)).findFirst();
                            if (playerEntityOptional.isPresent()) {
                                class_742 playerEntity = (class_742)playerEntityOptional.get();
                                for (ScaleTypes scaleTypes : typesScales.keySet()) {
                                    ScaleType scaleType = this.getScaleType(scaleTypes);
                                    class_2960 typeId = ScaleRegistries.getId((BiMap)ScaleRegistries.SCALE_TYPES, (Object)scaleType);
                                    Float scale = (Float)typesScales.get((Object)scaleTypes);
                                    ((ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (class_2960)typeId)).getScaleData((class_1297)playerEntity).setScale(scale.floatValue());
                                }
                            }
                        } else {
                            client.execute((Runnable)this);
                        }
                    }

                    @NotNull
                    private ScaleType getScaleType(@NonNull ScaleTypes type) {
                        if (type == null) {
                            throw new NullPointerException("type is marked non-null but is null");
                        }
                        switch (type) {
                            case BASE: {
                                return virtuoel.pehkui.api.ScaleTypes.BASE;
                            }
                            case WIDTH: {
                                return virtuoel.pehkui.api.ScaleTypes.WIDTH;
                            }
                            case HEIGHT: {
                                return virtuoel.pehkui.api.ScaleTypes.HEIGHT;
                            }
                            case EYE_HEIGHT: {
                                return virtuoel.pehkui.api.ScaleTypes.EYE_HEIGHT;
                            }
                            case HITBOX_WIDTH: {
                                return virtuoel.pehkui.api.ScaleTypes.HITBOX_WIDTH;
                            }
                            case HITBOX_HEIGHT: {
                                return virtuoel.pehkui.api.ScaleTypes.HITBOX_HEIGHT;
                            }
                            case MODEL_WIDTH: {
                                return virtuoel.pehkui.api.ScaleTypes.MODEL_WIDTH;
                            }
                            case MODEL_HEIGHT: {
                                return virtuoel.pehkui.api.ScaleTypes.MODEL_HEIGHT;
                            }
                            case THIRD_PERSON: {
                                return virtuoel.pehkui.api.ScaleTypes.THIRD_PERSON;
                            }
                            case MOTION: {
                                return virtuoel.pehkui.api.ScaleTypes.MOTION;
                            }
                            case FALLING: {
                                return virtuoel.pehkui.api.ScaleTypes.FALLING;
                            }
                            case STEP_HEIGHT: {
                                return virtuoel.pehkui.api.ScaleTypes.STEP_HEIGHT;
                            }
                            case VIEW_BOBBING: {
                                return virtuoel.pehkui.api.ScaleTypes.VIEW_BOBBING;
                            }
                            case VISIBILITY: {
                                return virtuoel.pehkui.api.ScaleTypes.VISIBILITY;
                            }
                            case JUMP_HEIGHT: {
                                return virtuoel.pehkui.api.ScaleTypes.JUMP_HEIGHT;
                            }
                            case FLIGHT: {
                                return virtuoel.pehkui.api.ScaleTypes.FLIGHT;
                            }
                            case REACH: {
                                return virtuoel.pehkui.api.ScaleTypes.REACH;
                            }
                            case BLOCK_REACH: {
                                return virtuoel.pehkui.api.ScaleTypes.BLOCK_REACH;
                            }
                            case ENTITY_REACH: {
                                return virtuoel.pehkui.api.ScaleTypes.ENTITY_REACH;
                            }
                            case MINING_SPEED: {
                                return virtuoel.pehkui.api.ScaleTypes.MINING_SPEED;
                            }
                            case ATTACK_SPEED: {
                                return virtuoel.pehkui.api.ScaleTypes.ATTACK_SPEED;
                            }
                            case KNOCKBACK: {
                                return virtuoel.pehkui.api.ScaleTypes.KNOCKBACK;
                            }
                            case ATTACK: {
                                return virtuoel.pehkui.api.ScaleTypes.ATTACK;
                            }
                            case DEFENSE: {
                                return virtuoel.pehkui.api.ScaleTypes.DEFENSE;
                            }
                            case HEALTH: {
                                return virtuoel.pehkui.api.ScaleTypes.HEALTH;
                            }
                            case DROPS: {
                                return virtuoel.pehkui.api.ScaleTypes.DROPS;
                            }
                            case HELD_ITEM: {
                                return virtuoel.pehkui.api.ScaleTypes.HELD_ITEM;
                            }
                            case PROJECTILES: {
                                return virtuoel.pehkui.api.ScaleTypes.PROJECTILES;
                            }
                            case EXPLOSIONS: {
                                return virtuoel.pehkui.api.ScaleTypes.EXPLOSIONS;
                            }
                        }
                        return virtuoel.pehkui.api.ScaleTypes.INVALID;
                    }
                });
            });
        } else {
            System.out.println("Failed to register Pehkui's packet handlers! Is Fabric API's networking module missing?");
        }
    }

    @Generated
    public static Map<UUID, Boolean> getChatsOpened() {
        return chatsOpened;
    }
}

