/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.sgson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class SGsonBase {
    @Generated
    private static final Logger log = Logger.getLogger(SGsonBase.class.getName());
    private Gson gson;
    private boolean debugging;

    public SGsonBase() {
        this.setDefaultGsonBuilder();
    }

    public void setDefaultGsonBuilder() {
        this.setGsonBuilder(new GsonBuilder());
    }

    @NotNull
    public static SGsonBase create() {
        return new SGsonBase();
    }

    @NotNull
    public <G extends GsonBuilder, O extends SGsonBase> O setGsonBuilder(@NonNull G gsonBuilder) {
        if (gsonBuilder == null) {
            throw new NullPointerException("gsonBuilder is marked non-null but is null");
        }
        return this.setGson(gsonBuilder.create());
    }

    @NotNull
    public <G extends Gson, O extends SGsonBase> O setGson(@NonNull G gson) {
        if (gson == null) {
            throw new NullPointerException("gson is marked non-null but is null");
        }
        this.gson = gson;
        return (O)this;
    }

    @NotNull
    public <O extends SGsonBase> O setPretty() {
        return this.setGsonBuilder(this.gson.newBuilder().setPrettyPrinting());
    }

    @NotNull
    public <O extends SGsonBase> O setDebug() {
        this.debugging = true;
        return (O)this;
    }

    @NotNull
    public <O> String fromObjectToJson(@NonNull O object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return this.gson.toJson(object);
    }

    @NotNull
    public <O, S extends String> O fromJsonToObject(@NonNull S json, @NonNull O object) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return (O)this.gson.fromJson(json, object.getClass());
    }

    public final void info(@NonNull String message, Object ... args) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (this.debugging) {
            log.info(String.format(message, args));
        }
    }

    public final void warning(@NonNull String message, Object ... args) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (this.debugging) {
            log.warning(String.format(message, args));
        }
    }

    @Generated
    public Gson getGson() {
        return this.gson;
    }

    @Generated
    public boolean isDebugging() {
        return this.debugging;
    }
}

