/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.sgson.streams;

import com.zeydie.sgson.SGsonFile;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public final class FileReaderStream {
    @NotNull
    private final File file;

    public FileReaderStream(@NonNull SGsonFile gsonFile) {
        if (gsonFile == null) {
            throw new NullPointerException("gsonFile is marked non-null but is null");
        }
        this.file = gsonFile.getFile();
    }

    @NotNull
    public String getJsonFile() {
        return this.getLines().stream().map(String::toString).collect(Collectors.joining());
    }

    @NotNull
    public List<String> getLines() {
        return Files.readAllLines(this.file.toPath(), StandardCharsets.UTF_8);
    }

    @NotNull
    @Generated
    public File getFile() {
        return this.file;
    }
}

