/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.sgson.streams;

import com.zeydie.sgson.SGsonFile;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public final class FileWriterStream {
    @NotNull
    private final SGsonFile simpleGson;

    public <S extends SGsonFile> FileWriterStream(@NonNull S simpleGson) {
        if (simpleGson == null) {
            throw new NullPointerException("simpleGson is marked non-null but is null");
        }
        this.simpleGson = simpleGson;
    }

    public <S extends CharSequence> void writeJsonFile(@NonNull S json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        this.createFile();
        @NonNull File file = this.simpleGson.getFile();
        this.simpleGson.info("Writing to %s", file.getAbsoluteFile());
        Files.write(file.toPath(), Collections.singleton(json), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public void createFile() {
        @NonNull File file = this.simpleGson.getFile();
        if (!file.exists()) {
            @NonNull File parent = file.getParentFile();
            if (parent != null && parent.mkdirs()) {
                this.simpleGson.info("Creating folders %s", parent.getAbsoluteFile());
            }
            if (file.createNewFile()) {
                this.simpleGson.info("Creating file %s", file);
            }
        }
    }

    @NotNull
    @Generated
    public SGsonFile getSimpleGson() {
        return this.simpleGson;
    }
}

