/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.util;

import com.google.gson.stream.JsonWriter;
import com.minelittlepony.common.util.GamePaths;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2231;
import net.minecraft.class_2237;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2320;
import net.minecraft.class_2346;
import net.minecraft.class_2373;
import net.minecraft.class_2383;
import net.minecraft.class_2384;
import net.minecraft.class_2389;
import net.minecraft.class_2397;
import net.minecraft.class_2404;
import net.minecraft.class_2429;
import net.minecraft.class_2482;
import net.minecraft.class_2493;
import net.minecraft.class_2498;
import net.minecraft.class_2500;
import net.minecraft.class_2510;
import net.minecraft.class_2527;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2577;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BlockReport {
    private final Path loc;

    public BlockReport(String baseName) {
        this.loc = BlockReport.getUniqueFileName(GamePaths.getGameDirectory().resolve("presencefootsteps"), baseName, ".json");
    }

    public CompletableFuture<?> execute(@Nullable Predicate<class_2680> filter) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.writeReport(filter);
                this.printResults();
            }
            catch (Exception e) {
                BlockReport.addMessage((class_2561)class_2561.method_43469((String)"pf.report.error", (Object[])new Object[]{e.getMessage()}).method_27694(s -> s.method_10977(class_124.field_1061)));
            }
        });
    }

    private void writeReport(@Nullable Predicate<class_2680> filter) throws IOException {
        Files.createDirectories(this.loc.getParent(), new FileAttribute[0]);
        try (JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(this.loc, new OpenOption[0]));){
            writer.setIndent("    ");
            writer.beginObject();
            writer.name("blocks");
            writer.beginObject();
            HashMap groups = new HashMap();
            class_7923.field_41175.forEach(block -> {
                class_2680 state = block.method_9564();
                try {
                    class_2498 group = block.method_9564().method_26231();
                    if (group != null && group.method_10594() != null) {
                        String substrate = String.format(Locale.ENGLISH, "%.2f_%.2f", Float.valueOf(group.field_11540), Float.valueOf(group.field_11539));
                        groups.put(group.method_10594().method_14833().toString() + "@" + substrate, group);
                    }
                    if (filter == null || filter.test(state)) {
                        writer.name(class_7923.field_41175.method_10221(block).toString());
                        writer.beginObject();
                        writer.name("class");
                        writer.value(this.getClassData(state));
                        writer.name("sound");
                        writer.value(this.getSoundData(group));
                        writer.name("association");
                        writer.value(PresenceFootsteps.getInstance().getEngine().getIsolator().getBlockMap().getAssociation(state, ""));
                        writer.endObject();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            writer.endObject();
            writer.name("unmapped_entities");
            writer.beginArray();
            class_7923.field_41177.forEach(type -> {
                if (type.method_5883((class_1937)class_310.method_1551().field_1687) instanceof class_1309) {
                    class_2960 id = class_7923.field_41177.method_10221(type);
                    if (!PresenceFootsteps.getInstance().getEngine().getIsolator().getLocomotionMap().contains(id)) {
                        try {
                            writer.value(id.toString());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            writer.endArray();
            writer.name("primitives");
            writer.beginObject();
            groups.values().forEach(group -> {
                try {
                    String substrate = String.format(Locale.ENGLISH, "%.2f_%.2f", Float.valueOf(group.field_11540), Float.valueOf(group.field_11539));
                    writer.name(group.method_10594().method_14833().toString() + "@" + substrate);
                    writer.value(PresenceFootsteps.getInstance().getEngine().getIsolator().getPrimitiveMap().getAssociation((class_2498)group, substrate));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            writer.endObject();
            writer.endObject();
        }
    }

    private String getSoundData(@Nullable class_2498 group) {
        if (group == null) {
            return "NULL";
        }
        if (group.method_10594() == null) {
            return "NO_SOUND";
        }
        return group.method_10594().method_14833().method_12832();
    }

    private String getClassData(class_2680 state) {
        class_2248 block = state.method_26204();
        Object soundName = "";
        if (block instanceof class_2231) {
            soundName = (String)soundName + ",EXTENDS_PRESSURE_PLATE";
        }
        if (block instanceof class_2241) {
            soundName = (String)soundName + ",EXTENDS_RAIL";
        }
        if (block instanceof class_2237) {
            soundName = (String)soundName + ",EXTENDS_CONTAINER";
        }
        if (block instanceof class_2404) {
            soundName = (String)soundName + ",EXTENDS_LIQUID";
        }
        if (block instanceof class_2261) {
            soundName = (String)soundName + ",EXTENDS_PLANT";
        }
        if (block instanceof class_2320) {
            soundName = (String)soundName + ",EXTENDS_DOUBLE_PLANT";
        }
        if (block instanceof class_2429) {
            soundName = (String)soundName + ",EXTENDS_CONNECTED_PLANT";
        }
        if (block instanceof class_2397) {
            soundName = (String)soundName + ",EXTENDS_LEAVES";
        }
        if (block instanceof class_2482) {
            soundName = (String)soundName + ",EXTENDS_SLAB";
        }
        if (block instanceof class_2510) {
            soundName = (String)soundName + ",EXTENDS_STAIRS";
        }
        if (block instanceof class_2493) {
            soundName = (String)soundName + ",EXTENDS_SNOWY";
        }
        if (block instanceof class_2500) {
            soundName = (String)soundName + ",EXTENDS_SPREADABLE";
        }
        if (block instanceof class_2346) {
            soundName = (String)soundName + ",EXTENDS_PHYSICALLY_FALLING";
        }
        if (block instanceof class_2389) {
            soundName = (String)soundName + ",EXTENDS_PANE";
        }
        if (block instanceof class_2383) {
            soundName = (String)soundName + ",EXTENDS_PILLAR";
        }
        if (block instanceof class_2527) {
            soundName = (String)soundName + ",EXTENDS_TORCH";
        }
        if (block instanceof class_2577) {
            soundName = (String)soundName + ",EXTENDS_CARPET";
        }
        if (block instanceof class_2384) {
            soundName = (String)soundName + ",EXTENDS_INFESTED";
        }
        if (block instanceof class_2373) {
            soundName = (String)soundName + ",EXTENDS_TRANSPARENT";
        }
        return soundName;
    }

    private void printResults() {
        BlockReport.addMessage((class_2561)class_2561.method_43471((String)"pf.report.save").method_10852((class_2561)class_2561.method_43470((String)this.loc.getFileName().toString()).method_27694(s -> s.method_10958(new class_2558(class_2558.class_2559.field_11746, this.loc.toString())).method_27706(class_124.field_1073))).method_27694(s -> s.method_10977(class_124.field_1060)));
    }

    public static void addMessage(class_2561 text) {
        class_310.method_1551().field_1705.method_1743().method_1812(text);
    }

    static Path getUniqueFileName(Path directory, String baseName, String ext) {
        Path loc = null;
        int counter = 0;
        while (loc == null || Files.exists(loc, new LinkOption[0])) {
            loc = directory.resolve(baseName + (String)(counter == 0 ? "" : "_" + counter) + ext);
            ++counter;
        }
        return loc;
    }
}

