/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.world.Emitter;
import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import org.jetbrains.annotations.Nullable;

public class Association {
    public static final Association NOT_EMITTER = new Association();
    private final class_2680 blockState;
    private final class_2338 pos;
    private String data = "NOT_EMITTER";
    private String wetData = "NOT_EMITTER";
    private class_1309 source;

    public Association() {
        this(class_2246.field_10124.method_9564(), class_2338.field_10980);
    }

    public Association(class_2680 state, class_2338 pos) {
        this.blockState = state;
        this.pos = pos;
    }

    public Association at(class_1309 source) {
        if (!this.isNull()) {
            this.source = source;
        }
        return this;
    }

    public Association withDry(@Nullable String data) {
        if (!this.isNull() && data != null) {
            this.data = data;
        }
        return this;
    }

    public Association withWet(@Nullable String data) {
        if (!this.isNull() && data != null) {
            this.wetData = data;
        }
        return this;
    }

    public boolean isNull() {
        return this == NOT_EMITTER;
    }

    public boolean isNotEmitter() {
        return this.isNull() || Emitter.isNonEmitter(this.data) && Emitter.isNonEmitter(this.wetData);
    }

    public boolean hasAssociation() {
        return !this.isNotEmitter() && (Emitter.isResult(this.data) || Emitter.isResult(this.wetData));
    }

    public String getAcousticName() {
        return this.data;
    }

    public String getWetAcousticName() {
        return this.wetData;
    }

    public class_1309 getSource() {
        return this.source;
    }

    public class_3614 getMaterial() {
        return this.blockState.method_26207();
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2498 getSoundGroup() {
        return this.blockState.method_26231();
    }

    public boolean dataEquals(Association other) {
        return this.hasAssociation() && Objects.equals(this.data, other.data);
    }
}

