/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.world.Emitter;
import eu.ha3.presencefootsteps.world.Lookup;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class StateLookup
implements Lookup<class_2680> {
    private final Map<String, Bucket> substrates = new LinkedHashMap<String, Bucket>();

    @Override
    public String getAssociation(class_2680 state, String substrate) {
        return this.substrates.getOrDefault((Object)substrate, (Bucket)Bucket.EMPTY).get((class_2680)state).value;
    }

    @Override
    public void add(String key, String value) {
        if (!Emitter.isResult(value)) {
            PresenceFootsteps.logger.info("Skipping non-result value " + key + "=" + value);
            return;
        }
        Key k = new Key(key, value);
        this.substrates.computeIfAbsent(k.substrate, Bucket.Substrate::new).add(k);
    }

    @Override
    public Set<String> getSubstrates() {
        return this.substrates.keySet();
    }

    @Override
    public boolean contains(class_2680 state) {
        for (Bucket substrate : this.substrates.values()) {
            if (!substrate.contains(state)) continue;
            return true;
        }
        return false;
    }

    private static interface Bucket {
        public static final Bucket EMPTY = state -> Key.NULL;

        default public void add(Key key) {
        }

        public Key get(class_2680 var1);

        default public boolean contains(class_2680 state) {
            return false;
        }

        public static final class Tile
        implements Bucket {
            private final Map<class_2680, Key> cache = new LinkedHashMap<class_2680, Key>();
            private final KeyList keys = new KeyList();

            Tile(class_2960 id) {
            }

            @Override
            public void add(Key key) {
                this.keys.add(key);
            }

            @Override
            public Key get(class_2680 state) {
                return this.cache.computeIfAbsent(state, this.keys::findMatch);
            }

            @Override
            public boolean contains(class_2680 state) {
                return this.get(state) != Key.NULL;
            }
        }

        public static final class Substrate
        implements Bucket {
            private final KeyList wildcards = new KeyList();
            private final Map<class_2960, Bucket> blocks = new LinkedHashMap<class_2960, Bucket>();
            private final Map<class_2960, Bucket> tags = new LinkedHashMap<class_2960, Bucket>();

            Substrate(String substrate) {
            }

            @Override
            public void add(Key key) {
                if (key.isWildcard) {
                    this.wildcards.add(key);
                } else {
                    (key.isTag ? this.tags : this.blocks).computeIfAbsent(key.identifier, Tile::new).add(key);
                }
            }

            @Override
            public Key get(class_2680 state) {
                Key association = this.getTile(state).get(state);
                if (association == Key.NULL) {
                    return this.wildcards.findMatch(state);
                }
                return association;
            }

            @Override
            public boolean contains(class_2680 state) {
                return this.getTile(state).contains(state);
            }

            private Bucket getTile(class_2680 state) {
                return this.blocks.computeIfAbsent(class_7923.field_41175.method_10221((Object)state.method_26204()), id -> {
                    for (class_2960 tag : this.tags.keySet()) {
                        if (!state.method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)tag))) continue;
                        return this.tags.get(tag);
                    }
                    return EMPTY;
                });
            }
        }
    }

    private static final class Key {
        public static final Key NULL = new Key();
        public final class_2960 identifier;
        public final String substrate;
        private final Set<Attribute> properties;
        public final String value;
        private final boolean empty;
        public final boolean isTag;
        public final boolean isWildcard;

        private Key() {
            this.identifier = new class_2960("air");
            this.substrate = "";
            this.properties = Collections.emptySet();
            this.value = "UNASSIGNED";
            this.empty = true;
            this.isTag = false;
            this.isWildcard = false;
        }

        Key(String key, String value) {
            String substrate;
            String id;
            this.value = value;
            boolean bl = this.isTag = key.indexOf(35) == 0;
            if (this.isTag) {
                key = key.replaceFirst("#", "");
            }
            boolean bl2 = this.isWildcard = (id = key.split("[\\.\\[]")[0]).indexOf(42) == 0;
            if (!this.isWildcard) {
                if (id.indexOf(94) > -1) {
                    this.identifier = new class_2960(id.split("\\^")[0]);
                    PresenceFootsteps.logger.warn("Metadata entry for " + key + "=" + value + " was ignored");
                } else {
                    this.identifier = new class_2960(id);
                }
                if (!this.isTag && !class_7923.field_41175.method_10250(this.identifier)) {
                    PresenceFootsteps.logger.warn("Sound registered for unknown block id " + this.identifier);
                }
            } else {
                this.identifier = new class_2960("air");
            }
            if ((substrate = (key = key.replace(id, "")).replaceFirst("\\[[^\\]]+\\]", "")).indexOf(46) > -1) {
                this.substrate = substrate.split("\\.")[1];
                key = key.replace(substrate, "");
            } else {
                this.substrate = "";
            }
            this.properties = Lists.newArrayList((Object[])key.replace("[", "").replace("]", "").split(",")).stream().filter(line -> line.indexOf(61) > -1).map(Attribute::new).collect(Collectors.toSet());
            this.empty = this.properties.isEmpty();
        }

        boolean matches(class_2680 state) {
            if (this.empty) {
                return true;
            }
            ImmutableMap entries = state.method_11656();
            Set keys = entries.keySet();
            for (Attribute property : this.properties) {
                for (class_2769 key : keys) {
                    Comparable value;
                    if (!key.method_11899().equals(property.name) || Objects.toString(value = (Comparable)entries.get(key)).equalsIgnoreCase(property.value)) continue;
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return (this.isTag ? "#" : "") + this.identifier + "[" + this.properties.stream().map(Attribute::toString).collect(Collectors.joining()) + "]." + this.substrate + "=" + this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.empty ? 1231 : 1237);
            result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
            result = 31 * result + (this.isTag ? 1231 : 1237);
            result = 31 * result + (this.isWildcard ? 1231 : 1237);
            result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
            result = 31 * result + (this.substrate == null ? 0 : this.substrate.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && this.getClass() == obj.getClass() && this.equals((Key)obj);
        }

        private boolean equals(Key other) {
            return this.isTag == other.isTag && this.isWildcard == other.isWildcard && this.empty == other.empty && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.substrate, other.substrate) && Objects.equals(this.properties, other.properties);
        }

        private record Attribute(String name, String value) {
            Attribute(String prop) {
                this(prop.split("="));
            }

            Attribute(String[] split) {
                this(split[0], split[1]);
            }

            @Override
            public String toString() {
                return this.name + "=" + this.value;
            }
        }
    }

    private static final class KeyList {
        private final Set<Key> priorityKeys = new LinkedHashSet<Key>();
        private final Set<Key> keys = new LinkedHashSet<Key>();

        private KeyList() {
        }

        void add(Key key) {
            Set<Key> keys = this.getSetFor(key);
            keys.remove(key);
            keys.add(key);
        }

        private Set<Key> getSetFor(Key key) {
            return key.empty ? this.keys : this.priorityKeys;
        }

        public Key findMatch(class_2680 state) {
            for (Key i : this.priorityKeys) {
                if (!i.matches(state)) continue;
                return i;
            }
            for (Key i : this.keys) {
                if (!i.matches(state)) continue;
                return i;
            }
            return Key.NULL;
        }
    }
}

