/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.armorstatues.api.client.gui.components.LiveSliderButton;
import fuzs.armorstatues.api.client.gui.components.UnboundedSliderButton;
import fuzs.armorstatues.api.client.gui.screens.armorstand.AbstractArmorStandScreen;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_757;

public abstract class BoxedSliderButton
extends class_339
implements UnboundedSliderButton,
LiveSliderButton {
    static final double VALUE_KEY_INTERVAL = 0.035;
    private static final int SLIDER_SIZE = 13;
    private final DoubleSupplier currentHorizontalValue;
    private final DoubleSupplier currentVerticalValue;
    protected final OnTooltip onTooltip;
    protected double horizontalValue;
    protected double verticalValue;
    private boolean clicked = false;

    public BoxedSliderButton(int x, int y, DoubleSupplier currentHorizontalValue, DoubleSupplier currentVerticalValue) {
        this(x, y, currentHorizontalValue, currentVerticalValue, (button, poseStack, mouseX, mouseY) -> {});
    }

    public BoxedSliderButton(int x, int y, DoubleSupplier currentHorizontalValue, DoubleSupplier currentVerticalValue, OnTooltip onTooltip) {
        super(x, y, 54, 54, class_5244.field_39003);
        this.onTooltip = onTooltip;
        this.currentHorizontalValue = currentHorizontalValue;
        this.currentVerticalValue = currentVerticalValue;
        this.refreshValues();
    }

    @Override
    public void refreshValues() {
        this.horizontalValue = this.currentHorizontalValue.getAsDouble();
        this.verticalValue = this.currentVerticalValue.getAsDouble();
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        if (this.field_22763) {
            if (this.method_25370()) {
                narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.focused"));
            } else {
                narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.hovered"));
            }
            this.onTooltip.narrateTooltip(component -> narrationElementOutput.method_37034(class_6381.field_33790, component));
        }
    }

    public void method_48579(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)AbstractArmorStandScreen.getArmorStandWidgetsLocation());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        int sliderX = (int)(this.horizontalValue * (double)(this.field_22758 - 13 - 2));
        int sliderY = (int)(this.verticalValue * (double)(this.field_22759 - 13 - 2));
        boolean hoveredOrFocused = this.method_25367();
        boolean hovered = this.method_49606();
        boolean horizontalValueLocked = this.horizontalValueLocked();
        boolean verticalValueLocked = this.verticalValueLocked();
        if (!this.field_22763 || !hoveredOrFocused || !horizontalValueLocked && !verticalValueLocked) {
            BoxedSliderButton.method_25302((class_4587)poseStack, (int)this.method_46426(), (int)this.method_46427(), (int)0, (int)120, (int)this.field_22758, (int)this.field_22759);
        } else if (horizontalValueLocked && verticalValueLocked) {
            BoxedSliderButton.method_25302((class_4587)poseStack, (int)(this.method_46426() + sliderX), (int)(this.method_46427() + sliderY), (int)164, (int)0, (int)15, (int)15);
        } else if (horizontalValueLocked) {
            BoxedSliderButton.method_25302((class_4587)poseStack, (int)(this.method_46426() + sliderX), (int)this.method_46427(), (int)54, (int)120, (int)15, (int)this.field_22759);
        } else {
            BoxedSliderButton.method_25302((class_4587)poseStack, (int)this.method_46426(), (int)(this.method_46427() + sliderY), (int)136, (int)49, (int)this.field_22758, (int)15);
        }
        int i = this.getYImage(hoveredOrFocused);
        BoxedSliderButton.method_25302((class_4587)poseStack, (int)(this.method_46426() + 1 + sliderX), (int)(this.method_46427() + 1 + sliderY), (int)151, (int)(i * 13), (int)13, (int)13);
        if (hovered) {
            this.renderToolTip(poseStack, mouseX, mouseY);
        }
    }

    public int getYImage(boolean bl) {
        return this.field_22763 ? (bl ? 2 : 1) : 0;
    }

    public void renderToolTip(class_4587 poseStack, int relativeMouseX, int relativeMouseY) {
        this.onTooltip.onTooltip(this, poseStack, relativeMouseX, relativeMouseY);
    }

    public void method_25348(double mouseX, double mouseY) {
        this.clicked = true;
        this.setValueFromMouse(mouseX, mouseY);
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        this.setValueFromMouse(mouseX, mouseY);
    }

    private void setValueFromMouse(double mouseX, double mouseY) {
        if (this.clicked) {
            this.setHorizontalValue((mouseX - (double)(this.method_46426() + 8)) / (double)(this.field_22758 - 13 - 2), true);
            this.setVerticalValue((mouseY - (double)(this.method_46427() + 8)) / (double)(this.field_22759 - 13 - 2), true);
        }
    }

    private void setHorizontalValue(double horizontalValue, boolean snapValue) {
        double oldHorizontalValue = this.horizontalValue;
        if (!this.horizontalValueLocked()) {
            this.horizontalValue = class_3532.method_15350((double)horizontalValue, (double)0.0, (double)1.0);
            if (snapValue) {
                this.horizontalValue = ArmorStandPose.snapValue(this.horizontalValue, 0.125);
            }
        }
        if (oldHorizontalValue != this.horizontalValue) {
            this.applyValue();
        }
    }

    private void setVerticalValue(double verticalValue, boolean snapValue) {
        double oldVerticalValue = this.verticalValue;
        if (!this.verticalValueLocked()) {
            this.verticalValue = class_3532.method_15350((double)verticalValue, (double)0.0, (double)1.0);
            if (snapValue) {
                this.verticalValue = ArmorStandPose.snapValue(this.verticalValue, 0.125);
            }
        }
        if (oldVerticalValue != this.verticalValue) {
            this.applyValue();
        }
    }

    protected boolean verticalValueLocked() {
        return class_437.method_25442();
    }

    protected boolean horizontalValueLocked() {
        return class_437.method_25443();
    }

    public void method_25354(class_1144 handler) {
    }

    public void method_25357(double mouseX, double mouseY) {
        this.clicked = false;
        super.method_25354(class_310.method_1551().method_1483());
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22763 && this.field_22764) {
            switch (keyCode) {
                case 263: {
                    this.setHorizontalValue(this.horizontalValue - 0.035, false);
                    return true;
                }
                case 262: {
                    this.setHorizontalValue(this.horizontalValue + 0.035, false);
                    return true;
                }
                case 265: {
                    this.setVerticalValue(this.verticalValue - 0.035, false);
                    return true;
                }
                case 264: {
                    this.setVerticalValue(this.verticalValue + 0.035, false);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected abstract void applyValue();

    public static interface OnTooltip {
        public void onTooltip(BoxedSliderButton var1, class_4587 var2, int var3, int var4);

        default public void narrateTooltip(Consumer<class_2561> contents) {
        }
    }
}

