/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.client.gui.screens.armorstand;

import com.google.common.collect.Lists;
import fuzs.armorstatues.ArmorStatues;
import fuzs.armorstatues.api.client.gui.components.NewTextureButton;
import fuzs.armorstatues.api.client.gui.components.NewTextureSliderButton;
import fuzs.armorstatues.api.client.gui.screens.armorstand.AbstractArmorStandScreen;
import fuzs.armorstatues.api.client.gui.screens.armorstand.ArmorStandButtonsScreen;
import fuzs.armorstatues.api.client.gui.screens.armorstand.ArmorStandWidgetsScreen;
import fuzs.armorstatues.api.network.client.data.DataSyncHandler;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

public class ArmorStandPositionScreen
extends ArmorStandButtonsScreen {
    public static final String ROTATION_TRANSLATION_KEY = "statues.screen.position.rotation";
    public static final String POSITION_X_TRANSLATION_KEY = "statues.screen.position.x";
    public static final String POSITION_Y_TRANSLATION_KEY = "statues.screen.position.y";
    public static final String POSITION_Z_TRANSLATION_KEY = "statues.screen.position.z";
    public static final String INCREMENT_TRANSLATION_KEY = "statues.screen.position.increment";
    public static final String DECREMENT_TRANSLATION_KEY = "statues.screen.position.decrement";
    public static final String PIXELS_TRANSLATION_KEY = "statues.screen.position.pixels";
    public static final String BLOCKS_TRANSLATION_KEY = "statues.screen.position.blocks";
    public static final String DEGREES_TRANSLATION_KEY = "statues.screen.position.degrees";
    public static final String MOVE_BY_TRANSLATION_KEY = "statues.screen.position.moveBy";
    public static final String CENTERED_TRANSLATION_KEY = "statues.screen.centered";
    public static final String CENTERED_DESCRIPTION_TRANSLATION_KEY = "statues.screen.centered.description";
    public static final String CORNERED_TRANSLATION_KEY = "statues.screen.cornered";
    public static final String CORNERED_DESCRIPTION_TRANSLATION_KEY = "statues.screen.cornered.description";
    public static final String ALIGNED_TRANSLATION_KEY = "statues.screen.aligned";
    private static final DecimalFormat BLOCK_INCREMENT_FORMAT = (DecimalFormat)class_156.method_654((Object)new DecimalFormat("#.####"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private static final double[] INCREMENTS = new double[]{0.0625, 0.25, 0.5, 1.0};
    private static double currentIncrement = INCREMENTS[0];

    public ArmorStandPositionScreen(ArmorStandHolder holder, class_1661 inventory, class_2561 component, DataSyncHandler dataSyncHandler) {
        super(holder, inventory, component, dataSyncHandler);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
    }

    @Override
    public void method_25432() {
        super.method_25432();
    }

    @Override
    protected List<ArmorStandWidgetsScreen.ArmorStandWidget> buildWidgets(class_1531 armorStand) {
        Object[] objectArray = new ArmorStandWidgetsScreen.ArmorStandWidget[5];
        objectArray[0] = new RotationWidget((class_2561)class_2561.method_43471((String)ROTATION_TRANSLATION_KEY), () -> ((class_1531)armorStand).method_36454(), this.dataSyncHandler::sendRotation);
        objectArray[1] = new PositionIncrementWidget();
        objectArray[2] = new PositionComponentWidget(POSITION_X_TRANSLATION_KEY, () -> ((class_1531)armorStand).method_23317(), x -> this.dataSyncHandler.sendPosition(x, armorStand.method_23318(), armorStand.method_23321()));
        objectArray[3] = new PositionComponentWidget(POSITION_Y_TRANSLATION_KEY, () -> ((class_1531)armorStand).method_23318(), y -> this.dataSyncHandler.sendPosition(armorStand.method_23317(), y, armorStand.method_23321()));
        objectArray[4] = new PositionComponentWidget(POSITION_Z_TRANSLATION_KEY, () -> ((class_1531)armorStand).method_23321(), z -> this.dataSyncHandler.sendPosition(armorStand.method_23317(), armorStand.method_23318(), z));
        return Lists.newArrayList((Object[])objectArray);
    }

    @Override
    public ArmorStandScreenType getScreenType() {
        return ArmorStandScreenType.POSITION;
    }

    private static class_2561 getPixelIncrementComponent(double increment) {
        return class_2561.method_43469((String)PIXELS_TRANSLATION_KEY, (Object[])new Object[]{ArmorStandPositionScreen.getBlockPixelIncrement(increment)});
    }

    private static class_2561 getBlockIncrementComponent(double increment) {
        return class_2561.method_43469((String)BLOCKS_TRANSLATION_KEY, (Object[])new Object[]{BLOCK_INCREMENT_FORMAT.format(increment)});
    }

    private static int getBlockPixelIncrement(double increment) {
        return (int)Math.round(increment * 16.0);
    }

    protected class RotationWidget
    extends ArmorStandWidgetsScreen.AbstractArmorStandWidget {
        protected final DoubleSupplier currentValue;
        protected final Consumer<Float> newValue;
        private final double snapInterval;
        @Nullable
        private Runnable reset;

        public RotationWidget(class_2561 title, DoubleSupplier currentValue, Consumer<Float> newValue) {
            this(title, currentValue, newValue, 0.125);
        }

        public RotationWidget(class_2561 title, DoubleSupplier currentValue, Consumer<Float> newValue, double snapInterval) {
            super(ArmorStandPositionScreen.this, title);
            this.currentValue = currentValue;
            this.newValue = newValue;
            this.snapInterval = snapInterval;
        }

        protected double getCurrentValue() {
            return RotationWidget.fromWrappedDegrees(this.currentValue.getAsDouble());
        }

        protected void setNewValue(double newValue) {
            this.newValue.accept(Float.valueOf(RotationWidget.toWrappedDegrees(newValue)));
        }

        protected class_2561 getTooltipComponent(double mouseValue) {
            return class_2561.method_43469((String)ArmorStandPositionScreen.DEGREES_TRANSLATION_KEY, (Object[])new Object[]{ArmorStandPose.ROTATION_FORMAT.format(RotationWidget.toWrappedDegrees(mouseValue))});
        }

        protected static double fromWrappedDegrees(double value) {
            return (class_3532.method_15338((double)value) + 180.0) / 360.0;
        }

        protected static float toWrappedDegrees(double value) {
            return (float)class_3532.method_15338((double)(value * 360.0 - 180.0));
        }

        protected void applyClientValue(double newValue) {
        }

        @Override
        public void reset() {
            if (this.reset != null) {
                this.reset.run();
            }
        }

        @Override
        public void init(int posX, int posY) {
            super.init(posX, posY);
            var sliderButton = ArmorStandPositionScreen.this.method_37063((class_364)new NewTextureSliderButton(posX + 76, posY + 1, 90, 20, 0, 184, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), class_5244.field_39003, this.getCurrentValue(), (button, poseStack, mouseX, mouseY) -> {
                double mouseValue = ArmorStandPose.snapValue((double)(mouseX - button.method_46426()) / (double)button.method_25368(), this.snapInterval);
                ArmorStandPositionScreen.this.method_25424(poseStack, this.getTooltipComponent(mouseValue), mouseX, mouseY);
            }){
                private boolean dirty;

                protected void method_25346() {
                }

                public void reset() {
                    this.field_22753 = RotationWidget.this.getCurrentValue();
                }

                protected void method_25344() {
                    this.dirty = true;
                    RotationWidget.this.applyClientValue(this.field_22753);
                }

                public void method_25357(double mouseX, double mouseY) {
                    super.method_25357(mouseX, mouseY);
                    this.clearDirty();
                }

                @Override
                public boolean isDirty() {
                    return this.dirty;
                }

                @Override
                public void clearDirty() {
                    if (this.isDirty()) {
                        this.dirty = false;
                        RotationWidget.this.setNewValue(this.field_22753);
                    }
                }
            });
            sliderButton.snapInterval = this.snapInterval;
            this.reset = sliderButton::reset;
            this.children.add(sliderButton);
            this.children.add((class_339)ArmorStandPositionScreen.this.method_37063((class_364)new class_344(posX + 174, posY + 1, 20, 20, 236, 64, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), button -> ArmorStandPositionScreen.this.setActiveWidget(this))));
        }
    }

    private class PositionIncrementWidget
    extends ArmorStandWidgetsScreen.AbstractArmorStandWidget {
        public PositionIncrementWidget() {
            super(ArmorStandPositionScreen.this, (class_2561)class_2561.method_43471((String)ArmorStandPositionScreen.MOVE_BY_TRANSLATION_KEY));
        }

        @Override
        public void init(int posX, int posY) {
            super.init(posX, posY);
            for (int i = 0; i < INCREMENTS.length; ++i) {
                double increment = INCREMENTS[i];
                class_339 widget = (class_339)ArmorStandPositionScreen.this.method_37063((class_364)new NewTextureButton(posX + 76 + i * 24 + (i > 1 ? 1 : 0), posY + 1, 20, 20, 0, 184, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), (class_2561)class_2561.method_43470((String)String.valueOf(ArmorStandPositionScreen.getBlockPixelIncrement(increment))), button -> this.setActiveIncrement((class_339)button, increment), component -> class_2561.method_43470((String)"test")));
                this.children.add(widget);
                if (increment != currentIncrement) continue;
                widget.field_22763 = false;
            }
            this.children.add((class_339)ArmorStandPositionScreen.this.method_37063((class_364)new class_344(posX + 174, posY + 1, 20, 20, 236, 64, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), button -> ArmorStandPositionScreen.this.setActiveWidget(this))));
        }

        private void setActiveIncrement(class_339 source, double increment) {
            currentIncrement = increment;
            for (class_339 widget : this.children) {
                widget.field_22763 = widget != source;
            }
        }

        @Override
        public boolean alwaysVisible(@Nullable ArmorStandWidgetsScreen.ArmorStandWidget activeWidget) {
            return !(activeWidget instanceof RotationWidget);
        }
    }

    private class PositionComponentWidget
    extends ArmorStandWidgetsScreen.AbstractArmorStandWidget {
        private final DoubleSupplier currentValue;
        private final DoubleConsumer newValue;
        private class_342 editBox;
        private int ticks;

        public PositionComponentWidget(String translationKey, DoubleSupplier currentValue, DoubleConsumer newValue) {
            super(ArmorStandPositionScreen.this, (class_2561)class_2561.method_43471((String)translationKey));
            this.currentValue = currentValue;
            this.newValue = newValue;
        }

        @Override
        public void tick() {
            super.tick();
            if (this.ticks > 0) {
                --this.ticks;
            }
            if (this.ticks == 0 && this.editBox != null) {
                this.ticks = 10;
                this.editBox.method_1852(BLOCK_INCREMENT_FORMAT.format(this.getPositionValue()));
            }
        }

        @Override
        public void init(int posX, int posY) {
            super.init(posX, posY);
            this.editBox = new class_342(ArmorStandPositionScreen.this.field_22793, posX + 77, posY, 66, 22, class_1299.field_6131.method_5897());
            this.editBox.method_1880(50);
            this.editBox.method_1888(false);
            this.editBox.method_1860(0xE0E0E0);
            this.editBox.method_1852(BLOCK_INCREMENT_FORMAT.format(this.getPositionValue()));
            this.children.add(this.editBox);
            this.children.add((class_339)ArmorStandPositionScreen.this.method_37063((class_364)new class_344(posX + 149, posY + 1, 20, 10, 196, 64, 20, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), 256, 256, button -> this.setPositionValue(this.getPositionValue() + currentIncrement))));
            this.children.add((class_339)ArmorStandPositionScreen.this.method_37063((class_364)new class_344(posX + 149, posY + 11, 20, 10, 216, 74, 20, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), 256, 256, button -> this.setPositionValue(this.getPositionValue() - currentIncrement))));
            this.children.add((class_339)ArmorStandPositionScreen.this.method_37063((class_364)new class_344(posX + 174, posY + 1, 20, 20, 236, 64, AbstractArmorStandScreen.getArmorStandWidgetsLocation(), button -> ArmorStandPositionScreen.this.setActiveWidget(this))));
        }

        private double getPositionValue() {
            return ArmorStatues.round((double)Math.round(this.currentValue.getAsDouble() * 16.0) / 16.0, 4);
        }

        private void setPositionValue(double newValue) {
            this.ticks = 20;
            newValue = (double)Math.round(newValue * 16.0) / 16.0;
            if (this.getPositionValue() != newValue) {
                this.editBox.method_1852(BLOCK_INCREMENT_FORMAT.format(newValue));
                this.newValue.accept(newValue);
            }
        }

        @Override
        public void render(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
            super.render(poseStack, mouseX, mouseY, partialTick);
            this.editBox.method_25394(poseStack, mouseX, mouseY, partialTick);
        }

        @Override
        public boolean alwaysVisible(@Nullable ArmorStandWidgetsScreen.ArmorStandWidget activeWidget) {
            return activeWidget instanceof PositionIncrementWidget || super.alwaysVisible(activeWidget);
        }
    }
}

