/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.network.client.data;

import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandAlignment;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandStyleOption;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandStyleOptions;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import net.minecraft.class_155;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public interface DataSyncHandler {
    public ArmorStandHolder getArmorStandHolder();

    default public class_1531 getArmorStand() {
        return this.getArmorStandHolder().getArmorStand();
    }

    public void sendName(String var1);

    public void sendPose(ArmorStandPose var1);

    default public void sendPose(ArmorStandPose pose, boolean finalize) {
        this.sendPose(pose);
    }

    @Nullable
    default public ArmorStandPose getLastSyncedPose() {
        return null;
    }

    public void sendPosition(double var1, double var3, double var5);

    default public void sendPosition(double posX, double posY, double posZ, boolean finalize) {
        this.sendPosition(posX, posY, posZ);
    }

    public void sendRotation(float var1);

    default public void sendRotation(float rotation, boolean finalize) {
        this.sendRotation(rotation);
    }

    public void sendStyleOption(ArmorStandStyleOption var1, boolean var2);

    default public void sendStyleOption(ArmorStandStyleOption styleOption, boolean value, boolean finalize) {
        this.sendStyleOption(styleOption, value);
    }

    default public void sendAlignment(ArmorStandAlignment alignment) {
        if (!this.getArmorStand().method_5767()) {
            this.sendStyleOption(ArmorStandStyleOptions.INVISIBLE, true, false);
        }
        if (!this.getArmorStand().method_5740()) {
            this.sendStyleOption(ArmorStandStyleOptions.NO_GRAVITY, true, false);
        }
        this.sendPose(alignment.getPose(), false);
        class_243 alignmentOffset = alignment.getAlignmentOffset(this.getArmorStand().method_6914());
        class_243 newPosition = DataSyncHandler.getLocalPosition((class_1297)this.getArmorStand(), alignmentOffset);
        this.sendPosition(newPosition.method_10216(), newPosition.method_10214(), newPosition.method_10215(), false);
        this.finalizeCurrentOperation();
    }

    private static class_243 getLocalPosition(class_1297 entity, class_243 offset) {
        class_241 vec2 = entity.method_5802();
        class_243 vec3 = entity.method_19538();
        float f = class_3532.method_15362((float)((vec2.field_1342 + 90.0f) * ((float)Math.PI / 180)));
        float g = class_3532.method_15374((float)((vec2.field_1342 + 90.0f) * ((float)Math.PI / 180)));
        float h = class_3532.method_15362((float)(-vec2.field_1343 * ((float)Math.PI / 180)));
        float i = class_3532.method_15374((float)(-vec2.field_1343 * ((float)Math.PI / 180)));
        float j = class_3532.method_15362((float)((-vec2.field_1343 + 90.0f) * ((float)Math.PI / 180)));
        float k = class_3532.method_15374((float)((-vec2.field_1343 + 90.0f) * ((float)Math.PI / 180)));
        class_243 vec32 = new class_243((double)(f * h), (double)i, (double)(g * h));
        class_243 vec33 = new class_243((double)(f * j), (double)k, (double)(g * j));
        class_243 vec34 = vec32.method_1036(vec33).method_1021(-1.0);
        double d = vec32.field_1352 * offset.method_10215() + vec33.field_1352 * offset.method_10214() + vec34.field_1352 * offset.method_10216();
        double e = vec32.field_1351 * offset.method_10215() + vec33.field_1351 * offset.method_10214() + vec34.field_1351 * offset.method_10216();
        double l = vec32.field_1350 * offset.method_10215() + vec33.field_1350 * offset.method_10214() + vec34.field_1350 * offset.method_10216();
        return new class_243(vec3.field_1352 + d, vec3.field_1351 + e, vec3.field_1350 + l);
    }

    default public ArmorStandScreenType[] getScreenTypes() {
        return (ArmorStandScreenType[])Stream.of(this.getArmorStandHolder().getDataProvider().getScreenTypes()).filter(this::supportsScreenType).toArray(ArmorStandScreenType[]::new);
    }

    default public boolean supportsScreenType(ArmorStandScreenType screenType) {
        return true;
    }

    default public void tick() {
    }

    default public boolean shouldContinueTicking() {
        return false;
    }

    default public void finalizeCurrentOperation() {
    }

    public static void setCustomArmorStandName(class_1531 armorStand, String name) {
        if ((name = class_155.method_644((String)name)).length() <= 50) {
            boolean remove = name.isBlank() || name.equals(class_1299.field_6131.method_5897().getString());
            armorStand.method_5665((class_2561)(remove ? null : class_2561.method_43470((String)name)));
        }
    }
}

