/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.world.inventory.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Objects;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public interface ArmorStandStyleOption {
    public static final BiMap<class_2960, ArmorStandStyleOption> OPTIONS_REGISTRY = HashBiMap.create();

    public String getName();

    default public String getTranslationKey() {
        return "statues.screen.style." + this.getName();
    }

    default public String getDescriptionKey() {
        return this.getTranslationKey() + ".description";
    }

    public void setOption(class_1531 var1, boolean var2);

    public boolean getOption(class_1531 var1);

    public void toTag(class_2487 var1, boolean var2);

    default public boolean allowChanges(class_1657 player) {
        return true;
    }

    default public class_2960 getId() {
        return Objects.requireNonNull((class_2960)OPTIONS_REGISTRY.inverse().get((Object)this), "Armor stand style option %s has not been registered".formatted(this.getName()));
    }

    public static void register(class_2960 id, ArmorStandStyleOption styleOption) {
        if (OPTIONS_REGISTRY.containsValue((Object)styleOption) || OPTIONS_REGISTRY.put((Object)id, (Object)styleOption) != null) {
            throw new IllegalStateException("Attempted to register duplicate armor stand style option for id %s".formatted(id));
        }
    }

    public static ArmorStandStyleOption get(class_2960 id) {
        return Objects.requireNonNull((ArmorStandStyleOption)OPTIONS_REGISTRY.get((Object)id), "No armor stand style option registered for id %s".formatted(id));
    }

    public static boolean getArmorStandData(class_1531 armorStand, int offset) {
        return ((Byte)armorStand.method_5841().method_12789(class_1531.field_7107) & offset) != 0;
    }

    public static void setArmorStandData(class_1531 armorStand, boolean setting, int offset) {
        armorStand.method_5841().method_12778(class_1531.field_7107, (Object)ArmorStandStyleOption.setBit((Byte)armorStand.method_5841().method_12789(class_1531.field_7107), offset, setting));
    }

    public static byte setBit(byte oldBit, int offset, boolean value) {
        oldBit = value ? (byte)(oldBit | offset) : (byte)(oldBit & ~offset);
        return oldBit;
    }
}

