/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.network.client.data;

import com.google.common.collect.ImmutableSortedMap;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Unit;
import fuzs.armorstatues.ArmorStatues;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandAlignment;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandStyleOption;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandStyleOptions;
import fuzs.armorstatues.config.ClientConfig;
import fuzs.armorstatues.init.ModRegistry;
import fuzs.armorstatues.network.client.data.CommandDataSyncHandler;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_2379;
import net.minecraft.class_2561;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class VanillaTweaksDataSyncHandler
extends CommandDataSyncHandler {
    private static final int MAX_INCREMENTAL_OPERATIONS = 12;
    public static final int CHECK_TARGET = 999;
    public static final int SWAP_SLOTS_MAINHAND_AND_OFFHAND = 161;
    public static final int SWAP_SLOTS_MAINHAND_AND_HEAD = 162;
    public static final int MIRROR_ARMS_LEFT_TO_RIGHT = 131;
    public static final int MIRROR_ARMS_RIGHT_TO_LEFT = 132;
    public static final int MIRROR_LEGS_LEFT_TO_RIGHT = 133;
    public static final int MIRROR_LEGS_RIGHT_TO_LEFT = 134;
    public static final int UTILITIES_LOCK = 1000;
    public static final int UTILITIES_UNLOCK = 1001;
    public static final int MIRROR_AND_FLIP_FLIP = 135;
    public static final int SHOW_BASE_PLATE_YES = 1;
    public static final int SHOW_BASE_PLATE_NO = 2;
    public static final int SHOW_ARMS_YES = 3;
    public static final int SHOW_ARMS_NO = 4;
    public static final int SMALL_STAND_YES = 5;
    public static final int SMALL_STAND_NO = 6;
    public static final int APPLY_GRAVITY_YES = 7;
    public static final int APPLY_GRAVITY_NO = 8;
    public static final int STAND_VISIBLE_YES = 9;
    public static final int STAND_VISIBLE_NO = 10;
    public static final int DISPLAY_NAME_YES = 11;
    public static final int DISPLAY_NAME_NO = 12;
    public static final int NUDGE_POSITION_X8_NEGATIVE = 40;
    public static final int NUDGE_POSITION_X3_NEGATIVE = 101;
    public static final int NUDGE_POSITION_X1_NEGATIVE = 102;
    public static final int NUDGE_POSITION_X1_POSITIVE = 103;
    public static final int NUDGE_POSITION_X3_POSITIVE = 104;
    public static final int NUDGE_POSITION_X8_POSITIVE = 43;
    public static final int NUDGE_POSITION_Y8_NEGATIVE = 44;
    public static final int NUDGE_POSITION_Y3_NEGATIVE = 105;
    public static final int NUDGE_POSITION_Y1_NEGATIVE = 106;
    public static final int NUDGE_POSITION_Y1_POSITIVE = 107;
    public static final int NUDGE_POSITION_Y3_POSITIVE = 108;
    public static final int NUDGE_POSITION_Y8_POSITIVE = 47;
    public static final int NUDGE_POSITION_Z8_NEGATIVE = 48;
    public static final int NUDGE_POSITION_Z3_NEGATIVE = 109;
    public static final int NUDGE_POSITION_Z1_NEGATIVE = 110;
    public static final int NUDGE_POSITION_Z1_POSITIVE = 111;
    public static final int NUDGE_POSITION_Z3_POSITIVE = 112;
    public static final int NUDGE_POSITION_Z8_POSITIVE = 51;
    public static final int ADJUST_ROTATION_ANGLE_STEP_45 = 120;
    public static final int ADJUST_ROTATION_ANGLE_STEP_15 = 121;
    public static final int ADJUST_ROTATION_ANGLE_STEP_5 = 122;
    public static final int ADJUST_ROTATION_ANGLE_STEP_1 = 123;
    public static final int ADJUST_ROTATION_ROTATE_RIGHT = 56;
    public static final int ADJUST_ROTATION_ROTATE_LEFT = 57;
    public static final int POSE_PRESETS_ATTENTION = 20;
    public static final int POSE_PRESETS_WALKING = 21;
    public static final int POSE_PRESETS_RUNNING = 22;
    public static final int POSE_PRESETS_POINTING = 23;
    public static final int POSE_PRESETS_BLOCKING = 24;
    public static final int POSE_PRESETS_LUNGEING = 25;
    public static final int POSE_PRESETS_WINNING = 26;
    public static final int POSE_PRESETS_SITTING = 27;
    public static final int POSE_PRESETS_ARABESQUE = 28;
    public static final int POSE_PRESETS_CUPID = 29;
    public static final int POSE_PRESETS_CONFIDENT = 30;
    public static final int POSE_PRESETS_SALUTE = 31;
    public static final int POSE_PRESETS_DEATH = 32;
    public static final int POSE_PRESETS_FACEPALM = 33;
    public static final int POSE_PRESETS_LAZING = 34;
    public static final int POSE_PRESETS_CONFUSED = 35;
    public static final int POSE_PRESETS_FORMAL = 36;
    public static final int POSE_PRESETS_SAD = 37;
    public static final int POSE_PRESETS_JOYOUS = 38;
    public static final int POSE_PRESETS_STARGAZING = 39;
    public static final int AUTO_ALIGNMENT_BLOCK_ON_SURFACE = 151;
    public static final int AUTO_ALIGNMENT_ITEM_ON_SURFACE = 152;
    public static final int AUTO_ALIGNMENT_ITEM_FLAT_ON_SURFACE = 153;
    public static final int AUTO_ALIGNMENT_TOOL_FLAT_ON_SURFACE = 154;
    public static final int AUTO_ALIGNMENT_TOOL_RACK = 155;
    public static final int POSE_ADJUSTMENT_HEAD_X_NEGATIVE = 60;
    public static final int POSE_ADJUSTMENT_HEAD_X_POSITIVE = 61;
    public static final int POSE_ADJUSTMENT_HEAD_Y_NEGATIVE = 62;
    public static final int POSE_ADJUSTMENT_HEAD_Y_POSITIVE = 63;
    public static final int POSE_ADJUSTMENT_HEAD_Z_NEGATIVE = 64;
    public static final int POSE_ADJUSTMENT_HEAD_Z_POSITIVE = 65;
    public static final int POSE_ADJUSTMENT_BODY_X_NEGATIVE = 67;
    public static final int POSE_ADJUSTMENT_BODY_X_POSITIVE = 66;
    public static final int POSE_ADJUSTMENT_BODY_Y_NEGATIVE = 68;
    public static final int POSE_ADJUSTMENT_BODY_Y_POSITIVE = 69;
    public static final int POSE_ADJUSTMENT_BODY_Z_NEGATIVE = 70;
    public static final int POSE_ADJUSTMENT_BODY_Z_POSITIVE = 71;
    public static final int POSE_ADJUSTMENT_RIGHT_ARM_X_NEGATIVE = 72;
    public static final int POSE_ADJUSTMENT_RIGHT_ARM_X_POSITIVE = 73;
    public static final int POSE_ADJUSTMENT_RIGHT_ARM_Y_NEGATIVE = 74;
    public static final int POSE_ADJUSTMENT_RIGHT_ARM_Y_POSITIVE = 75;
    public static final int POSE_ADJUSTMENT_RIGHT_ARM_Z_NEGATIVE = 77;
    public static final int POSE_ADJUSTMENT_RIGHT_ARM_Z_POSITIVE = 76;
    public static final int POSE_ADJUSTMENT_LEFT_ARM_X_NEGATIVE = 78;
    public static final int POSE_ADJUSTMENT_LEFT_ARM_X_POSITIVE = 79;
    public static final int POSE_ADJUSTMENT_LEFT_ARM_Y_NEGATIVE = 81;
    public static final int POSE_ADJUSTMENT_LEFT_ARM_Y_POSITIVE = 80;
    public static final int POSE_ADJUSTMENT_LEFT_ARM_Z_NEGATIVE = 82;
    public static final int POSE_ADJUSTMENT_LEFT_ARM_Z_POSITIVE = 83;
    public static final int POSE_ADJUSTMENT_RIGHT_LEG_X_NEGATIVE = 84;
    public static final int POSE_ADJUSTMENT_RIGHT_LEG_X_POSITIVE = 85;
    public static final int POSE_ADJUSTMENT_RIGHT_LEG_Y_NEGATIVE = 87;
    public static final int POSE_ADJUSTMENT_RIGHT_LEG_Y_POSITIVE = 86;
    public static final int POSE_ADJUSTMENT_RIGHT_LEG_Z_NEGATIVE = 89;
    public static final int POSE_ADJUSTMENT_RIGHT_LEG_Z_POSITIVE = 88;
    public static final int POSE_ADJUSTMENT_LEFT_LEG_X_NEGATIVE = 90;
    public static final int POSE_ADJUSTMENT_LEFT_LEG_X_POSITIVE = 91;
    public static final int POSE_ADJUSTMENT_LEFT_LEG_Y_NEGATIVE = 92;
    public static final int POSE_ADJUSTMENT_LEFT_LEG_Y_POSITIVE = 93;
    public static final int POSE_ADJUSTMENT_LEFT_LEG_Z_NEGATIVE = 94;
    public static final int POSE_ADJUSTMENT_LEFT_LEG_Z_POSITIVE = 95;
    private static final int[] POSE_ADJUSTMENT_HEAD = new int[]{60, 61, 62, 63, 64, 65};
    private static final int[] POSE_ADJUSTMENT_BODY = new int[]{66, 67, 68, 69, 70, 71};
    private static final int[] POSE_ADJUSTMENT_RIGHT_ARM = new int[]{72, 73, 74, 75, 76, 77};
    private static final int[] POSE_ADJUSTMENT_LEFT_ARM = new int[]{78, 79, 80, 81, 82, 83};
    private static final int[] POSE_ADJUSTMENT_RIGHT_LEG = new int[]{84, 85, 86, 87, 88, 89};
    private static final int[] POSE_ADJUSTMENT_LEFT_LEG = new int[]{90, 91, 92, 93, 94, 95};
    private static final NavigableMap<Double, Integer> NUDGE_POSITIONS_X_NEGATIVE = ImmutableSortedMap.of((Comparable)Double.valueOf(0.0625), (Object)102, (Comparable)Double.valueOf(0.1875), (Object)101, (Comparable)Double.valueOf(0.5), (Object)40);
    private static final NavigableMap<Double, Integer> NUDGE_POSITIONS_X_POSITIVE = ImmutableSortedMap.of((Comparable)Double.valueOf(0.0625), (Object)103, (Comparable)Double.valueOf(0.1875), (Object)104, (Comparable)Double.valueOf(0.5), (Object)43);
    private static final NavigableMap<Double, Integer> NUDGE_POSITIONS_Y_NEGATIVE = ImmutableSortedMap.of((Comparable)Double.valueOf(0.0625), (Object)106, (Comparable)Double.valueOf(0.1875), (Object)105, (Comparable)Double.valueOf(0.5), (Object)44);
    private static final NavigableMap<Double, Integer> NUDGE_POSITIONS_Y_POSITIVE = ImmutableSortedMap.of((Comparable)Double.valueOf(0.0625), (Object)107, (Comparable)Double.valueOf(0.1875), (Object)108, (Comparable)Double.valueOf(0.5), (Object)47);
    private static final NavigableMap<Double, Integer> NUDGE_POSITIONS_Z_NEGATIVE = ImmutableSortedMap.of((Comparable)Double.valueOf(0.0625), (Object)110, (Comparable)Double.valueOf(0.1875), (Object)109, (Comparable)Double.valueOf(0.5), (Object)48);
    private static final NavigableMap<Double, Integer> NUDGE_POSITIONS_Z_POSITIVE = ImmutableSortedMap.of((Comparable)Double.valueOf(0.0625), (Object)111, (Comparable)Double.valueOf(0.1875), (Object)112, (Comparable)Double.valueOf(0.5), (Object)51);
    private static final NavigableMap<Float, Integer> ADJUST_ROTATION_ANGLE_STEPS = ImmutableSortedMap.of((Comparable)Float.valueOf(1.0f), (Object)123, (Comparable)Float.valueOf(5.0f), (Object)122, (Comparable)Float.valueOf(15.0f), (Object)121, (Comparable)Float.valueOf(45.0f), (Object)120);

    public VanillaTweaksDataSyncHandler(ArmorStandHolder holder, class_746 player) {
        super(holder, player);
    }

    @Override
    public void sendPose(ArmorStandPose pose, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        int triggerValue = this.getTriggerValueFromPose(pose);
        if (triggerValue != -1) {
            if (this.enqueueTriggerValue(triggerValue)) {
                this.lastSyncedPose = pose.copyAndFillFrom(this.lastSyncedPose);
                pose.applyToEntity(this.getArmorStand());
            }
        } else {
            this.tryApplyAllPoseParts(pose);
        }
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    private int getTriggerValueFromPose(ArmorStandPose pose) {
        if (pose.getSourceType() == ArmorStandPose.SourceType.EMPTY) {
            return 20;
        }
        if (pose.getSourceType() == ArmorStandPose.SourceType.MIRRORED) {
            return 135;
        }
        if (pose.getSourceType() != ArmorStandPose.SourceType.VANILLA_TWEAKS) {
            return -1;
        }
        if (pose == ArmorStandPose.WALKING) {
            return 21;
        }
        if (pose == ArmorStandPose.RUNNING) {
            return 22;
        }
        if (pose == ArmorStandPose.POINTING) {
            return 23;
        }
        if (pose == ArmorStandPose.BLOCKING) {
            return 24;
        }
        if (pose == ArmorStandPose.LUNGEING) {
            return 25;
        }
        if (pose == ArmorStandPose.WINNING) {
            return 26;
        }
        if (pose == ArmorStandPose.SITTING) {
            return 27;
        }
        if (pose == ArmorStandPose.ARABESQUE) {
            return 28;
        }
        if (pose == ArmorStandPose.CUPID) {
            return 29;
        }
        if (pose == ArmorStandPose.CONFIDENT) {
            return 30;
        }
        if (pose == ArmorStandPose.SALUTE) {
            return 31;
        }
        if (pose == ArmorStandPose.DEATH) {
            return 32;
        }
        if (pose == ArmorStandPose.FACEPALM) {
            return 33;
        }
        if (pose == ArmorStandPose.LAZING) {
            return 34;
        }
        if (pose == ArmorStandPose.CONFUSED) {
            return 35;
        }
        if (pose == ArmorStandPose.FORMAL) {
            return 36;
        }
        if (pose == ArmorStandPose.SAD) {
            return 37;
        }
        if (pose == ArmorStandPose.JOYOUS) {
            return 38;
        }
        if (pose == ArmorStandPose.STARGAZING) {
            return 39;
        }
        return -1;
    }

    private void tryApplyAllPoseParts(ArmorStandPose pose) {
        if (!this.tryApplyPosePart(this.lastSyncedPose.getHeadPose(), pose.getNullableHeadPose(), POSE_ADJUSTMENT_HEAD, this.lastSyncedPose::withHeadPose)) {
            return;
        }
        if (!this.tryApplyPosePart(this.lastSyncedPose.getBodyPose(), pose.getNullableBodyPose(), POSE_ADJUSTMENT_BODY, this.lastSyncedPose::withBodyPose)) {
            return;
        }
        if (!this.tryApplyPosePart(this.lastSyncedPose.getRightArmPose(), pose.getNullableRightArmPose(), POSE_ADJUSTMENT_RIGHT_ARM, this.lastSyncedPose::withRightArmPose)) {
            return;
        }
        if (!this.tryApplyPosePart(this.lastSyncedPose.getLeftArmPose(), pose.getNullableLeftArmPose(), POSE_ADJUSTMENT_LEFT_ARM, this.lastSyncedPose::withLeftArmPose)) {
            return;
        }
        if (!this.tryApplyPosePart(this.lastSyncedPose.getRightLegPose(), pose.getNullableRightLegPose(), POSE_ADJUSTMENT_RIGHT_LEG, this.lastSyncedPose::withRightLegPose)) {
            return;
        }
        if (!this.tryApplyPosePart(this.lastSyncedPose.getLeftLegPose(), pose.getNullableLeftLegPose(), POSE_ADJUSTMENT_LEFT_LEG, this.lastSyncedPose::withLeftLegPose)) {
            return;
        }
    }

    private boolean tryApplyPosePart(class_2379 oldPose, @Nullable class_2379 newPose, int[] poseAdjustment, Function<class_2379, ArmorStandPose> function) {
        if (this.tryApplyPoseAdjustment(oldPose, newPose, poseAdjustment)) {
            this.lastSyncedPose = function.apply(newPose != null ? newPose : oldPose);
            return true;
        }
        return false;
    }

    private boolean tryApplyPoseAdjustment(class_2379 oldPose, @Nullable class_2379 newPose, int[] poseAdjustment) {
        if (newPose == null || oldPose.equals((Object)newPose)) {
            return true;
        }
        if (!this.applyIncrementsFromSteps(oldPose.method_10256(), newPose.method_10256(), poseAdjustment[0], poseAdjustment[1])) {
            return false;
        }
        if (!this.applyIncrementsFromSteps(oldPose.method_10257(), newPose.method_10257(), poseAdjustment[2], poseAdjustment[3])) {
            return false;
        }
        return this.applyIncrementsFromSteps(oldPose.method_10258(), newPose.method_10258(), poseAdjustment[4], poseAdjustment[5]);
    }

    @Override
    public void sendPosition(double posX, double posY, double posZ, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        this.applyPositionIncrements(this.getArmorStand().method_23317(), posX, NUDGE_POSITIONS_X_POSITIVE, NUDGE_POSITIONS_X_NEGATIVE);
        this.applyPositionIncrements(this.getArmorStand().method_23318(), posY, NUDGE_POSITIONS_Y_POSITIVE, NUDGE_POSITIONS_Y_NEGATIVE);
        this.applyPositionIncrements(this.getArmorStand().method_23321(), posZ, NUDGE_POSITIONS_Z_POSITIVE, NUDGE_POSITIONS_Z_NEGATIVE);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    private void applyPositionIncrements(double oldValue, double newValue, NavigableMap<Double, Integer> positiveNudgePositions, NavigableMap<Double, Integer> negativeNudgePositions) {
        Map.Entry<Double, Integer> entry;
        double value = newValue - oldValue;
        double signum = Math.signum(value);
        value = Math.abs(value);
        for (int i = 0; i < 12 && (entry = (signum == -1.0 ? negativeNudgePositions : positiveNudgePositions).floorEntry(value)) != null; ++i) {
            value -= entry.getKey().doubleValue();
            if (this.enqueueTriggerValue(entry.getValue())) continue;
            return;
        }
    }

    @Override
    public void sendRotation(float rotation, boolean finalize) {
        if (!this.isEditingAllowed()) {
            return;
        }
        this.applyIncrementsFromSteps(this.getArmorStand().method_36454(), rotation, 56, 57);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
    }

    private boolean applyIncrementsFromSteps(float oldValue, float newValue, int triggerValueNegative, int triggerValuePositive) {
        Map.Entry<Float, Integer> entry;
        float value = newValue - oldValue;
        float signum = Math.signum(value);
        value = Math.abs(value);
        float lastIncrement = 0.0f;
        for (int i = 0; i < 12 && (entry = ADJUST_ROTATION_ANGLE_STEPS.floorEntry(Float.valueOf(value))) != null; ++i) {
            float currentIncrement = entry.getKey().floatValue();
            value -= currentIncrement;
            if (currentIncrement != lastIncrement) {
                lastIncrement = currentIncrement;
                if (!this.enqueueTriggerValue(entry.getValue())) {
                    return false;
                }
            }
            if (this.enqueueTriggerValue(signum == -1.0f ? triggerValuePositive : triggerValueNegative)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void sendStyleOption(ArmorStandStyleOption styleOption, boolean value, boolean finalize) {
        int triggerValue;
        if (!this.isEditingAllowed()) {
            return;
        }
        if (styleOption == ArmorStandStyleOptions.SHOW_NAME) {
            triggerValue = value ? 11 : 12;
        } else if (styleOption == ArmorStandStyleOptions.SHOW_ARMS) {
            triggerValue = value ? 3 : 4;
        } else if (styleOption == ArmorStandStyleOptions.SMALL) {
            triggerValue = value ? 5 : 6;
        } else if (styleOption == ArmorStandStyleOptions.INVISIBLE) {
            triggerValue = value ? 10 : 9;
        } else if (styleOption == ArmorStandStyleOptions.NO_BASE_PLATE) {
            triggerValue = value ? 2 : 1;
        } else if (styleOption == ArmorStandStyleOptions.NO_GRAVITY) {
            triggerValue = value ? 8 : 7;
        } else {
            super.sendStyleOption(styleOption, value, finalize);
            return;
        }
        if (this.sendSingleTriggerValue(triggerValue, finalize)) {
            styleOption.setOption(this.getArmorStand(), value);
        }
    }

    @Override
    public void sendAlignment(ArmorStandAlignment alignment) {
        if (!this.isEditingAllowed()) {
            return;
        }
        int triggerValue = switch (alignment) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorStandAlignment.BLOCK -> 151;
            case ArmorStandAlignment.FLOATING_ITEM -> 152;
            case ArmorStandAlignment.FLAT_ITEM -> 153;
            case ArmorStandAlignment.TOOL -> 154;
        };
        this.sendSingleTriggerValue(triggerValue, true);
    }

    public void sendSingleTriggerValue(int triggerValue) {
        if (!this.isEditingAllowed()) {
            return;
        }
        this.sendSingleTriggerValue(triggerValue, true);
    }

    private boolean sendSingleTriggerValue(int triggerValue, boolean finalize) {
        boolean result = this.enqueueTriggerValue(triggerValue);
        if (finalize) {
            this.finalizeCurrentOperation();
        }
        return result;
    }

    @Override
    public ArmorStandScreenType[] getScreenTypes() {
        return (ArmorStandScreenType[])Stream.concat(Stream.of(super.getScreenTypes()), Stream.of(ModRegistry.VANILLA_TWEAKS_SCREEN_TYPE)).toArray(ArmorStandScreenType[]::new);
    }

    @Override
    protected boolean isEditingAllowed() {
        return this.isEditingAllowed(false);
    }

    @Override
    protected Either<class_2561, Unit> testArmorStand(class_1531 armorStand) {
        return ((Optional)super.testArmorStand(armorStand).map(Optional::of, $ -> {
            if (this.player.method_5858((class_1297)armorStand) < 9.0) {
                return Optional.empty();
            }
            return Optional.of(class_2561.method_43471((String)"armorstatues.dataSync.failure.outOfRange"));
        })).map(Either::left).orElse(Either.right((Object)Unit.INSTANCE));
    }

    @Override
    protected int getDequeueDelayTicks() {
        return ((ClientConfig)ArmorStatues.CONFIG.get(ClientConfig.class)).clientCommandDelay;
    }

    private boolean enqueueTriggerValue(int triggerValue) {
        return this.enqueueClientCommand("trigger as_trigger set %s".formatted(triggerValue));
    }
}

