/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend.sodium;

import fionathemortal.betterbiomeblend.common.Color;
import fionathemortal.betterbiomeblend.common.ColorBlendBuffer;
import fionathemortal.betterbiomeblend.common.Random;
import fionathemortal.betterbiomeblend.common.debug.Debug;
import fionathemortal.betterbiomeblend.common.debug.DebugEvent;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_4543;
import net.minecraft.class_6539;
import net.minecraft.class_6880;

public final class SodiumColorBlending {
    public static final int SECTION_SIZE_LOG2 = 2;
    public static final int SECTION_SIZE = 4;
    public static final int SECTION_MASK = 3;
    public static final int SECTION_OFFSET = 2;
    public static final int BLEND_BUFFER_DIM = 11;
    public static final int SAMPLE_SEED_X = 1664525;
    public static final int SAMPLE_SEED_Y = 214013;
    public static final int SAMPLE_SEED_Z = 16807;
    public static final ReentrantLock freeBlendBuffersLock = new ReentrantLock();
    public static final Stack<ColorBlendBuffer> freeBlendBuffers = new Stack();

    public static int getCacheArrayIndex(int dim, int x, int y, int z) {
        int result = x + z * dim + y * dim * dim;
        return result;
    }

    public static ColorBlendBuffer acquireBlendBuffer() {
        ColorBlendBuffer result = null;
        freeBlendBuffersLock.lock();
        if (!freeBlendBuffers.empty()) {
            ColorBlendBuffer buffer;
            result = buffer = freeBlendBuffers.pop();
        }
        freeBlendBuffersLock.unlock();
        if (result == null) {
            result = new ColorBlendBuffer();
        }
        return result;
    }

    public static void releaseBlendBuffer(ColorBlendBuffer cache) {
        freeBlendBuffersLock.lock();
        freeBlendBuffers.push(cache);
        freeBlendBuffersLock.unlock();
    }

    public static int getRandomSamplePosition(int section, int seed) {
        int random = Random.noise(section, seed);
        int offset = random & 3;
        int result = 2 + (section << 2) + offset;
        return result;
    }

    public static class_1959 getBiomeAtPosition(class_4543 world, class_2338 blockPosition) {
        class_6880 biomeHolder = world.method_22393(blockPosition);
        class_1959 result = null;
        if (biomeHolder.method_40227()) {
            result = (class_1959)biomeHolder.comp_349();
        }
        return result;
    }

    public static void gatherRawColorsToCaches(class_4543 biomeManager, class_6539 colorResolver, int chunkX, int chunkY, int chunkZ, float[] blendBuffer) {
        int sectionBaseX = 4 * (chunkX - 1);
        int sectionBaseY = 4 * (chunkY - 1);
        int sectionBaseZ = 4 * (chunkZ - 1);
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        for (int y = 0; y < 11; ++y) {
            for (int z = 0; z < 11; ++z) {
                for (int x = 0; x < 11; ++x) {
                    int blendIndex = SodiumColorBlending.getCacheArrayIndex(11, x, y, z);
                    int sectionX = sectionBaseX + x;
                    int sectionY = sectionBaseY + y;
                    int sectionZ = sectionBaseZ + z;
                    int sampleX = SodiumColorBlending.getRandomSamplePosition(sectionX, 1664525);
                    int sampleY = SodiumColorBlending.getRandomSamplePosition(sectionY, 214013);
                    int sampleZ = SodiumColorBlending.getRandomSamplePosition(sectionZ, 16807);
                    blockPos.method_10103(sampleX, sampleY, sampleZ);
                    int color = 0;
                    class_1959 biome = SodiumColorBlending.getBiomeAtPosition(biomeManager, (class_2338)blockPos);
                    if (biome != null) {
                        double blockXF64 = sampleX;
                        double blockZF64 = sampleZ;
                        color = colorResolver.getColor(biome, blockXF64, blockZF64);
                    }
                    int cachedR = Color.RGBAGetR(color);
                    int cachedG = Color.RGBAGetG(color);
                    int cachedB = Color.RGBAGetB(color);
                    blendBuffer[3 * blendIndex + 0] = Color.sRGBByteToLinearFloat((byte)cachedR);
                    blendBuffer[3 * blendIndex + 1] = Color.sRGBByteToLinearFloat((byte)cachedG);
                    blendBuffer[3 * blendIndex + 2] = Color.sRGBByteToLinearFloat((byte)cachedB);
                }
            }
        }
    }

    public static void blendColorsForChunk(byte[] result, float[] colors) {
        int x;
        int outIndex;
        float delB;
        float delG;
        float delR;
        int addIndex;
        int delIndex;
        int blendIndex;
        float accumulatedB;
        float accumulatedG;
        float accumulatedR;
        int y;
        int BLEND_RADIUS = 3;
        int BLEND_DIM = 2 * BLEND_RADIUS + 1;
        int BLEND_COUNT = BLEND_DIM * BLEND_DIM * BLEND_DIM;
        int BLEND_COLOR_CHUNK_DIM = 5;
        for (y = 0; y < 11; ++y) {
            for (int z = 0; z < 11; ++z) {
                int x2;
                accumulatedR = 0.0f;
                accumulatedG = 0.0f;
                accumulatedB = 0.0f;
                for (x2 = 0; x2 < BLEND_DIM; ++x2) {
                    blendIndex = SodiumColorBlending.getCacheArrayIndex(11, x2, y, z);
                    accumulatedR += colors[3 * blendIndex + 0];
                    accumulatedG += colors[3 * blendIndex + 1];
                    accumulatedB += colors[3 * blendIndex + 2];
                }
                for (x2 = 0; x2 < BLEND_COLOR_CHUNK_DIM; ++x2) {
                    delIndex = SodiumColorBlending.getCacheArrayIndex(11, x2, y, z);
                    addIndex = SodiumColorBlending.getCacheArrayIndex(11, x2 + BLEND_DIM, y, z);
                    delR = colors[3 * delIndex + 0];
                    delG = colors[3 * delIndex + 1];
                    delB = colors[3 * delIndex + 2];
                    outIndex = delIndex;
                    colors[3 * outIndex + 0] = accumulatedR;
                    colors[3 * outIndex + 1] = accumulatedG;
                    colors[3 * outIndex + 2] = accumulatedB;
                    if (x2 >= BLEND_COLOR_CHUNK_DIM - 1) continue;
                    accumulatedR -= delR;
                    accumulatedG -= delG;
                    accumulatedB -= delB;
                    accumulatedR += colors[3 * addIndex + 0];
                    accumulatedG += colors[3 * addIndex + 1];
                    accumulatedB += colors[3 * addIndex + 2];
                }
            }
        }
        for (y = 0; y < 11; ++y) {
            for (x = 0; x < BLEND_COLOR_CHUNK_DIM; ++x) {
                int z;
                accumulatedR = 0.0f;
                accumulatedG = 0.0f;
                accumulatedB = 0.0f;
                for (z = 0; z < BLEND_DIM; ++z) {
                    blendIndex = SodiumColorBlending.getCacheArrayIndex(11, x, y, z);
                    accumulatedR += colors[3 * blendIndex + 0];
                    accumulatedG += colors[3 * blendIndex + 1];
                    accumulatedB += colors[3 * blendIndex + 2];
                }
                for (z = 0; z < BLEND_COLOR_CHUNK_DIM; ++z) {
                    delIndex = SodiumColorBlending.getCacheArrayIndex(11, x, y, z);
                    addIndex = SodiumColorBlending.getCacheArrayIndex(11, x, y, z + BLEND_DIM);
                    delR = colors[3 * delIndex + 0];
                    delG = colors[3 * delIndex + 1];
                    delB = colors[3 * delIndex + 2];
                    outIndex = delIndex;
                    colors[3 * outIndex + 0] = accumulatedR;
                    colors[3 * outIndex + 1] = accumulatedG;
                    colors[3 * outIndex + 2] = accumulatedB;
                    if (z >= BLEND_COLOR_CHUNK_DIM - 1) continue;
                    accumulatedR -= delR;
                    accumulatedG -= delG;
                    accumulatedB -= delB;
                    accumulatedR += colors[3 * addIndex + 0];
                    accumulatedG += colors[3 * addIndex + 1];
                    accumulatedB += colors[3 * addIndex + 2];
                }
            }
        }
        for (int z = 0; z < BLEND_COLOR_CHUNK_DIM; ++z) {
            for (x = 0; x < BLEND_COLOR_CHUNK_DIM; ++x) {
                int y2;
                accumulatedR = 0.0f;
                accumulatedG = 0.0f;
                accumulatedB = 0.0f;
                for (y2 = 0; y2 < BLEND_DIM; ++y2) {
                    blendIndex = SodiumColorBlending.getCacheArrayIndex(11, x, y2, z);
                    accumulatedR += colors[3 * blendIndex + 0];
                    accumulatedG += colors[3 * blendIndex + 1];
                    accumulatedB += colors[3 * blendIndex + 2];
                }
                for (y2 = 0; y2 < BLEND_COLOR_CHUNK_DIM; ++y2) {
                    delIndex = SodiumColorBlending.getCacheArrayIndex(11, x, y2, z);
                    addIndex = SodiumColorBlending.getCacheArrayIndex(11, x, y2 + BLEND_DIM, z);
                    delR = colors[3 * delIndex + 0];
                    delG = colors[3 * delIndex + 1];
                    delB = colors[3 * delIndex + 2];
                    outIndex = SodiumColorBlending.getCacheArrayIndex(BLEND_COLOR_CHUNK_DIM, x, y2, z);
                    result[3 * outIndex + 0] = Color.linearFloatTosRGBByte(accumulatedR / (float)BLEND_COUNT);
                    result[3 * outIndex + 1] = Color.linearFloatTosRGBByte(accumulatedG / (float)BLEND_COUNT);
                    result[3 * outIndex + 2] = Color.linearFloatTosRGBByte(accumulatedB / (float)BLEND_COUNT);
                    if (y2 >= BLEND_COLOR_CHUNK_DIM - 1) continue;
                    accumulatedR -= delR;
                    accumulatedG -= delG;
                    accumulatedB -= delB;
                    accumulatedR += colors[3 * addIndex + 0];
                    accumulatedG += colors[3 * addIndex + 1];
                    accumulatedB += colors[3 * addIndex + 2];
                }
            }
        }
    }

    public static void generateBlendedColorChunk(class_4543 biomeManager, class_6539 colorResolverIn, int chunkX, int chunkY, int chunkZ, byte[] result) {
        ColorBlendBuffer blendBuffer = SodiumColorBlending.acquireBlendBuffer();
        boolean debugEnabled = Debug.measurePerformance;
        DebugEvent debugEvent = null;
        if (debugEnabled) {
            debugEvent = Debug.pushGenBegin(chunkX, chunkY, chunkZ, 0);
        }
        SodiumColorBlending.gatherRawColorsToCaches(biomeManager, colorResolverIn, chunkX, chunkY, chunkZ, blendBuffer.color);
        SodiumColorBlending.blendColorsForChunk(result, blendBuffer.color);
        if (debugEnabled) {
            Debug.pushGenEnd(debugEvent);
        }
        SodiumColorBlending.releaseBlendBuffer(blendBuffer);
    }
}

