/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend.sodium.mixin;

import fionathemortal.betterbiomeblend.common.Color;
import fionathemortal.betterbiomeblend.common.ColorBlending;
import fionathemortal.betterbiomeblend.sodium.SodiumColorBlending;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.biome.BlockColorCache;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4543;
import net.minecraft.class_6539;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockColorCache.class})
public class MixinBlockColorCache {
    @Unique
    private int betterbiomeblend$baseX;
    @Unique
    private int betterbiomeblend$baseY;
    @Unique
    private int betterbiomeblend$baseZ;
    @Unique
    private Reference2ReferenceOpenHashMap<class_6539, byte[]> betterbiomeblend$colors;
    @Shadow
    private WorldSlice slice;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void constructorTail(WorldSlice slice, int radius, CallbackInfo ci) {
        class_4076 pos = slice.getOrigin();
        this.betterbiomeblend$baseX = pos.method_19527();
        this.betterbiomeblend$baseY = pos.method_19528();
        this.betterbiomeblend$baseZ = pos.method_19529();
        this.betterbiomeblend$colors = new Reference2ReferenceOpenHashMap();
    }

    @Overwrite(remap=false)
    public int getColor(class_6539 resolver, int posX, int posY, int posZ) {
        byte[] colors = (byte[])this.betterbiomeblend$colors.get((Object)resolver);
        if (colors == null) {
            colors = new byte[375];
            class_4543 biomeManager = this.slice.getBiomeAccess();
            SodiumColorBlending.generateBlendedColorChunk(biomeManager, resolver, this.betterbiomeblend$baseX >> 4, this.betterbiomeblend$baseY >> 4, this.betterbiomeblend$baseZ >> 4, colors);
            this.betterbiomeblend$colors.put((Object)resolver, (Object)colors);
        }
        return this.betterbiomeblend$getColor(colors, posX, posY, posZ);
    }

    private int betterbiomeblend$getColor(byte[] colors, int x, int y, int z) {
        int blockX = class_3532.method_15340((int)(x - this.betterbiomeblend$baseX), (int)0, (int)15);
        int blockY = class_3532.method_15340((int)(y - this.betterbiomeblend$baseY), (int)0, (int)15);
        int blockZ = class_3532.method_15340((int)(z - this.betterbiomeblend$baseZ), (int)0, (int)15);
        int sectionX = blockX >> 2;
        int sectionY = blockY >> 2;
        int sectionZ = blockZ >> 2;
        int offsetX = blockX & 3;
        int offsetY = blockY & 3;
        int offsetZ = blockZ & 3;
        int weight0 = (4 - offsetX) * (4 - offsetZ) * (4 - offsetY);
        int weight1 = offsetX * (4 - offsetZ) * (4 - offsetY);
        int weight2 = (4 - offsetX) * offsetZ * (4 - offsetY);
        int weight3 = offsetX * offsetZ * (4 - offsetY);
        int weight4 = (4 - offsetX) * (4 - offsetZ) * offsetY;
        int weight5 = offsetX * (4 - offsetZ) * offsetY;
        int weight6 = (4 - offsetX) * offsetZ * offsetY;
        int weight7 = offsetX * offsetZ * offsetY;
        int index0 = 3 * ColorBlending.getCacheArrayIndex(5, sectionX, sectionY, sectionZ);
        int index1 = index0 + 3;
        int index2 = index0 + 15;
        int index3 = index0 + 18;
        int index4 = index0 + 75;
        int index5 = index0 + 78;
        int index6 = index0 + 90;
        int index7 = index0 + 93;
        long packed0 = (long)(0xFF & colors[index0 + 0]) | (long)(0xFF & colors[index0 + 1]) << 24 | (long)(0xFF & colors[index0 + 2]) << 48;
        long packed1 = (long)(0xFF & colors[index1 + 0]) | (long)(0xFF & colors[index1 + 1]) << 24 | (long)(0xFF & colors[index1 + 2]) << 48;
        long packed2 = (long)(0xFF & colors[index2 + 0]) | (long)(0xFF & colors[index2 + 1]) << 24 | (long)(0xFF & colors[index2 + 2]) << 48;
        long packed3 = (long)(0xFF & colors[index3 + 0]) | (long)(0xFF & colors[index3 + 1]) << 24 | (long)(0xFF & colors[index3 + 2]) << 48;
        long packed4 = (long)(0xFF & colors[index4 + 0]) | (long)(0xFF & colors[index4 + 1]) << 24 | (long)(0xFF & colors[index4 + 2]) << 48;
        long packed5 = (long)(0xFF & colors[index5 + 0]) | (long)(0xFF & colors[index5 + 1]) << 24 | (long)(0xFF & colors[index5 + 2]) << 48;
        long packed6 = (long)(0xFF & colors[index6 + 0]) | (long)(0xFF & colors[index6 + 1]) << 24 | (long)(0xFF & colors[index6 + 2]) << 48;
        long packed7 = (long)(0xFF & colors[index7 + 0]) | (long)(0xFF & colors[index7 + 1]) << 24 | (long)(0xFF & colors[index7 + 2]) << 48;
        long v0 = packed0 * (long)weight0;
        long v1 = packed1 * (long)weight1;
        long v2 = packed2 * (long)weight2;
        long v3 = packed3 * (long)weight3;
        long v4 = packed4 * (long)weight4;
        long v5 = packed5 * (long)weight5;
        long v6 = packed6 * (long)weight6;
        long v7 = packed7 * (long)weight7;
        long packedResult = (v0 + v1 + v2 + v3 + v4 + v5 + v6 + v7) / 64L;
        int r = (int)packedResult & 0xFF;
        int g = (int)(packedResult >> 24) & 0xFF;
        int b = (int)(packedResult >> 48) & 0xFF;
        int result = Color.makeRGBAWithFullAlpha(r, g, b);
        return result;
    }
}

